/*
** mk_syslevel.h
**
** make syslevel file - creates a SYSLEVEL file for OS/2 - prototypes
**
** (c) 1997 by Dirk Ohme
*/

/*---| structures |-----------------------------------------------------------*/
typedef _Packed struct s_Syslevel {    /* SYSLEVEL structure                  */
        unsigned short  usHdrSignature;/*  - 0xFFFF                           */
        char            szHdr[13];     /*  - "SYSLEVEL"                       */
        char            fType0;        /*  - type of structure (0x01)         */
        char            aEmpty0[17];   /*  - filled with 0x00                 */
        char            fType1;        /*  - type of structure (0x25)         */
        char            aEmpty1[6];    /*  - filled with 0x00                 */
        unsigned char   iVersion;      /*  - main version << 4                */
        char            aEmpty2[3];    /*  - filled with 0x00                 */
        char            szPrevCSD[8];  /*  - previous CSD level               */
        char            szCurrCSD[8];  /*  - current CSD level                */
        char            szName[80];    /*  - name of related program          */
        char            szCompID[26];  /*  - component ID                     */
} Syslevel, *PSyslevel;                /*-------------------------------------*/



/*------------------------------------------------------------------------------
 * SysLevelAlloc()
 * allocates a new SYSLEVEL structure
 * input:  --none--
 * output: PSyslevel    == NULL         = error
 *                      != NULL         = pointer to initialized structure
 *------------------------------------------------------------------------------
 */
PSyslevel SysLevelAlloc( void );



/*------------------------------------------------------------------------------
 * SysLevelFree()
 * frees a SYSLEVEL structure
 * input:  PSyslevel p                  - pointer to structure
 * output: int  ==  0                   = okay
 *              == -1                   = parameter error
 *------------------------------------------------------------------------------
 */
int SysLevelFree( PSyslevel p );



/*------------------------------------------------------------------------------
 * SysLevelRead()
 * reads an existing SYSLEVEL file into a given structure
 * input:  PSyslevel p                  - pointer to structure
 *         char *pszFilename            - name of SYSLEVEL file
 * output: int  ==  0                   = okay
 *              == -1                   = parameter error
 *              == -2                   = file open error
 *              == -3                   = file read error
 *------------------------------------------------------------------------------
 */
int SysLevelRead( PSyslevel p, char *pszFilename );



/*------------------------------------------------------------------------------
 * SysLevelSetVersion()
 * sets the version information in the structure
 * input:  PSyslevel p                  - pointer to SYSLEVEL structure
 *         char *pszTitle               - title string
 *         int iMajorVersion            - main version number
 *         int iMinorVersion            - minor version number
 *         int iRevision                - revision number
 *         char fPatchLevel             - patch level as character
 * output: int  ==  0                   = no error
 *              == -1                   = parameter error
 *------------------------------------------------------------------------------
 */
int SysLevelSetVersion( PSyslevel p, char *pszTitle, int iMajorVersion,
                        int iMinorVersion, int iRevision, char fPatchLevel );



/*------------------------------------------------------------------------------
 * SysLevelWrite()
 * writes the given structure to a SYSLEVEL file
 * input:  PSyslevel p                  - pointer to structure
 *         char *pszFilename            - name of SYSLEVEL file
 * output: int  ==  0                   = okay
 *              == -1                   = parameter error
 *              == -2                   = file create error
 *              == -3                   = file write error
 *------------------------------------------------------------------------------
 */
int SysLevelWrite( PSyslevel p, char *pszFilename );



/*===| end of 'mk_syslevel.h' |===============================================*/
