/*
** main.c
**
** main routine for making of OS/2 SYSLEVEL files
**
** (c) 1997 by Dirk Ohme
*/

/*---| includes |-------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "mk_syslevel.h"

/*---| definitions |----------------------------------------------------------*/
#ifndef PATCHLEVEL
#  define PATCHLEVEL    " "
#endif

/*------------------------------------------------------------------------------
 * main()
 * main routine
 * input:  int argc                     - number of parameters
 *         char *argv[]                 - parameter list
 * output: int  == 0                    - okay
 *              == 1                    - no file specified
 *              == 2                    - memory allocation error
 *              == 3                    - file creation error
 *------------------------------------------------------------------------------
 */
int main( int argc, char *argv[] )
{
        int              iRC            = 0;
        PSyslevel        pSysLevel      = NULL;
        char             szPrgName[40]  = "iODBC "VERSION" for OS/2";
        int              iMajorVersion  = 0;
        int              iMinorVersion  = 0;
        int              iRevision      = 0;
        char             fPatchLevel[2] = PATCHLEVEL;

        /*---| check parameter |---*/
        if( 2 != argc )
        {
                /*---| display error message |---*/
                fprintf( stderr, "syntax: %s <filename>\a\n", argv[0] );
                return 1;
        }
        else
        {
                char             szBuffer[80];
                register char   *psz;

                /*---| set version information |---*/
                strcpy( szBuffer, szPrgName );
                if( NULL != (psz=strtok(szBuffer, " ")) &&
                    NULL != (psz=strtok(NULL,     ".")) )
                {
                        iMajorVersion = atoi( psz );
                        if( NULL != (psz=strtok(NULL, ".")) )
                        {
                                iMinorVersion = atoi( psz );
                                if( NULL != (psz=strtok(NULL, " ")) )
                                {
                                        iRevision = atoi( psz );
                                }
                        }
                        else if( NULL != (psz=strtok(NULL, " ")) )
                        {
                                iMinorVersion = atoi( psz );
                                iRevision     = 0;
                        }
                }
        }
        printf( "%s --> %d.%02d.%d %c\n", szPrgName, iMajorVersion,
                iMinorVersion, iRevision, fPatchLevel[0] );

        /*---| allocate structure |---*/
        if( NULL == (pSysLevel=SysLevelAlloc()) )
        {
                /*---| display error message |---*/
                fprintf( stderr, "memory allocation error!\a\n" );
                return 2;
        }

        /*---| try to read previous version of file |---*/
        SysLevelRead( pSysLevel, argv[1] );

        /*---| set new information |---*/
        if( 0 > SysLevelSetVersion(pSysLevel, szPrgName, iMajorVersion,
                                   iMinorVersion, iRevision, fPatchLevel[0]) )
        {
                /*---| display error message |---*/
                fprintf( stderr, "Can't set data!\a\n" );
                iRC = 3;
        }
        else if( 0 > SysLevelWrite(pSysLevel, argv[1]) )
        {
                /*---| display error message |---*/
                fprintf( stderr, "Can't set create '%s'!\a\n", argv[1] );
                iRC = 3;
        }

        /*---| free structure |---*/
        SysLevelFree( pSysLevel );

        /*---| return status |---*/
        return iRC;
} /* main() */



/*===| end of 'main.c' |======================================================*/
