//
// test.java
//
// small testing routine checking the JDBC-ODBC-bridge
//
// (c) 1997 by Dirk Ohme, all rights reserved
//

//---| imports |---------------------------------------------------------------
import java.net.URL;
import java.sql.*;

//---| class definition |------------------------------------------------------
public class test
{
        /*
        ** constructors
        */
        public test() { /*---| nothing |---*/ }

        /*
        ** main routine
        */
        public static void main( String argv[] )
        {
                /*---| database interactions ... |---*/
                try
                {
                        //---| enable debugging |---
                        DriverManager.setLogStream( null );

                        //---| Make sure there is a JDBC-ODBC driver |---
                        //---| loaded, then try to connect  |---
                        System.out.print( "trying to open JDBC interface ..." );
                        DriverManager.setLogStream( System.out );
                        new iODBC.sql.JdbcOdbcDriver();
                        System.out.println( "JDBC up and running!" );

                        //---| make connection |---
                        String url = "jdbc:odbc:test";
                        Connection con = DriverManager.getConnection( url, "testuser", "" );

                        //---| perform a simple SQL statement |---
                        Statement stmt = con.createStatement();
                        ResultSet rs = stmt.executeQuery(
                                "select * from test"
                        );

                        //---| display results |---
                        System.out.println("Got results:");
                        while(rs.next())
                        {
                                //---| get columns |---
                                String user  = rs.getString( 1 );
                                int    age   = rs.getInt( 2 );
                                String phone = rs.getString( 3 );

                                //---| display data |---
                                System.out.print( " user  = " + user );
                                System.out.print( " age   = " + age );
                                System.out.print( " phone = " + phone );
                                System.out.println();
                        }

                        //---| close handle and connection |---
                        stmt.close();
                        con.close();
                } catch( Exception e )
                {
                        //---| display exception code |---
                        System.out.println(e.getMessage());
                        e.printStackTrace();
                }

                //---| done. |---
                System.out.println( "done." );

        } /* main() */
} /* class test */

//===| end of file |===========================================================
