//
// JdbcOdbcDriver.java
//
// JDBC-ODBC-bridge, driver class
//
// (c) 1997 by Dirk Ohme, all rights reserved
//

//---| package |---------------------------------------------------------------
package iODBC.sql;

//---| imports |---------------------------------------------------------------
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.DriverPropertyInfo;
import java.util.Properties;

//---| class JdbcOdbcDriver |--------------------------------------------------
public class JdbcOdbcDriver implements java.sql.Driver {
        /*
        ** constants
        */
        private static final int majorVersion      = 1;
        private static final int minorVersion      = 0;
        private static final boolean jdbcCompliant = false;

        /*
        ** constructors
        */
        public JdbcOdbcDriver() throws SQLException {
                //---| register driver at driver manager |---
                java.sql.DriverManager.registerDriver( this );
        }

        /*
        ** methods
        */
        //---| perform connection to database |---
        public Connection connect( String url, java.util.Properties info )
                throws SQLException {
                //---| check for 'odbc' or 'iodbc' |---
                if( !url.substring(4,10).equals(":odbc:") &&
                    !url.substring(4,11).equals(":iodbc:") )
                        return null;

                //---| open connection |---
                if( ':' == url.charAt(10) )
                        url = url.substring( 11 );
                else
                        url = url.substring( 10 );

                return new iODBC.sql.JdbcOdbcConnection(
                        info.getProperty("user"),
                        info.getProperty("password"),
                        url
                );
        }

        //---| check whether this driver is responsible or not |---
        public boolean acceptsURL( String url ) throws SQLException {
                //---| check for 'odbc' or 'iodbc' |---
                if( !url.substring(4,10).equals(":odbc:") &&
                    !url.substring(4,11).equals(":iodbc:") )
                        return false;

                //---| return success |---
                return true;
        }

        //---| check for properties necessary on connection attempt |---
        public DriverPropertyInfo[] getPropertyInfo( String url,
                                                     java.util.Properties info
                                                   ) throws SQLException {
                //---| not implemented yet! |---
                return null;
        }

        //---| return version information |---
        public int getMajorVersion() { return majorVersion; }
        public int getMinorVersion() { return minorVersion; }

        //---| check compliance against JDBC specification |---
        public boolean jdbcCompliant() { return jdbcCompliant; }

} /* class JdbcOdbcDriver */

//===| end of file |===========================================================
