.*------------------------------------------------------------------------------
.* JdbcOdbc (OS/2) - JdbcOdbcStatement
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'Class JdbcOdbcStatement'
.*------------------------------------------------------------------------------
:h3 id=class_St clear.Class JdbcOdbcStatement
:p.The purpose of this class is the representation of a SQL statement in Java.
A statement object saves and executes a SQL statement, and then represents a
result set (see class :link reftype=hd refid=class_RS.ResultSet:elink.).

:note.
A SQL statement may return only :hp2.one:ehp2. result set or none, but no more.

.*------------------------------------------------------------------------------
.*   'constructors'
.*------------------------------------------------------------------------------
:h4 id=class_St_constructors clear.constructors
:xmp.
public JdbcOdbcStatement( Connection dbConnection, J2ODBC odbcObj )
        throws SQLException;
:exmp.
:p.Called by the
:link reftype=hd refid=class_Co_createStatement.JdbcOdbcConnection&colon.&colon.createStatement():elink.
method in order to create a new statement object.

.*------------------------------------------------------------------------------
.*   'cancel()'
.*------------------------------------------------------------------------------
:h4 id=class_St_cancel clear.cancel()
:xmp.
public void cancel() throws SQLException;
:exmp.
:p.Cancels the current execution of a SQL statement. This may only take effect,
when there is a multi-threading environment.

.*------------------------------------------------------------------------------
.*   'clearWarnings()'
.*------------------------------------------------------------------------------
:h4 id=class_St_clearWarnings clear.clearWarnings()
:xmp.
public void clearWarnings() throws SQLException;
:exmp.
:p.Clears the last warning occurred from the message queue. See
:link reftype=hd refid=class_St_getWarnings.getWarnings():elink., too.

.*------------------------------------------------------------------------------
.*   'close()'
.*------------------------------------------------------------------------------
:h4 id=class_St_close clear.close()
:xmp.
public void close() throws SQLException;
:exmp.
:p.After a
:link reftype=hd refid=class_St_executeQuery.executeQuery():elink.,
:link reftype=hd refid=class_St_executeUpdate.executeUpdate():elink. or
:link reftype=hd refid=class_St_execute.execute():elink. call, this method
should be used in order to free the object and all associated data.

.*------------------------------------------------------------------------------
.*   'execute()'
.*------------------------------------------------------------------------------
:h4 id=class_St_execute clear.execute()
:xmp.
public boolean execute( String sql ) throws SQLException;
:exmp.
:p.Sends the given SQL statement :hp2.sql:ehp2. to the database server and
returns, whether there is a result set (:hp1.true:ehp1.) or not
(:hp1.false:ehp1.). The result set may be queried then by the
:link reftype=hd refid=class_St_getResultSet.getResultSet():elink. method.

.*------------------------------------------------------------------------------
.*   'executeQuery()'
.*------------------------------------------------------------------------------
:h4 id=class_St_executeQuery clear.executeQuery()
:xmp.
public java.sql.ResultSet executeQuery( String sql ) throws SQLException;
:exmp.
:p.Sends the given SQL statement :hp2.sql:ehp2. to the database server and
returns a result set.

:note.
This method may be used on queries.

.*------------------------------------------------------------------------------
.*   'executeUpdate()'
.*------------------------------------------------------------------------------
:h4 id=class_St_executeUpdate clear.executeUpdate()
:xmp.
public int executeUpdate( String sql ) throws SQLException;
:exmp.
:p.Sends the given SQL statement :hp2.sql:ehp2. to the database server. The
number returned reflects the number of rows being affected.

:note.
This method may be used on statements not returning data, like
:hp1.DELETE:ehp1., :hp1.INSERT:ehp1. or :hp1.UPDATE:ehp1..

.*------------------------------------------------------------------------------
.*   'getCursorName()'
.*------------------------------------------------------------------------------
:h4 id=class_St_getCursorName clear.getCursorName()
:xmp.
public String getCursorName() throws SQLException;
:exmp.
:p.Returns the name of the cursor currently associated with this statement
object. The
:link reftype=hd refid=class_St_setCursorName.setCursorName():elink. method
allows setting of cursor names.

.*------------------------------------------------------------------------------
.*   'getMaxFieldSize()'
.*------------------------------------------------------------------------------
:h4 id=class_St_getMaxFieldSize clear.getMaxFieldSize()
:xmp.
public int getMaxFieldSize() throws SQLException;
:exmp.
:p.Returns the maximum amount of data, returned for any column value of a SQL
data type like
:lm margin=5.:ul.
:li.BINARY,
:li.CHAR,
:li.LONGVARBINARY,
:li.LONGVARCHAR,
:li.VARBINARY,
:li.VARCHAR.
:eul.:lm margin=1.
The limit may be set by the
:link reftype=hd refid=class_St_setMaxFieldSize.setMaxFieldSize():elink.
method.

.*------------------------------------------------------------------------------
.*   'getMaxRows()'
.*------------------------------------------------------------------------------
:h4 id=class_St_getMaxRows clear.getMaxRows()
:xmp.
public int getMaxRows() throws SQLException;
:exmp.
:p.Returns the maximum numbers of rows, a result set may return. The
:link reftype=hd refid=class_St_setMaxRows.setMaxRows():elink. method can be
used to manipulate this number.

.*------------------------------------------------------------------------------
.*   'getMoreResultSet()'
.*------------------------------------------------------------------------------
:h4 id=class_St_getMoreResultSet clear.getMoreResultSet()
:xmp.
public boolean getMoreResults() throws SQLException;
:exmp.
:p.If there is more than one result set, this method may be used to address the
next one. It closes the current result set and prepares the next one for access
via :link reftype=hd refid=class_St_getResultSet.getResultSet():elink..
A return code that equals :hp1.true:ehp1. reflects, that there is another
result set, while :hp1.false:ehp1. is returned when there is no more result
set.

.*------------------------------------------------------------------------------
.*   'getQueryTimeout()'
.*------------------------------------------------------------------------------
:h4 id=class_St_getQueryTimeout clear.getQueryTimeout()
:xmp.
public int getQueryTimeout() throws SQLException;
:exmp.
:p.Returns the time (in seconds) the driver will wait on a statement to be
executed, before raising a timeout exception. A new timeout value may be set
using the
:link reftype=hd refid=class_St_setQueryTimeout.setQueryTimeout():elink.
method.

.*------------------------------------------------------------------------------
.*   'getResultSet()'
.*------------------------------------------------------------------------------
:h4 id=class_St_getResultSet clear.getResultSet()
:xmp.
public java.sql.ResultSet getResultSet() throws SQLException;
:exmp.
:p.When
:link reftype=hd refid=class_St_execute.execute():elink. returns
:hp1.true:ehp1., this method provides access to the result set.

.*------------------------------------------------------------------------------
.*   'getWarnings()'
.*------------------------------------------------------------------------------
:h4 id=class_St_getWarnings clear.getWarnings()
:xmp.
public SQLWarning getWarnings() throws SQLException;
:exmp.
:p.Returns the last warning occurred. See
:link reftype=hd refid=class_St_clearWarnings.clearWarnings():elink., too.

.*------------------------------------------------------------------------------
.*   'getUpdateCount()'
.*------------------------------------------------------------------------------
:h4 id=class_St_getUpdateCount clear.getUpdateCount()
:xmp.
public int getUpdateCount() throws SQLException;
:exmp.
:p.The number affected by a :hp1.DELETE:ehp1., :hp1.INSERT:ehp1. or
:hp1.UPDATE:ehp1. command (see
:link reftype=hd refid=class_St_execute.execute():elink. or
:link reftype=hd refid=class_St_executeUpdate.executeUpdate():elink.) can be
gathered using this method.

.*------------------------------------------------------------------------------
.*   'setCursorName()'
.*------------------------------------------------------------------------------
:h4 id=class_St_setCursorName clear.setCursorName()
:xmp.
public void setCursorName( String name ) throws SQLException;
:exmp.
:p.Defines the name of the SQL cursor associated with the next execution of
a SQL statement. The name will be set to :hp2.name:ehp2.. The current name of
the cursor may be queried by
:link reftype=hd refid=class_St_getCursorName.getCursorName():elink..

.*------------------------------------------------------------------------------
.*   'setEscapeProcessing()'
.*------------------------------------------------------------------------------
:h4 id=class_St_setEscapeProcessing clear.setEscapeProcessing()
:xmp.
public void setEscapeProcessing( boolean enable ) throws SQLException;
:exmp.
:p.If enabled (:hp2.enable:ehp2. == :hp1.true:ehp1.) escape sequences in SQL
statements will be processed (this is the default). If disabled, there is no
extra processing on such sequences.

.*------------------------------------------------------------------------------
.*   'setMaxFieldSize()'
.*------------------------------------------------------------------------------
:h4 id=class_St_setMaxFieldSize clear.setMaxFieldSize()
:xmp.
public void setMaxFieldSize( int max ) throws SQLException;
:exmp.
:p.Sets the limit (in bytes) to the value of :hp2.max:ehp2. on columns of the
SQL data types
:lm margin=5.:ul.
:li.BINARY,
:li.CHAR,
:li.LONGVARBINARY,
:li.LONGVARCHAR,
:li.VARBINARY,
:li.VARCHAR.
:eul.:lm margin=1.
The limit may be queried by the
:link reftype=hd refid=class_St_setMaxFieldSize.getMaxFieldSize():elink.
method.

.*------------------------------------------------------------------------------
.*   'setMaxRows()'
.*------------------------------------------------------------------------------
:h4 id=class_St_setMaxRows clear.setMaxRows()
:xmp.
public void setMaxRows( int max ) throws SQLException;
:exmp.
:p.Sets the maximum number of rows returned by a result set to :hp2.max:ehp2..
The current maximum number of rows is returned by the
:link reftype=hd refid=class_St_getMaxRows.getMaxRows():elink. method.

.*------------------------------------------------------------------------------
.*   'setQueryTimeout()'
.*------------------------------------------------------------------------------
:h4 id=class_St_setQueryTimeout clear.setQueryTimeout()
:xmp.
public void setQueryTimeout( int seconds ) throws SQLException;
:exmp.
:p.Sets the timeout value on SQL statement processing to :hp2.seconds:ehp2.
seconds. See
:link reftype=hd refid=class_St_getQueryTimeout.getQueryTimeout():elink.,
too.

.*------------------------------------------------------------------------------
