.*------------------------------------------------------------------------------
.* JdbcOdbc (OS/2) - JdbcOdbcResultSetMetaData
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'Class JdbcOdbcResultSetMetaData'
.*------------------------------------------------------------------------------
:h3 id=class_RSMD clear.Class JdbcOdbcResultSetMetaData
:p.A object of this class provides informations about types and properties of
columns of the result set.

.*------------------------------------------------------------------------------
.*   'definitions'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_definitions clear.definitions
:p.The following definitions are used at the
:link reftype=hd refid=class_RSMD_isNullable.isNullable():elink. method&colon.
:lm margin=5.:ul.
:li.:hp2.columnNoNulls:ehp2. - column must not contain NULL values
:li.:hp2.columnNullable:ehp2. - column may contain NULL values
:li.:hp2.columnNullableUnknown:ehp2. - it's not certain whether the column may
contain NULL values or not
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'constructors'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_constructors clear.constructors
:xmp.
public JdbcOdbcResultSetMetaData( J2ODBC newDb );
:exmp.
:p.Called by the
:link reftype=hd refid=class_RS_getMetaData.JdbcOdbcResultSet&colon.&colon.getMetaData():elink.
method in order to create a new result set meta data object.

.*------------------------------------------------------------------------------
.*   'getCatalogName()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_getCatalogName clear.getCatalogName()
:xmp.
public String getCatalogName( int columnIndex ) throws SQLException;
:exmp.
:p.Returns the name of the catalog containing the table with the specified
column (1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.).

.*------------------------------------------------------------------------------
.*   'getColumnCount()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_getColumnCount clear.getColumnCount()
:xmp.
public int getColumnCount() throws SQLException;
:exmp.
:p.Returns the number of columns available in the result set.

.*------------------------------------------------------------------------------
.*   'getColumnDisplaySize()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_getColumnDisplaySize clear.getColumnDisplaySize()
:xmp.
public int getColumnDisplaySize( int columnIndex ) throws SQLException;
:exmp.
:p.Returns the maximum width in display of the specified column
(1 <= :hp2.columnIndex:ehp2. <=
:link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.).

.*------------------------------------------------------------------------------
.*   'getColumnLabel()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_getColumnLabel clear.getColumnLabel()
:xmp.
public String getColumnLabel( int columnIndex ) throws SQLException;
:exmp.
:p.Returns the suggested column label of the specified column
(1 <= :hp2.columnIndex:ehp2. <=
:link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.).

.*------------------------------------------------------------------------------
.*   'getColumnName()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_getColumnName clear.getColumnName()
:xmp.
public String getColumnName( int columnIndex ) throws SQLException;
:exmp.
:p.Returns the name of the specified column (1 <= :hp2.columnIndex:ehp2. <=
:link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.).

.*------------------------------------------------------------------------------
.*   'getColumnType()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_getColumnType clear.getColumnType()
:xmp.
public int getColumnType( int columnIndex ) throws SQLException;
:exmp.
:p.Returns the JDBC data type of the specified column
(1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.).
See :hp1.Java.sql.Types:ehp1. for a description of these types.

.*------------------------------------------------------------------------------
.*   'getColumnTypeName()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_getColumnTypeName clear.getColumnTypeName()
:xmp.
public String getColumnTypeName( int columnIndex ) throws SQLException;
:exmp.
:p.Returns the name of the JDBC data type of the specified column
(1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.).
See :hp1.Java.sql.Types:ehp1. for a description of these types.

.*------------------------------------------------------------------------------
.*   'getPrecision()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_getPrecision clear.getPrecision()
:xmp.
public int getPrecision( int columnIndex ) throws SQLException;
:exmp.
:p.Returns the precision of the specified column (1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.).

.*------------------------------------------------------------------------------
.*   'getScale()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_getScale clear.getScale()
:xmp.
public int getScale( int columnIndex ) throws SQLException;
:exmp.
:p.Returns the scale of the specified column (1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.).

.*------------------------------------------------------------------------------
.*   'getSchemaName()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_getSchemaName clear.getSchemaName()
:xmp.
public String getSchemaName( int columnIndex ) throws SQLException;
:exmp.
:p.Returns the schema name of the table containing the specified column
(1 <= :hp2.columnIndex:ehp2. <=
:link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.).

.*------------------------------------------------------------------------------
.*   'getTableName()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_getTableName clear.getTableName()
:xmp.
public String getTableName( int columnIndex ) throws SQLException;
:exmp.
:p.Returns the name of the table containing the specified column
(1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.).

.*------------------------------------------------------------------------------
.*   'isAutoIncrement()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_isAutoIncrement clear.isAutoIncrement()
:xmp.
public boolean isAutoIncrement( int columnIndex ) throws SQLException;
:exmp.
:p.Returns :hp1.true:ehp1. if the specified column (1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.)
increments automatically on an INSERT or not.

:note.
Such columns normally are read-only.

.*------------------------------------------------------------------------------
.*   'isCurrency()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_isCurrency clear.isCurrency()
:xmp.
public boolean isCurrency( int columnIndex ) throws SQLException;
:exmp.
:p.Returns :hp1.true:ehp1. if the specified column (1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.)
represents a cash value.

.*------------------------------------------------------------------------------
.*   'isCaseSensitive()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_isCaseSensitive clear.isCaseSensitive()
:xmp.
public boolean isCaseSensitive( int columnIndex ) throws SQLException;
:exmp.
:p.Returns :hp1.true:ehp1. if the specified column (1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.)
is case-sensitive. Normally character based columns are case-sensitive.

.*------------------------------------------------------------------------------
.*   'isDefinitelyWriteable()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_isDefinitelyWritable clear.isDefinitelyWritable()
:xmp.
public boolean isDefinitelyWritable( int columnIndex ) throws SQLException;
:exmp.
:p.Returns :hp1.true:ehp1. if the specified column (1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.)
can be modified. This method assures the writability of a column.

.*------------------------------------------------------------------------------
.*   'isNullable()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_isNullable clear.isNullable()
:xmp.
public int isNullable( int columnIndex ) throws SQLException;
:exmp.
:p.Returns whether if the specified column (1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.)
can contain NULL values or not&colon.
:lm margin=5.:ul.
:li.:hp2.columnNoNulls:ehp2. - column must not contain NULL values
:li.:hp2.columnNullable:ehp2. - column may contain NULL values
:li.:hp2.columnNullableUnknown:ehp2. - it's not certain whether the column may
contain NULL values or not
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'isReadOnly()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_isReadOnly clear.isReadOnly()
:xmp.
public boolean isReadOnly( int columnIndex ) throws SQLException;
:exmp.
:p.Returns :hp1.true:ehp1. if the specified column (1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.)
is read-only and may not be modified.

.*------------------------------------------------------------------------------
.*   'isSearchable()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_isSearchAble clear.isSearchAble()
:xmp.
public boolean isSearchable( int columnIndex ) throws SQLException;
:exmp.
:p.Returns :hp1.true:ehp1. if the specified column (1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.)
may be included in a WHERE clause of a SQL statement.

.*------------------------------------------------------------------------------
.*   'isSigned()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_isSigned clear.isSigned()
:xmp.
public boolean isSigned( int columnIndex ) throws SQLException;
:exmp.
:p.Returns :hp1.true:ehp1. if the specified column (1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.)
contains signed values. Normally, only numerical data columns can contain
signed values.

.*------------------------------------------------------------------------------
.*   'isWriteable()'
.*------------------------------------------------------------------------------
:h4 id=class_RSMD_isWritable clear.isWritable()
:xmp.
public boolean isWritable( int columnIndex ) throws SQLException;
:exmp.
:p.Returns :hp1.true:ehp1. if the specified column (1 <= :hp2.columnIndex:ehp2.
<= :link reftype=hd refid=class_RSMD_getColumnCount.getColumnCount():elink.)
may be modified.

.*------------------------------------------------------------------------------
