.*------------------------------------------------------------------------------
.* JdbcOdbc (OS/2) - JdbcOdbcResultSet
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'Class JdbcOdbcResultSet'
.*------------------------------------------------------------------------------
:h3 id=class_RS clear.Class JdbcOdbcResultSet
:p.Every time a SQL statement executed provides results, this class is used
to provide an access to that data. There is a cursor, initiated to the begin
(some may say&colon. the first row) of the resulting data. The first (next)
row of that data is accessed by using the
:link reftype=hd refid=class_RS_next.next():elink. method, columns of the row
may be gathered using the
:link reftype=hd refid=class_RS_get.get...():elink. methods.

.*------------------------------------------------------------------------------
.*   'constructors'
.*------------------------------------------------------------------------------
:h4 id=class_RS_constructors clear.constructors
:xmp.
public JdbcOdbcResultSet( J2ODBC newDb );
:exmp.
:p.Used by the various :hp1.execute...():ehp1. methods in the classes

:lm margin=5.:ul.
:li.:link reftype=hd refid=class_CS.JdbcOdbcCallableStatement:elink.,
:li.:link reftype=hd refid=class_PS.JdbcOdbcPreparedStatement:elink. and
:li.:link reftype=hd refid=class_St.JdbcOdbcStatement:elink..
:eul.:lm margin=1.

:p.:hp2.newDb:ehp2. is a reference to the currently ODBC interface used.

.*------------------------------------------------------------------------------
.*   'clearWarnings()'
.*------------------------------------------------------------------------------
:h4 id=class_RS_clearWarnings clear.clearWarnings()
:xmp.
public void clearWarnings() throws SQLException;
:exmp.
:p.Clear warnings in chain list.

.*------------------------------------------------------------------------------
.*   'close()'
.*------------------------------------------------------------------------------
:h4 id=class_RS_close clear.close()
:xmp.
public void close() throws SQLException;
:exmp.
:p.Closes the cursor associated with the result set. There is then no longer
access to the results.

.*------------------------------------------------------------------------------
.*   'findColumn()'
.*------------------------------------------------------------------------------
:h4 id=class_RS_findColumn clear.findColumn()
:xmp.
public int findColumn( String columnName ) throws SQLException;
:exmp.
:p.Resolves the name :hp2.columnName:ehp2. and tries to get the appropriate
column index (starting with 1) in the result set. An exception is raised if
the name could not be resolved.

.*------------------------------------------------------------------------------
.*   'get...()'
.*------------------------------------------------------------------------------
:h4 id=class_RS_get clear.get...()
:xmp.
public boolean getBoolean( String columnName ) throws SQLException;
public boolean getBoolean( int parameterIndex ) throws SQLException;

public byte getByte( String columnName ) throws SQLException;
public byte getByte( int parameterIndex ) throws SQLException:

public byte[] getBytes( String columnName ) throws SQLException;
public byte[] getBytes( int parameterIndex ) throws SQLException;

public java.sql.Date getDate( String columnName ) throws SQLException;
public java.sql.Date getDate( int parameterIndex ) throws SQLException;

public double getDouble( String columnName ) throws SQLException;
public double getDouble( int parameterIndex ) throws SQLException;

public float getFloat( String columnName ) throws SQLException;
public float getFloat( int parameterIndex ) throws SQLException;

public int getInt( String columnName ) throws SQLException;
public int getInt( int parameterIndex ) throws SQLException;

public long getLong( String columnName ) throws SQLException;
public long getLong( int parameterIndex ) throws SQLException;

public Bignum getBignum( String columnName, int scale ) throws SQLException;
public Bignum getBignum( int parameterIndex, int scale ) throws SQLException;

public short getShort( String columnName ) throws SQLException;
public short getShort( int parameterIndex ) throws SQLException;

public String getString( String columnName ) throws SQLException;
public String getString( int parameterIndex ) throws SQLException;

public java.sql.Time getTime( String columnName ) throws SQLException;
public java.sql.Time getTime( int parameterIndex ) throws SQLException;

public java.sql.Timestamp getTimestamp( String columnName )
        throws SQLException;
public java.sql.Timestamp getTimestamp( int parameterIndex )
        throws SQLException;
:exmp.
:p.Returns the contents of the parameter with index number
:hp2.parameterIndex:ehp2. (starting with 1) or with column name
:hp2.columnName:ehp2. in the appropriate format.

:p.The following table shows which methods matches SQL data types very
closely - on some databases it may be possible to specify a completely
other SQL data type for a column/parameter, like CHAR for BIT.

:table cols='25 54'.
:row.:c.method               :c.SQL data type(s)
:row.:c.getBoolean()         :c.BIT
:row.:c.getByte()            :c.TINYINT
:row.:c.getBytes()           :c.BINARY, VARBINARY
:row.:c.getDate()            :c.DATE
:row.:c.getDouble()          :c.DOUBLE
:row.:c.getFloat()           :c.FLOAT
:row.:c.getInt()             :c.INTEGER
:row.:c.getLong()            :c.BIGINT
:row.:c.getBignum()          :c.NUMERIC
:row.:c.getShort()           :c.SMALLINT
:row.:c.getString()          :c.CHAR, VARCHAR, LONGVARCHAR
:row.:c.getTime()            :c.TIME
:row.:c.getTimestamp()       :c.TIMESTAMP
:etable.

.*------------------------------------------------------------------------------
.*   'getAsciiStream()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_getAsciiStream clear.getAsciiStream()
:xmp.
public java.io.InputStream getAsciiStream( int columnIndex )
        throws SQLException;
public java.io.InputStream getAsciiStream( String columnName )
        throws SQLException;
:exmp.
:p.On large data (SQL LONGVARCHAR) this method ables to receive the result
data by a stream. :hp2.columnIndex:ehp2. (starting with 1) specifies the
parameter (by index number), which will be returned. Same does
:hp2.columnName:ehp2. for the other method.

:note.
Data is transmitted as ASCII characters.

.*------------------------------------------------------------------------------
.*   'getBinaryStream()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_getBinaryStream clear.getBinaryStream()
:xmp.
public java.io.InputStream getBinaryStream( int columnIndex )
        throws SQLException;
public java.io.InputStream getBinaryStream( String columnName )
        throws SQLException;
:exmp.
:p.On large data (SQL LONGVARBINARY) this method ables to receive the result
data by a stream. :hp2.columnIndex:ehp2. (starting with 1) specifies the
parameter (by index number), which will be returned. Same does
:hp2.columnName:ehp2. for the other method.

:note.
Data is transmitted as binary data.

.*------------------------------------------------------------------------------
.*   'getCursorName()'
.*------------------------------------------------------------------------------
:h4 id=class_RS_getCursorName clear.getCursorName()
:xmp.
public String getCursorName() throws SQLException;
:exmp.
:p.Returns the name of the cursor associated with the result set.

.*------------------------------------------------------------------------------
.*   'getMetaData()'
.*------------------------------------------------------------------------------
:h4 id=class_RS_getMetaData clear.getMetaData()
:xmp.
public ResultSetMetaData getMetaData() throws SQLException;
:exmp.
:p.Returns an object to a
:link reftype=hd refid=class_RSMD.JdbcOdbcResultSetMetaData:elink. class. This
object can be used to get further informations about a result set.

.*------------------------------------------------------------------------------
.*   'getObject()'
.*------------------------------------------------------------------------------
:h4 id=class_RS_getObject clear.getObject()
:xmp.
public Object getObject( int columnIndex ) throws SQLException;
public Object getObject( String columnName ) throws SQLException;

public Object getObject( int columnIndex, int targetSqlType )
        throws SQLException;
public Object getObject( String columnName, int targetSqlType )
        throws SQLException;

public Object getObject( int columnIndex, int targetSqlType, int scale )
        throws SQLException;
public Object getObject( String columnName, int targetSqlType, int scale )
        throws SQLException;
:exmp.
:p.Returns the contents of the parameter with index number
:hp2.columnIndex:ehp2. (starting with 1) or with column name
:hp2.columnName:ehp2. as object. The type of the object depends on the SQL
data type of the column in the result row or on the SQL type value
:hp2.targetSqlType:ehp2. (see :hp1.Java.sql.Types:ehp1.). The additional
parameter :hp2.scale:ehp2. may specify a scaling factor.

.*------------------------------------------------------------------------------
.*   'getUnicodeStream()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_getUnicodeStream clear.getUnicodeStream()
:xmp.
public java.io.InputStream getUnicodeStream( int columnIndex )
        throws SQLException;
public java.io.InputStream getUnicodeStream( String columnName )
        throws SQLException;
:exmp.
:p.On large data (SQL LONGVARCHAR) this method ables to receive the result
data by a stream. :hp2.columnIndex:ehp2. (starting with 1) specifies the
parameter (by index number), which will be returned. Same does
:hp2.columnName:ehp2. for the other method.

:note.
Data is transmitted as Unicode characters.

.*------------------------------------------------------------------------------
.*   'getWarnings()'
.*------------------------------------------------------------------------------
:h4 id=class_RS_getWarnings clear.getWarnings()
:xmp.
public SQLWarning getWarnings() throws SQLException;
:exmp.
:p.Returns the next warning message stored in the chain, which has been caused
by this class.

.*------------------------------------------------------------------------------
.*   'next()'
.*------------------------------------------------------------------------------
:h4 id=class_RS_next clear.next()
:xmp.
public boolean next() throws SQLException;
:exmp.
:p.In order to get the first/next row of a result set, this method has to be
called.

.*------------------------------------------------------------------------------
.*   'wasNull()'
.*------------------------------------------------------------------------------
:h4 id=class_RS_wasNull clear.wasNull()
:xmp.
public boolean wasNull() throws SQLException;
:exmp.
:p.Returns whether the last access
(see :link reftype=hd refid=class_RS_get.get...():elink.) to a column of a
result row refered to a NULL value or not.

.*------------------------------------------------------------------------------
