.*------------------------------------------------------------------------------
.* JdbcOdbc (OS/2) - JdbcOdbcPreparedStatement
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'Class JdbcOdbcPreparedStatement'
.*------------------------------------------------------------------------------
:h3 id=class_PS clear.Class JdbcOdbcPreparedStatement
:p.Whenever there is the need to pre-compile a SQL statement, this class may
be used. It allows to set the :hp2.IN:ehp2. parameters on such statements, i.e.
such statement may contain placeholders which are filled after pre-compilation
but before execution. See :link reftype=hd refid=class_PS_set.set...():elink.
for details.

.*------------------------------------------------------------------------------
.*   'constructors'
.*------------------------------------------------------------------------------
:h4 id=class_PS_constructors clear.constructors
:xmp.
public JdbcOdbcPreparedStatement( Connection dbConnection,
                                  J2ODBC odbcObj,
                                  String sql ) throws SQLException;
:exmp.
:p.Normally called by the
:link reftype=hd refid=class_Co_prepareStatement.JdbcOdbcConnection&colon.&colon.prepareStatement():elink.
method. :hp2.dbConnection:ehp2. reflects the current database connection
object, :hp2.odbcObj:ehp2. the current ODBC interface object, and
:hp2.sql:ehp2. the SQL statement to be prepared.

.*------------------------------------------------------------------------------
.*   'clearParameter()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_clearParameter clear.clearParameter()
:xmp.
public void clearParameters() throws SQLException;
:exmp.
:p.Resets all parameters.

.*------------------------------------------------------------------------------
.*   'execute()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_execute clear.execute()
:xmp.
public boolean execute() throws SQLException;
:exmp.
:p.Executes the prepared statement. If one or more
:link reftype=hd refid=class_RS.result set(s):elink. is/are available, a
:hp1.true:ehp1. value is returned.

.*------------------------------------------------------------------------------
.*   'executeQuery()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_executeQuery clear.executeQuery()
:xmp.
public ResultSet executeQuery() throws SQLException;
:exmp.
:p.Executes the prepared statement and returns a
:link reftype=hd refid=class_RS.result set:elink..

.*------------------------------------------------------------------------------
.*   'executeUpdate()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_executeUpdate clear.executeUpdate()
:xmp.
public int executeUpdate() throws SQLException;
:exmp.
:p.Executes the prepared statement, that does not return any data, like
DELETE, INSERT or UPDATE.

.*------------------------------------------------------------------------------
.*   'set...()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_set clear.set...()
:xmp.
public void setBoolean( int parameterIndex, boolean x ) throws SQLException;
public void setByte( int parameterIndex, byte x ) throws SQLException;
public void setBytes( int parameterIndex, byte x[] ) throws SQLException;
public void setDate( int parameterIndex, java.sql.Date x ) throws SQLException;
public void setDouble( int parameterIndex, double x ) throws SQLException;
public void setFloat( int parameterIndex, float x ) throws SQLException;
public void setInt( int parameterIndex, int x ) throws SQLException;
public void setLong( int parameterIndex, long x ) throws SQLException;
public void setBignum( int parameterIndex, Bignum x ) throws SQLException;
public void setShort( int parameterIndex, short x ) throws SQLException;
public void setString( int parameterIndex, String x ) throws SQLException;
public void setTime( int parameterIndex, java.sql.Time x ) throws SQLException;
public void setTimestamp( int parameterIndex, java.sql.Timestamp x )
        throws SQLException;
:exmp.
:p.Sets a :hp1.IN:ehp1. parameter with index number :hp2.parameterIndex:ehp2.
(starting with 1) to :hp2.x:ehp2.. The following table show dependencies
between methods and SQL data types&colon.

:table cols='25 54'.
:row.:c.method               :c.SQL data type(s)
:row.:c.setBoolean()         :c.BIT
:row.:c.setByte()            :c.TINYINT
:row.:c.setBytes()           :c.BINARY, VARBINARY
:row.:c.setDate()            :c.DATE
:row.:c.setDouble()          :c.DOUBLE
:row.:c.setFloat()           :c.FLOAT
:row.:c.setInt()             :c.INTEGER
:row.:c.setLong()            :c.BIGINT
:row.:c.setBignum()          :c.NUMERIC
:row.:c.setShort()           :c.SMALLINT
:row.:c.setString()          :c.CHAR, VARCHAR, LONGVARCHAR
:row.:c.setTime()            :c.TIME
:row.:c.setTimestamp()       :c.TIMESTAMP
:etable.

:note.
Depending on the database software, more than one method (SQL data type) may
be used for an :hp1.IN:ehp1. parameter.

.*------------------------------------------------------------------------------
.*   'setNull()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_setNull clear.setNull()
:xmp.
public void setNull( int parameterIndex, int sqlType ) throws SQLException;
:exmp.
:p.Sets an :hp1.IN:ehp1. parameter with index number :hp2.parameterIndex:ehp2.
(starting with 1) to :hp1.NULL:ehp1.. The data type for the :hp1.IN:ehp1.
parameter must be specified by :hp2.sqlType:ehp2. - see
:hp1.Java.sql.Types:ehp1. for details.

.*------------------------------------------------------------------------------
.*   'setObject()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_setObject clear.setObject()
:xmp.
public void setObject( int parameterIndex, Object x ) throws SQLException;
public void setObject( int parameterIndex, Object x, int targetSqlType )
        throws SQLException;
public void setObject( int parameterIndex, Object x, int targetSqlType,
                       int scale ) throws SQLException;
:exmp.
:p.Sets a :hp1.IN:ehp1. parameter with index number :hp2.parameterIndex:ehp2.
(starting with 1) to :hp2.x:ehp2.. :hp2.targetSqlType:ehp2. specifies the
target SQL data type (see :hp1.Java.sql.Types:ehp1.), :hp2.scale:ehp2. is an
optional scaling factor.

:note.
If there is no :hp2.targetSqlType:ehp2. parameter, the appropriate SQL data
type is converted by the identified Java data type of :hp2.x:ehp2..

.*------------------------------------------------------------------------------
.*   'setAsciiStream()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_setAsciiStream clear.setAsciiStream()
:xmp.
public void setAsciiStream( int parameterIndex, java.io.InputStream x,
                            int length ) throws SQLException;
:exmp.
:p.On large data (SQL LONGVARCHAR) this method ables to send the parameter
data by a stream. :hp2.parameterIndex:ehp2. (starting with 1) specifies the
parameter (by index number), which has to be set. :hp2.x:ehp2. refers to
the stream which sends the data. In :hp2.length:ehp2. the number of bytes
available in the stream is set.

:note.
Data is transmitted as ASCII characters.

.*------------------------------------------------------------------------------
.*   'setBinaryStream()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_setBinaryStream clear.setBinaryStream()
:xmp.
public void setBinaryStream( int parameterIndex, java.io.InputStream x,
                             int length ) throws SQLException;
:exmp.
:p.On large data (SQL LONGVARBINARY) this method ables to send the parameter
data by a stream. :hp2.parameterIndex:ehp2. (starting with 1) specifies the
parameter (by index number), which has to be set. :hp2.x:ehp2. refers to
the stream which sends the data. In :hp2.length:ehp2. the number of bytes
available in the stream is set.

:note.
Data is transmitted as binary data.

.*------------------------------------------------------------------------------
.*   'setUnicodeStream()'
.*------------------------------------------------------------------------------
:h4 id=class_PS_setUnicodeStream clear.setUnicodeStream()
:xmp.
public void setUnicodeStream( int parameterIndex, java.io.InputStream x,
                              int length ) throws SQLException;
:exmp.
:p.On large data (SQL LONGVARCHAR) this method ables to send the parameter
data by a stream. :hp2.parameterIndex:ehp2. (starting with 1) specifies the
parameter (by index number), which has to be set. :hp2.x:ehp2. refers to
the stream which sends the data. In :hp2.length:ehp2. the number of bytes
available in the stream is set.

:note.
Data is transmitted as Unicodes.

.*------------------------------------------------------------------------------
