.*------------------------------------------------------------------------------
.* JdbcOdbc (OS/2) - JdbcOdbcDriver
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'Class JdbcOdbcDriver'
.*------------------------------------------------------------------------------
:h3 id=class_Dr clear.Class JdbcOdbcDriver
:p.This class implements the base on which the other classes of the JDBC-ODBC
bridge refer to. In order to access the JDBC-ODBC bridge, the JDBC driver
manager has to be notified to use it. One way is to do so is to create an
empty object of this class&colon.
:xmp.
        new iODBC.sql.JdbcOdbcDriver();
:exmp.

.*------------------------------------------------------------------------------
.*   'constructors'
.*------------------------------------------------------------------------------
:h4 id=class_Dr_constructors clear.constructors
:xmp.
public JdbcOdbcDriver() throws SQLException;
:exmp.
:p.Registers the JDBC-ODBC bridge at the JDBC driver manager. A following
:hp1.DriverManager&colon.&colon.getConnection():ehp1. call may then return
an object to the bridge.

.*------------------------------------------------------------------------------
.*   'acceptsURL()'
.*------------------------------------------------------------------------------
:h4 id=class_Dr_acceptsURL clear.acceptsURL()
:xmp.
public boolean acceptsURL( String url ) throws SQLException;
:exmp.
:p.Returns :hp1.true:ehp1. if the given uniform resource locator :hp2.url:ehp2.
can be resolved by this driver. On the JDBC-ODBC bridge such URLs has to
start with :hp4.jdbc&colon.odbc&colon.:ehp4. or
:hp4.jdbc&colon.iodbc&colon.:ehp4. in order to be resolved.

.*------------------------------------------------------------------------------
.*   'connect()'
.*------------------------------------------------------------------------------
:h4 id=class_Dr_connect clear.connect()
:xmp.
public Connection connect( String url, java.util.Properties info )
        throws SQLException;
:exmp.
:p.This method is normally called by the JDBC driver manager in order to
perform a login to a given database or data source. :hp2.url:ehp2. is a
string identifying the data source; it is of the form
:hp2.jdbc&colon.:ehp2.:hp3.type:ehp3.:hp2.&colon.:ehp2.:hp3.sub_type:ehp3..

:lm margin=5.:ul.
:li.jdbc - is a fixed prefix
:li.type - specifies the type of JDBC driver to be used; the JDBC-ODBC bridge
registers the type :hp4.odbc:ehp4. and :hp4.iodbc:ehp4.
:li.sub_type - a JDBC driver may distinguish between sub-types or may require
additional parameters. The JDBC-ODBC bridge expects the name of the ODBC source
as :hp1.sub_type:ehp1. parameter
:eul.:lm margin=1.

:note.
For connecting to the ODBC source :hp1.test:ehp1. via JDBC-ODBC bridge, use
the :hp2.url:ehp2. = :hp4.jdbc&colon.odbc&colon.test:ehp4..

:p.:hp2.info:ehp2. is a list of properties necessary during login. Currently
the following properties are used&colon.

:lm margin=5.:ul.
:li.:hp1.user:ehp1. - user ID for database login
:li.:hp1.password:ehp1. - password for database login
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'getMajorVersion()'
.*------------------------------------------------------------------------------
:h4 id=class_Dr_getMajorVersion clear.getMajorVersion()
:xmp.
public int getMajorVersion();
:exmp.
:p.Returns the major version number of the driver.

.*------------------------------------------------------------------------------
.*   'getMinorVersion()'
.*------------------------------------------------------------------------------
:h4 id=class_Dr_getMinorVersion clear.getMinorVersion()
:xmp.
public int getMinorVersion();
:exmp.
:p.Returns the minor version number of the driver.

.*------------------------------------------------------------------------------
.*   'getPropertyInfo()'
.*------------------------------------------------------------------------------
:h4 id=class_Dr_getPropertyInfo clear.getPropertyInfo()
:xmp.
public DriverPropertyInfo[] getPropertyInfo( String url,
                                             java.util.Properties info
                                           ) throws SQLException;
:exmp.
:p.Returns a list of required properties necessary for database login for the
given :hp2.url:ehp2. and property list :hp2.info:ehp2..

.*------------------------------------------------------------------------------
.*   'jdbcCompliant()'
.*------------------------------------------------------------------------------
:h4 id=class_Dr_jdbcCompliant clear.jdbcCompliant()
:xmp.
public boolean jdbcCompliant();
:exmp.
:p.Returns whether the driver is JDBC compliant or not. A result value of
:hp1.true:ehp1. reflects that the driver has been proved for

:lm margin=5.:ul.
:li.full support of the JDBC API
:li.full support of the SQL 92 Entry level
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
