.*------------------------------------------------------------------------------
.* JdbcOdbc (OS/2) - JdbcOdbcConnection
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'Class JdbcOdbcConnection'
.*------------------------------------------------------------------------------
:h3 id=class_Co clear.Class JdbcOdbcConnection
:p.In order to perform database interactions, a connection has to be
established. This class is the main part on database interactions. From within
there could be statements prepared and executed, and result sets gathered.

.*------------------------------------------------------------------------------
.*   'definitions'
.*------------------------------------------------------------------------------
:h4 id=class_Co_definitions clear.definitions
:p.The following definitions are available for
:link reftype=hd refid=class_Co_getTransactionIsolation.getTransactionIsolation():elink. and
:link reftype=hd refid=class_Co_setTransactionIsolation.setTransactionIsolation():elink.&colon.
:lm margin=5.:ul.
:li.TRANSACTION_NONE - transactions are not supported
:li.TRANSACTION_READ_UNCOMMITTED - dirty reads are done
:li.TRANSACTION_READ_COMMITTED - only reads on the current row are repeatable
:li.TRANSACTION_REPEATABLE_READ - reads on all rows of a result are repeatable
:li.TRANSACTION_SERIALIZEABLE - reads on all rows of a transaction are
repeatable
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'constructors'
.*------------------------------------------------------------------------------
:h4 id=class_Co_constructors clear.constructors
:xmp.
public JdbcOdbcConnection( String user, String passwd, String db )
        throws SQLException;
:exmp.
:p.Used by the
:link reftype=hd refid=class_Dr.JdbcOdbcDriver:elink. class to perform a
database login on database source :hp2.db:ehp2., using user name
:hp2.user:ehp2. and password :hp2.passwd:ehp2..

.*------------------------------------------------------------------------------
.*   'destructors'
.*------------------------------------------------------------------------------
:h4 id=class_Co_destructors clear.destructors
:xmp.
public void finalize() throws SQLException;
:exmp.
:p.On garbage collection this method is used to close the database connection.
See :link reftype=hd refid=class_Co_close.close():elink., too.

.*------------------------------------------------------------------------------
.*   'clearWarnings()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_clearWarnings clear.clearWarnings()
:xmp.
public void clearWarnings() throws SQLException;
:exmp.
:p.Clears the last warning occurred from the message queue. See
:link reftype=hd refid=class_Co_getWarnings.getWarnings():elink., too.

.*------------------------------------------------------------------------------
.*   'close()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_close clear.close()
:xmp.
public void close() throws SQLException;
:exmp.
:p.In order to close a connection directly without waiting for the garbage
collection, this method may be called. After successful termination, no
further actions can be done by this object - the next step should be the
invalidation of the object reference (setting the variable :hp1.null:ehp1.).

.*------------------------------------------------------------------------------
.*   'commit()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_commit clear.commit()
:xmp.
public void commit() throws SQLException;
:exmp.
:p.Validates all previous transactions, i.e. all changes done are saved. See
:link reftype=hd refid=class_Co_rollback.rollback():elink., too.

.*------------------------------------------------------------------------------
.*   'createStatement()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_createStatement clear.createStatement()
:xmp.
public Statement createStatement() throws SQLException;
:exmp.
:p.Get a new object, which can obtain a SQL statement. See the
:link reftype=hd refid=class_St.JdbcOdbcStatement:elink. class for more
details.

.*------------------------------------------------------------------------------
.*   'getAutoClose()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_getAutoClose clear.getAutoClose()
:xmp.
public boolean getAutoClose() throws SQLException;
:exmp.
:p.Returns the state of the 'automatic close of cursors on termination'
mechanism. See
:link reftype=hd refid=class_Co_setAutoClose.setAutoClose():elink., too.

.*------------------------------------------------------------------------------
.*   'getAutoCommit()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_getAutoCommit clear.getAutoCommit()
:xmp.
public boolean getAutoCommit() throws SQLException;
:exmp.
:p.Returns the state of the :hp1.AUTOCOMMIT:ehp1. feature. See
:link reftype=hd refid=class_Co_setAutoCommit.setAutoCommit():elink., too.

.*------------------------------------------------------------------------------
.*   'getCatalog()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_getCatalog clear.getCatalog()
:xmp.
public String getCatalog() throws SQLException;
:exmp.
:p.Returns the catalogue name used in the transactions. This is normally the
name of the database or data source used during login. See
:link reftype=hd refid=class_Co_setCatalog.setCatalog():elink., too.

.*------------------------------------------------------------------------------
.*   'getMetaData()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_getMetaData clear.getMetaData()
:xmp.
public DatabaseMetaData getMetaData() throws SQLException;
:exmp.
:p.Returns an object which can be used to examine the database. See
:link reftype=hd refid=class_DMD.JdbcOdbcDatabaseMetaData:elink. for details.

.*------------------------------------------------------------------------------
.*   'getTransactionIsolation()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_getTransactionIsolation clear.getTransactionIsolation()
:xmp.
public int setTransactionIsolation() throws SQLException;
:exmp.
:p.Returns the current transaction isolation level. The result may be one of
these :link reftype=hd refid=class_Co_definitions.constants:elink.&colon.
:lm margin=5.:ul.
:li.TRANSACTION_NONE - transactions are not supported
:li.TRANSACTION_READ_UNCOMMITTED - dirty reads are done
:li.TRANSACTION_READ_COMMITTED - only reads on the current row are repeatable
:li.TRANSACTION_REPEATABLE_READ - reads on all rows of a result are repeatable
:li.TRANSACTION_SERIALIZEABLE - reads on all rows of a transaction are
repeatable
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'getWarnings()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_getWarnings clear.getWarnings()
:xmp.
public SQLWarning getWarnings() throws SQLException;
:exmp.
:p.Returns the last warning occurred. See
:link reftype=hd refid=class_Co_clearWarnings.clearWarnings():elink., too.

.*------------------------------------------------------------------------------
.*   'isClosed()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_isClosed clear.isClosed()
:xmp.
public boolean isClosed() throws SQLException;
:exmp.
:p.Returns :hp1.true:ehp1. if no connection exists.

.*------------------------------------------------------------------------------
.*   'isReadOnly()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_isReadOnly clear.isReadOnly()
:xmp.
public boolean isReadOnly() throws SQLException;
:exmp.
:p.Returns the state of a connection - :hp1.true:ehp1., if the connection is
set read-only. See
:link reftype=hd refid=class_Co_setReadOnly.setReadOnly():elink., too.

.*------------------------------------------------------------------------------
.*   'nativeSql()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_nativeSql clear.nativeSql()
:xmp.
public String nativeSQL( String sql ) throws SQLException;
:exmp.
:p.A SQL statement (:hp2.sql:ehp2.) may contain JDBC or ODBC specific escape
sequences. This method provides a function for resolving such escape sequences.
It returns native SQL syntax.

.*------------------------------------------------------------------------------
.*   'prepareCall()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_prepareCall clear.prepareCall()
:xmp.
public CallableStatement prepareCall( String sql ) throws SQLException;
:exmp.
:p.Get a new object, which obtains a SQL stored procedure call. The call
sequence is set by the :hp2.sql:ehp2. parameter. See the
:link reftype=hd refid=class_CS.JdbcOdbcCallableStatement:elink. class for more
details.

.*------------------------------------------------------------------------------
.*   'prepareStatement()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_prepareStatement clear.prepareStatement()
:xmp.
public PreparedStatement prepareStatement( String sql ) throws SQLException;
:exmp.
:p.Get a new object, which obtains a prepared SQL statement, formed by the
SQL statement :hp2.sql:ehp2.. See the
:link reftype=hd refid=class_PS.JdbcOdbcPreparedStatement:elink. class for more
details.

.*------------------------------------------------------------------------------
.*   'queryOdbcBridge()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_queryOdbcBridge clear.queryOdbcBridge()
:xmp.
public J2ODBC queryOdbcBridge() throws J2ODBCException;
:exmp.
:p.Returns the handle to the
:link reftype=hd refid=class_J2ODBC.J2ODBC:elink. class, which is used for
accessing the ODBC driver manager.

.*------------------------------------------------------------------------------
.*   'rollback()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_rollback clear.rollback()
:xmp.
public void rollback() throws SQLException;
:exmp.
:p.Invalidates all previous transactions, i.e. all changes done are withdrawn.
See :link reftype=hd refid=class_Co_commit.commit():elink., too.

.*------------------------------------------------------------------------------
.*   'setAutoClose()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_setAutoClose clear.setAutoClose()
:xmp.
public void setAutoClose( boolean autoClose ) throws SQLException;
:exmp.
:p.Enables or disables (:hp2.autoClose:ehp2. equals :hp1.true:ehp1. or
:hp1.false:ehp1.) the automatic close of cursors on termination.
See :link reftype=hd refid=class_Co_getAutoClose.getAutoClose():elink., too.

.*------------------------------------------------------------------------------
.*   'setAutoCommit()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_setAutoCommit clear.setAutoCommit()
:xmp.
public void setAutoCommit( boolean autoCommit ) throws SQLException;
:exmp.
:p.Enables or disables (depending on :hp2.autoCommit:ehp2.) the
:hp1.AUTOCOMMIT:ehp1. feature provided with many databases. If enabled, on
exit a database COMMIT is executed automatically. See
:link reftype=hd refid=class_Co_getAutoCommit.getAutoCommit():elink., too.

.*------------------------------------------------------------------------------
.*   'setCatalog()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_setCatalog clear.setCatalog()
:xmp.
public void setCatalog( String catalog ) throws SQLException;
:exmp.
:p.Sets a new catalogue :hp2.catalog:ehp2. for all following transactions. See
:link reftype=hd refid=class_Co_getCatalog.getCatalog():elink., too.

:note.
On the JDBC-ODBC bridge, this method does not have any effect.

.*------------------------------------------------------------------------------
.*   'setReadOnly()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_setReadOnly clear.setReadOnly()
:xmp.
public void setReadOnly( boolean readOnly ) throws SQLException;
:exmp.
:p.Switches a connection to read-only, if :hp2.readOnly:ehp2. is set
:hp1.true:ehp1.. See
:link reftype=hd refid=class_Co_isReadOnly.isReadOnly():elink., too.

.*------------------------------------------------------------------------------
.*   'setTransactionIsolation()'
.*------------------------------------------------------------------------------
:h4 id=class_Co_setTransactionIsolation clear.setTransactionIsolation()
:xmp.
public void setTransactionIsolation( int level ) throws SQLException;
:exmp.
:p.Sets a new transaction isolation level. For :hp2.level:ehp2., these
:link reftype=hd refid=class_Co_definitions.definitions:elink. are
valid&colon.
:lm margin=5.:ul.
:li.TRANSACTION_NONE - transactions are not supported
:li.TRANSACTION_READ_UNCOMMITTED - dirty reads are done
:li.TRANSACTION_READ_COMMITTED - only reads on the current row are repeatable
:li.TRANSACTION_REPEATABLE_READ - reads on all rows of a result are repeatable
:li.TRANSACTION_SERIALIZEABLE - reads on all rows of a transaction are
repeatable
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
