.*------------------------------------------------------------------------------
.* JdbcOdbc (OS/2) - JdbcOdbcCallableStatment
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'Class JdbcOdbcCallableStatement'
.*------------------------------------------------------------------------------
:h3 id=class_CS clear.Class JdbcOdbcCallableStatement
:p.This class provides access to SQL stored procedures. There are two different
syntax schemes for functions and procedures&colon.

:lm margin=5.:ul.
:li.:hp1.? = call <procedure name>[<arg1>,<arg2>,...]:ehp1.
:li.:hp1.call <procedure name>[<arg1>,<arg2>,...]:ehp1.
:eul.:lm margin=1.

:p.The first scheme provides a result paramater, which has to be registered as
an :hp2.OUT:ehp2. parameter (see below). All parameters are refered
sequentially by index numbers, starting with 1.

:p.So-called :hp2.IN:ehp2. parameters, that are parameters filled before
running the stored procedure, have to be set using the
:link reftype=hd refid=class_PS_set.JdbcOdbcPreparedStatement&colon.&colon.set...():elink.
methods. So-called :hp2.OUT:ehp2. parameters, that are parameters filled by
the stored procedure, have to be registers before execution of the stored
procedure using
:link reftype=hd refid=class_CS_registerOutParameter.registerOutParameter():elink..
Afterwards, the results may be queried by the
:link reftype=hd refid=class_CS_get.get...():elink. methods.

:p.Callable statements may return zero, one or more result sets (see
:link reftype=hd refid=class_RS.JdbcOdbcResultSet:elink.).

.*------------------------------------------------------------------------------
.*   'constructors'
.*------------------------------------------------------------------------------
:h4 id=class_CS_constructors clear.constructors
:xmp.
public JdbcOdbcCallableStatement( Connection dbConnection,
                                  J2ODBC odbcObj,
                                  String sql ) throws SQLException;
:exmp.
:p.Used by
:link reftype=hd refid=class_Co_prepareCall.JdbcOdbcConnection&colon.&colon.prepareCall():elink.
to create a new object. :hp2.dbConnection:ehp2. refers to the current database
connection, which uses the :hp2.odbcObj:ehp2. ODBC interface. The call for the
SQL stored procedure is given in :hp2.sql:ehp2..

.*------------------------------------------------------------------------------
.*   'get...()'
.*------------------------------------------------------------------------------
:h4 id=class_CS_get clear.get...()
:xmp.
public boolean getBoolean( int parameterIndex ) throws SQLException;
public byte getByte( int parameterIndex ) throws SQLException:
public byte[] getBytes( int parameterIndex ) throws SQLException;
public java.sql.Date getDate( int parameterIndex ) throws SQLException;
public double getDouble( int parameterIndex ) throws SQLException;
public float getFloat( int parameterIndex ) throws SQLException;
public int getInt( int parameterIndex ) throws SQLException;
public long getLong( int parameterIndex ) throws SQLException;
public Bignum getBignum( int parameterIndex, int scale ) throws SQLException;
public Object getObject( int parameterIndex ) throws SQLException;
public short getShort( int parameterIndex ) throws SQLException;
public String getString( int parameterIndex ) throws SQLException;
public java.sql.Time getTime( int parameterIndex ) throws SQLException;
public java.sql.Timestamp getTimestamp( int parameterIndex )
        throws SQLException;
:exmp.
:p.Returns the contents of the parameter with index number
:hp2.parameterIndex:ehp2. (starting with 1) in the appropriate format. The
following table shows which methods matches SQL data types very closely - on
some databases it may be possible to specify a completely other SQL data type
for a column/parameter, like CHAR for BIT.

:table cols='25 54'.
:row.:c.method               :c.SQL data type(s)
:row.:c.getBoolean()         :c.BIT
:row.:c.getByte()            :c.TINYINT
:row.:c.getBytes()           :c.BINARY, VARBINARY
:row.:c.getDate()            :c.DATE
:row.:c.getDouble()          :c.DOUBLE
:row.:c.getFloat()           :c.FLOAT
:row.:c.getInt()             :c.INTEGER
:row.:c.getLong()            :c.BIGINT
:row.:c.getBignum()          :c.NUMERIC
:row.:c.getObject()          :c.any data type (see below)
:row.:c.getShort()           :c.SMALLINT
:row.:c.getString()          :c.CHAR, VARCHAR, LONGVARCHAR
:row.:c.getTime()            :c.TIME
:row.:c.getTimestamp()       :c.TIMESTAMP
:etable.

:note.
:hp1.getObject():ehp1. returns an object for a SQL data type, which has been
previously set by
:link reftype=hd refid=class_CS_registerOutParameter.registerOutParameter():elink..
It may also be used to handle non-ODBC conformant data types or database vendor
specific data type extension.

.*------------------------------------------------------------------------------
.*   'registerOutParameter()'
.*------------------------------------------------------------------------------
:h4 id=class_CS_registerOutParameter clear.registerOutParameter()
:xmp.
public void registerOutParameter( int parameterIndex, int sqlType )
        throws SQLException;
public void registerOutParameter( int parameterIndex, int sqlType, int scale )
        throws SQLException;
:exmp.
:p.Registers an :hp1.OUT:ehp1. parameter in a call for a SQL stored procedure.
:hp2.parameterIndex:ehp2. contains the index number (starting with 1) of the
parameter, :hp2.sqlType:ehp2. the SQL data type (see :hp1.java.sql.Type:ehp1.
for details) and the additional parameter :hp2.scale:ehp2. a scaling factor.

.*------------------------------------------------------------------------------
.*   'wasNull()'
.*------------------------------------------------------------------------------
:h4 id=class_CS_wasNull clear.wasNull()
:xmp.
public boolean wasNull() throws SQLException;
:exmp.
:p.Returns :hp1.true:ehp1. if the last parameter queried by a
:link reftype=hd refid=class_CS_get.get...():elink. method was NULL.

.*------------------------------------------------------------------------------
