.*------------------------------------------------------------------------------
.* JdbcOdbc (OS/2) - J2ODBC
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'class J2ODBC'
.*------------------------------------------------------------------------------
:h3 id=class_J2ODBC clear.class J2ODBC
:p.This class is implemented as package :hp4.iODBC.sql.dll:ehp4.. Therefore an
import should reference :hp1.iODBC.sql.dll.J2ODBC:ehp1. (and
:hp1.:link reftype=hd refid=class_J2ODBCException.iODBC.sql.dll.J2ODBCException:elink.:ehp1.
for exception handling, too).

:p.The class requires an external link library,
:lm margin=5.:ul.
:li.called :hp2.J2ODBC.DLL:ehp2. under OS/2, Win95 or WinNT,
:li.called :hp2.libJ2ODBC.so:ehp2. under Unix.
:lm margin=1.:eul.

.*------------------------------------------------------------------------------
.*   'constants'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_constants clear.constants
:p.Global definitions&colon.
:lm margin=5.:ul.
:li.:hp2.FALSE:ehp2. - representative for boolean SQL data type
:li.:hp2.TRUE:ehp2. - representative for boolean SQL data type
:eul.:lm margin=1.

:p.SQL data types&colon.
:lm margin=5.:ul.
:li.:hp2.SQL_UNKNOWN:ehp2. and :hp2.SQL_ALL_TYPES:ehp2. - representatives for
:hp1.unknown type:ehp1. and :hp1.any type:ehp1.
:li.:hp2.SQL_DEFAULT:ehp2. - representative for :hp1.default type:ehp1.
:li.:hp2.SQL_BINARY:ehp2. - binary data
:li.:hp2.SQL_BIT:ehp2. - binary/boolean value
:li.:hp2.SQL_BIT_VARYING:ehp2. - varying binary/boolean value
:li.:hp2.SQL_BLOB:ehp2. - binary large object (data)
:li.:hp2.SQL_BLOB_LOCATOR:ehp2. - binary large object locator
:li.:hp2.SQL_CLOB:ehp2. - character large object (data)
:li.:hp2.SQL_CLOB_LOCATOR:ehp2. - character large object locator
:li.:hp2.SQL_C_LONG:ehp2. - (long) integer number (equals :hp1.long:ehp1. in C)
:li.:hp2.SQL_C_SHORT:ehp2. - (small) integer number (equals :hp1.short:ehp1.
in C)
:li.:hp2.SQL_CHAR:ehp2. - character(s), fixed allocated space in database
:li.:hp2.SQL_DATE:ehp2. - date representative
:li.:hp2.SQL_DATETIME:ehp2. - date/time representative
:li.:hp2.SQL_DBCHAR:ehp2. - database representation of character(s)
:li.:hp2.SQL_DBCLOB:ehp2. - database character large object (data)
:li.:hp2.SQL_DBCLOB_LOCATOR:ehp2. - database character large object locator
:li.:hp2.SQL_DECIMAL:ehp2. - decimal value
:li.:hp2.SQL_DOUBLE:ehp2. - floating point number (double precision)
:li.:hp2.SQL_FLOAT:ehp2. - floating pointer number (single precision)
:li.:hp2.SQL_GRAPHIC:ehp2. - some graphic data
:li.:hp2.SQL_INTEGER:ehp2. - integer number
:li.:hp2.SQL_INTERVAL:ehp2. - interval
:li.:hp2.SQL_LONGVARBINARY:ehp2. - large binary data block
:li.:hp2.SQL_LONGVARCHAR:ehp2. - large character data block
:li.:hp2.SQL_LONGVARGRAPHIC:ehp2. - large block containg graphic data
:li.:hp2.SQL_NUMERIC:ehp2. - (unspecified) numerical value
:li.:hp2.SQL_REAL:ehp2. - floating pointer number
:li.:hp2.SQL_SMALLINT:ehp2. - (small) integer number
:li.:hp2.SQL_TIME:ehp2. - time representative
:li.:hp2.SQL_TIMESTAMP:ehp2. - time stamp representative
:li.:hp2.SQL_TINYINT:ehp2. - small integer value
:li.:hp2.SQL_VARBINARY:ehp2. - binary data, variable allocated space in
database
:li.:hp2.SQL_VARCHAR:ehp2. - characters, variable allocated space in database
:li.:hp2.SQL_VARGRAPHIC:ehp2. - graphic data, variable allocated space in
database
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'constructors'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_constructors clear.constructors
:xmp.
public J2ODBC();
public J2ODBC( J2ODBC currConnection );
:exmp.
:p.The first constructor creates a new, fresh object. The second can be used
to create an object connected to a current object connected to a ODBC source.
But instead of the cloning (as done by
:link reftype=hd refid=class_J2ODBC_clone.clone():elink.), this constructor
leaves the statement handle uninitialized.

:note.
By constructing a new object using an already open connection keep in mind,
that there is only :hp1.one:ehp1. connection path. So on exit, only one
object must close the handles!

.*------------------------------------------------------------------------------
.*   'allocConnect()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_allocConnect clear.allocConnect()
:xmp.
public native void    allocConnect() throws Exception;
:exmp.
:p.Allocates a new connection handle. Must be called after
:link reftype=hd refid=class_J2ODBC_allocEnv.allocEnv():elink. in order to
establish a connection via
:link reftype=hd refid=class_J2ODBC_connect.connect():elink..

:p.To free a connection handle, use the
:link reftype=hd refid=class_J2ODBC_freeEnv.freeEnv():elink. method.

.*------------------------------------------------------------------------------
.*   'allocEnv()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_allocEnv clear.allocEnv()
:xmp.
public native void    allocEnv() throws Exception;
:exmp.
:p.Allocates a new environment for ODBC activities. Must be called before any
other ODBC routine. To free the environment, use
:link reftype=hd refid=class_J2ODBC_freeEnv.freeEnv():elink..

.*------------------------------------------------------------------------------
.*   'allocStmt()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_allocStmt clear.allocStmt()
:xmp.
public native void    allocStmt() throws Exception;
:exmp.
:p.Before a SQL statement could be
:link reftype=hd refid=class_J2ODBC_prepare.prepared:elink. or
:link reftype=hd refid=class_J2ODBC_execute.executed:elink., a statement handle
has to be obtained from the ODBC driver. This method provides an access to
a new statement handle. In order to release the obtained handle, the
:link reftype=hd refid=class_J2ODBC_freeStmt.freeStmt():elink. method should be
called.

:note.
In this implementation, each object of the class J2ODBC can obtain only one
statement handle. If there is the need to have more than one handle open, a
new object has to be created using the
:link reftype=hd refid=class_J2ODBC_constructors.J2ODBC( currConnection ):elink.
constructor.

.*------------------------------------------------------------------------------
.*   'bindCol()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_bindCol clear.bindCol()
:xmp.
// public native void    bindCol();
:exmp.
:p.:hp8.not implemented yet!:ehp8.

.*------------------------------------------------------------------------------
.*   'browseConnect()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_browseConnect clear.browseConnect()
:xmp.
public native String  browseConnect( String connStr ) throws Exception;
:exmp.
:p.Browse :hp2.connStr:ehp2. and return a connection string.

.*------------------------------------------------------------------------------
.*   'cancel()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_cancel clear.cancel()
:xmp.
public native void    cancel() throws Exception;
:exmp.
:p.Cancels a long-time SQL statement/transaction.

.*------------------------------------------------------------------------------
.*   'clone()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_clone clear.clone()
:xmp.
public Object         clone();
:exmp.
:p.Returns a clone of the current object, i.e. a new object, pointing to the
same ODBC data source with a copy of the current statement handle.

:note.
By constructing a new object using an already open connection keep in mind,
that there is only :hp1.one:ehp1. connection path. So on exit, only one
object must close the handles!

.*------------------------------------------------------------------------------
.*   'colAttributes...()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_colAttributes clear.collAttributes...()
:xmp.
public native void    colAttributes( int colIndex,
                                     int fDescType ) throws Exception;
public String         colAttributesString() { return attrDesc; }
public int            colAttributesValue() { return attrValue; }
:exmp.
:p.Returns the value for a specified attribute :hp2.fDescType:ehp2. for a
column (:hp4.1:ehp4. <= :hp2.colIndex:ehp2.
<= :link reftype=hd refid=class_J2ODBC_numResultCols.numResultCols():elink.).

:p.For string results, :hp1.colAttributesString():ehp1. returns the result;
for numerical results, :hp1.colAttributesValue():ehp1. returns the result.

:p.Possible values for :hp2.fDescType:ehp2. are&colon.
:table cols='25 3 3 48'.
:row.
:c.name                      :c.STR :c.VAL :c.description
:row.
:c.COLUMN_AUTO_INCREMENT     :c.    :c. *  :c.boolean value, TRUE = column
value automatically increments on insertion (auto primary key)
:row.
:c.COLUMN_CASE_SENSITIVE     :c.    :c. *  :c.boolean value, TRUE = column
contains case-sensitive data (like characters)
:row.
:c.COLUMN_CATALOG_NAME       :c. *  :c.    :c.name of the catalog containing
the table
:row.
:c.COLUMN_COUNT              :c.    :c. *  :c.number of resulting columns
(:hp2.colIndex:ehp2. is unused)
:row.
:c.COLUMN_DISPLAY_SIZE       :c.    :c. *  :c.size need for display data
(characters)
:row.
:c.COLUMN_LABEL              :c. *  :c.    :c.label of the column name, or,
if un-labeled, the column name
:row.
:c.COLUMN_LENGTH             :c.    :c. *  :c.length of column in characters
:row.
:c.COLUMN_MONEY              :c.    :c. *  :c.boolean value, TRUE = column
represent a currency
:row.
:c.COLUMN_NAME               :c. *  :c.    :c.name of the column in result set
:row.
:c.COLUMN_NULLABLE           :c.    :c. *  :c.boolean value, TRUE = column can
be set NULL
:row.
:c.COLUMN_OWNER_NAME         :c. *  :c.    :c.name of the table owner
:row.
:c.COLUMN_PRECISION          :c.    :c. *  :c.precision (on number columns)
:row.
:c.COLUMN_QUALIFIER_NAME     :c. *  :c.    :c.name of the database containing
the table
:row.
:c.COLUMN_SCALE              :c.    :c. *  :c.scaling (on number columns)
:row.
:c.COLUMN_SCHEMA_NAME        :c. *  :c.    :c.name of the schema containing the
table
:row.
:c.COLUMN_SEARCHABLE         :c.    :c. *  :c.(see below)
:row.
:c.COLUMN_TABLE_NAME         :c. *  :c.    :c.name of the database table
containing the column specified
:row.
:c.COLUMN_TYPE               :c.    :c. *  :c.SQL data type, see
':link reftype=hd refid=class_J2ODBC_constants.constants:elink.' for possible
values
:row.
:c.COLUMN_TYPE_NAME          :c. *  :c.    :c.name of the SQL data type used
in that column
:row.
:c.COLUMN_UNSIGNED           :c.    :c. *  :c.boolean value, TRUE = column
contains unsigned data (number)
:row.
:c.COLUMN_UPDATABLE          :c.    :c. *  :c.(see below)
:etable.

:p.Possible returns for :hp2.COLUMN_UPDATABLE:ehp2.&colon.
:lm margin=5.:ul.
:li.:hp2.ATTR_READONLY:ehp2. = column cannot be updated (is read-only)
:li.:hp2.ATTR_WRITE:ehp2. = column is updatable
:li.:hp2.ATTR_READWRITE_UNKNOWN:ehp2. = column may be updatable
:eul.:lm margin=1.

:p.Possible returns for :hp2.COLUMN_SEARCHABLE:ehp2.&colon.
:lm margin=5.:ul.
:li.:hp2.UNSEARCHABLE:ehp2. = column value cannot be searched within the
WHERE clause of a SQL statement
:li.:hp2.LIKE_ONLY:ehp2. = column value can only be searched by a LIKE in a
WHERE clause
:li.:hp2.ALL_EXCEPT_LIKE:ehp2. = column value can be searched within a WHERE
clause, except in condition with LIKE
:li.:hp2.SEARCHABLE:ehp2. = column value can be searched without exception
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'columns()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_columns clear.columns()
:xmp.
public native void    columns( String tableQualifier,
                               String tableOwner,
                               String tableName,
                               String columnName ) throws Exception;
:exmp.
:p.Returns the columns matching the conditions in a result set, like a query
does. Before this method can be called, a statement handle has to be
:link reftype=hd refid=class_J2ODBC_allocStmt.obtained:elink.. The parameter
:hp2.tableQualifier:ehp2., if set, reduces the resulting list to those tables,
which are mapped to the specified qualifier (catalogue). The same do
:hp2.tableOwner:ehp2. for the owner of tables, :hp2.tableName:ehp2. for table
names and :hp2.columnName:ehp2. for the name of columns. Setting a parameter
:hp1.null:ehp1. disables this search criteria and returns all data (matching
the other criterias).

:p.In some string parameters a so-called joker ('%') may occur. It stands for
a variable-sized string of variable characters.

:note.
The result may vary depending on the database software (i.e. ODBC driver).
Consult the appropriate documentation there!

.*------------------------------------------------------------------------------
.*   'connect()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_connect clear.connect()
:xmp.
public native void    connect( String dsn,
                               String uid,
                               String pwd ) throws Exception;
:exmp.
:p.Connects to a given ODBC data source :hp2.dsn:ehp2. using the user name
:hp2.uid:ehp2. and password :hp2.pwd:ehp2.. This call has to be executed before
any database interactions. Previously the environment and the database context
have to be initialized (see
:link reftype=hd refid=class_J2ODBC_allocEnv.allocEnv:elink. and
:link reftype=hd refid=class_J2ODBC_allocConnect.allocConnect:elink.).

:p.In order to withdraw from a database, use
:link reftype=hd refid=class_J2ODBC_disconnect.disconnect():elink..

.*------------------------------------------------------------------------------
.*   'describeCol...()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_describeCol clear.describeCol...()
:xmp.
public native void    describeCol( int colIndex ) throws Exception;
public String         describeColName() { return colName; }
public int            describeColType() { return colSqlType; }
public int            describeColPrecision() { return colPrecision; }
public int            describeColScale() { return colScale; }
public boolean        describeColNullable() { return colNullable; }
:exmp.
:p.The :hp1.describeCol():ehp1. method gets the information about a column
:hp2.colIndex:ehp2. of a result set of a query, which can be gathered by the
other methods&colon.
:lm margin=5.:ul.
:li.:hp1.describeColName():ehp1. returns the name of the column
:li.:hp1.describeColType():ehp1. returns the type of the column (see
':link reftype=hd refid=class_J2ODBC_constants.constants:elink.')
:li.:hp1.describeColPrecision():ehp1. returns the precision of the column
:li.:hp1.describeColScale():ehp1. returns the scale of the column
:li.:hp1.describeColNullable():ehp1. returns whether a column can store a
:hp1.NULL:ehp1. value or not
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'describeParam...()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_describeParam clear.describeParam...()
:xmp.
public native void    describeParam( int paramIndex ) throws Exception;
public int            describeParamType() { return colSqlType; }
public int            describeParamPrecision() { return colPrecision; }
public int            describeParamScale() { return colScale; }
public boolean        describeParamNullable() { return colNullable; }
:exmp.
:p.The :hp1.describeParam():ehp1. method gets the information about parameter
no. :hp2.colIndex:ehp2. of a SQL
:link reftype=hd refid=class_J2ODBC_prepare.prepared:elink.statement, which
can be gathered by the other methods&colon.
:lm margin=5.:ul.
:li.:hp1.describeParamType():ehp1. returns the type of the parameter (see
':link reftype=hd refid=class_J2ODBC_constants.constants:elink.')
:li.:hp1.describeParamPrecision():ehp1. returns the precision of the parameter
:li.:hp1.describeParamScale():ehp1. returns the scale of the parameter
:li.:hp1.describeParamNullable():ehp1. returns whether a parameter can store a
:hp1.NULL:ehp1. value or not
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'disconnect()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_disconnect clear.disconnect()
:xmp.
public native void    disconnect() throws Exception;
:exmp.
:p.Closes a connection opened by a
:link reftype=hd refid=class_J2ODBC_connect.connect():elink. or
:link reftype=hd refid=class_J2ODBC_driverConnect.driverConnect():elink. call.

.*------------------------------------------------------------------------------
.*   'driverConnect()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_driverConnect clear.driverConnect()
:xmp.
public native String  driverConnect( String connStr,
                                     int fDrvCmpl ) throws Exception;
:exmp.
:p.Like :link reftype=hd refid=class_J2ODBC_connect.connect():elink. this
routine allows connection to a ODBC data source. But unlike the other routine,
a connection string (:hp2.connStr:ehp2.) has to be defined, which consists of
these entries&colon.

:lm margin=5.:ul.
:li.:hp2.DSN=:ehp2.:hp3.data_source_name:ehp3. - name of the data source to
connect to
:li.:hp2.UID=:ehp2.:hp3.user_name:ehp3. - user name used during connection
:li.:hp2.PWD=:ehp2.:hp3.password:ehp3. - password used during connection
:eul.:lm margin=1.

:p.The entries are separated by colons (:hp2.;:ehp2.). Further, a flag
:hp2.fDrvCmpl:ehp2. can be specified, which tells the ODBC driver whether and
how to prompt (login dialog window) for missing data necessary during login,
or not. The available flags are&colon.

:lm margin=5.:ul.
:li.:hp2.DRIVER_NOPROMPT:ehp2. - do not prompt for missing data, try to connect
with the given data
:li.:hp2.DRIVER_COMPLETE:ehp2. - prompt for missing data, necessary for login
:li.:hp2.DRIVER_PROMPT:ehp2. - always prompt, display all data
:li.:hp2.DRIVER_COMPLETE_REQUIRED:ehp2. - only prompt for missing data, that
is mandatory
:eul.:lm margin=1.

:p.In order to withdraw from a database, use
:link reftype=hd refid=class_J2ODBC_disconnect.disconnect():elink..

.*------------------------------------------------------------------------------
.*   'error()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_error clear.error()
:xmp.
public native String  error() throws Exception;
:exmp.
:p.Returns a string representation for a previously occurred database or ODBC
error.

.*------------------------------------------------------------------------------
.*   'execDirect()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_execDirect clear.execDirect()
:xmp.
public native void    execDirect( String sqlStmt ) throws Exception;
:exmp.
:p.Prepares and then executes a given SQL statement :hp2.sqlStmt:ehp2..
On DELETE, INSERT or UPDATE
:link reftype=hd refid=class_J2ODBC_rowCount.rowCount():elink. returns the
number of rows affected, on queries
:link reftype=hd refid=class_J2ODBC_numResultCols.numResultCols():elink.
returns the number of columns in the result set (see
:link reftype=hd refid=class_J2ODBC_fetch.fetch():elink.).

.*------------------------------------------------------------------------------
.*   'execute()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_execute clear.execute()
:xmp.
public native void    execute() throws Exception;
:exmp.
:p.Executes a previously
:link reftype=hd refid=class_J2ODBC_prepare.prepared:elink. SQL statement.
On DELETE, INSERT or UPDATE
:link reftype=hd refid=class_J2ODBC_rowCount.rowCount():elink. returns the
number of rows affected, on queries
:link reftype=hd refid=class_J2ODBC_numResultCols.numResultCols():elink.
returns the number of columns in the result set (see
:link reftype=hd refid=class_J2ODBC_fetch.fetch():elink.).

.*------------------------------------------------------------------------------
.*   'extendedFetch()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_extendedFetch clear.extendedFetch()
:xmp.
// public native boolean extendedFetch();
:exmp.
:p.:hp8.Not implemented yet!:ehp8.

.*  public static final int FETCH_NEXT             =   1;
.*  public static final int FETCH_FIRST            =   2;
.*  public static final int FETCH_LAST             =   3;
.*  public static final int FETCH_PRIOR            =   4;
.*  public static final int FETCH_ABSOLUTE         =   5;
.*  public static final int FETCH_RELATIVE         =   6;
.*  public static final int FETCH_BOOKMARK         =   8;

:p.See :link reftype=hd refid=class_J2ODBC_fetch.fetch():elink. instead.

.*------------------------------------------------------------------------------
.*   'fetch()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_fetch clear.fetch()
:xmp.
public native boolean fetch() throws Exception;
:exmp.
:p.Loads the first/next row of the result set of a query so it can be accessed
by :link reftype=hd refid=class_J2ODBC_getData.getData...():elink. calls.

.*------------------------------------------------------------------------------
.*   'foreignKeys()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_foreignKeys clear.foreignKeys()
:xmp.
public native void    foreignKeys( String pkTableQualifier,
                                   String pkTableOwner,
                                   String pkTableName,
                                   String fkTableQualifier,
                                   String fkTableOwner,
                                   String fkTableName ) throws Exception;
:exmp.
:p.Returns the foreign-primary key relation on tables matching the conditions
in a result set, like a query does. Before this method can be called, a
statement handle has to be
:link reftype=hd refid=class_J2ODBC_allocStmt.obtained:elink..
:hp2.pkTableQualifier:ehp2. specifies a search criteria on qualifiers
(catalogues) of primary keys, :hp2.fkTableQualifier:ehp2. on qualifiers of
foreign keys of tables. :hp2.pkTableOwner:ehp2. (:hp2.fkTableOwner:ehp2.)
defines a search criteria on owners of primary keys (foreign keys),
:hp2.pkTableName:ehp2. (:hp2.fkTableName:ehp2.) a criteria on table names with
primary (foreign) keys. Setting a parameter :hp1.null:ehp1. disables this
search criteria and returns all data (matching the other criterias).

:p.In some string parameters a so-called joker ('%') may occur. It stands for
a variable-sized string of variable characters.

:note.
The result may vary depending on the database software (i.e. ODBC driver).
Consult the appropriate documentation there!

.*------------------------------------------------------------------------------
.*   'freeConnect()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_freeConnect clear.freeConnect()
:xmp.
public native void    freeConnect() throws Exception;
:exmp.
:p.Frees a database context allocated by
:link reftype=hd refid=class_J2ODBC_allocConnect.allocConnect():elink.. This
can only be done, if all previous transactions have been completed (see
:link reftype=hd refid=class_J2ODBC_transact.transact():elink.). Afterwards
the environment can be freed via the
:link reftype=hd refid=class_J2ODBC_freeEnv.freeEnv():elink. routine.

.*------------------------------------------------------------------------------
.*   'freeEnv()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_freeEnv clear.freeEnv()
:xmp.
public native void    freeEnv() throws Exception;
:exmp.
:p.Frees an environment allocated by
:link reftype=hd refid=class_J2ODBC_allocEnv.allocEnv():elink.. Freeing the
environment is the last step after all database interactions, in order to
terminate properly. Previous, all database contexts have to be freed by
:link reftype=hd refid=class_J2ODBC_freeConnect.freeConnect():elink. calls.

.*------------------------------------------------------------------------------
.*   'freeStmt()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_freeStmt clear.freeStmt()
:xmp.
public native void    freeStmt( int fOption ) throws Exception;
:exmp.
:p.Frees or manipulates a statement handle allocated by the
:link reftype=hd refid=class_J2ODBC_allocStmt.allocStmt():elink. method.
:hp2.fOption:ehp2. may be one of this&colon.
:lm margin=5.:ul.
:li.:hp2.CLOSE:ehp2. - closes the current statement handle, but keeps the
resource so that another SQL statement can be executed (see
:link reftype=hd refid=class_J2ODBC_prepare.prepare():elink.,
:link reftype=hd refid=class_J2ODBC_execute.execute():elink. and
:link reftype=hd refid=class_J2ODBC_execDirect.execDirect():elink.).
:li.:hp2.DROP:ehp2. - closes the current statement handle and drops the
resources
:li.:hp2.UNBIND:ehp2. - keeps the statement handle, but frees the variables
previously bound to columns by the
:link reftype=hd refid=class_J2ODBC_bindCol.bindCol():elink. method.
:li.:hp2.RESET_PARAMS:ehp2. - keeps the statement handle, but frees the
parameter variables previously bound by the
:link reftype=hd refid=class_J2ODBC_setParam.setParam():elink. method.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'getConnectOption...()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_getConnectOption clear.getConnectOption...()
:xmp.
public native int     getConnectOptionNum( int fOption ) throws Exception;
public native String  getConnectOptionStr( int fOption ) throws Exception;
:exmp.
:p.Returns informations about a connection. :hp2.fOption:ehp2. specifies the
type of information to be returned&colon.

:table cols='25 3 3 48'.
:row.
:c.name                      :c.NUM :c.STR :c.description
:row.
:c.ACCESS_MODE               :c. *  :c.    :c.access mode to database source,
see below
:row.
:c.AUTOCOMMIT                :c. *  :c.    :c.automatical COMMIT on the end
of a session, see below
:row.
:c.CURRENT_QUALIFIER         :c.    :c. *  :c.current qualifier name
:row.
:c.LOGIN_TIMEOUT             :c. *  :c.    :c.timeout value on login,
LOGIN_TIMEOUT_DEFAULT specifies the default setting
:row.
:c.ODBC_CURSORS              :c. *  :c.    :c.type of cursors, see below
:row.
:c.OPT_TRACE                 :c. *  :c.    :c.trace mode setting, see below
:row.
:c.OPT_TRACEFILE             :c.    :c. *  :c.name of the trace file, when
tracing is enabled - OPT_TRACE_FILE_DEFAULT specifies the default file name
:row.
:c.QUIET_MODE                :c. *  :c.    :c.application window handle under
which dialog boxes are placed as childs
:row.
:c.PACKET_SIZE               :c. *  :c.    :c.transfer packets size
:row.
:c.TRANSLATE_DLL             :c.    :c. *  :c.name of the translation DLL
:row.
:c.TRANSLATE_OPTION          :c. *  :c.    :c.translation option
:row.
:c.TXN_ISOLATION             :c. *  :c.    :c.transaction isolation level,
TRUE, if transactions are isolated
:etable.

:p.Options possible for :hp2.ACCESS_MODE:ehp2.&colon.
:lm margin=5.:ul.
:li.:hp2.MODE_READ_WRITE:ehp2. - read/write access to database source
:li.:hp2.MODE_READ_ONLY:ehp2. - read-only access to database source
:li.:hp2.MODE_DEFAULT:ehp2. - use default setting
:eul.:lm margin=1.

:p.Options possible for :hp2.AUTOCOMMIT:ehp2.&colon.
:lm margin=5.:ul.
:li.:hp2.AUTOCOMMIT_OFF:ehp2. - prevent automatical COMMIT
:li.:hp2.AUTOCOMMIT_ON:ehp2. - enable automatical COMMIT
:li.:hp2.AUTOCOMMIT_DEFAULT:ehp2. - use default setting
:eul.:lm margin=1.

:p.Options possible for :hp2.ODBC_CURSORS:ehp2.&colon.
:lm margin=5.:ul.
:li.:hp2.CUR_USE_IF_NEEDED:ehp2. - use cursors only if needed
:li.:hp2.CUR_USE_ODBC:ehp2. - use ODBC cursors
:li.:hp2.CUR_USE_DRIVER:ehp2. - use cursors provided with the driver
:li.:hp2.CUR_DEFAULT:ehp2. - use default setting
:eul.:lm margin=1.

:p.Options possible for :hp2.OPT_TRACE:ehp2.&colon.
:lm margin=5.:ul.
:li.:hp2.OPT_TRACE_OFF:ehp2. - tracing disabled
:li.:hp2.OPT_TRACE_ON_:ehp2. - tracing enabled
:li.:hp2.OPT_TRACE_DEFAULT:ehp2. - use default setting
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'getCursorName()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_getCursorName clear.getCursorName()
:xmp.
public native String  getCursorName() throws Exception;
:exmp.
:p.Returns the name of the cursor associated with the currently processed
statement.

.*------------------------------------------------------------------------------
.*   'getData...()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_getData clear.getData...()
:xmp.
public boolean        getDataCheckForNull() { return colIsNull; }
public native boolean getDataBoolean( int colIndex ) throws Exception;
// public native Date  getDataDate( int colIndex ) throws Exception;
public native double  getDataDouble( int colIndex ) throws Exception;
public native float   getDataFloat( int colIndex ) throws Exception;
public native int     getDataInteger( int colIndex ) throws Exception;
public native String  getDataString( int colIndex ) throws Exception;
:exmp.
:p.Returns the contents of a column (with :hp4.1:ehp4. <= :hp2.colIndex:ehp2.
<= :link reftype=hd refid=class_J2ODBC_numResultCols.numResultCols():elink.)
in the requested data type.

:p.:hp8.getDataDate():ehp8. is not implemented yet!

:p.:hp1.getDataCheckForNull():ehp1. returns :hp2.true:ehp2. if the last column
requested contains a SQL :hp1.NULL:ehp1. value.

:p.Before the first access to a column of the resulting set and before the
access to the next row, a
:link reftype=hd refid=class_J2ODBC_fetch.fetch():elink. call has to be done.

.*------------------------------------------------------------------------------
.*   'getInfoNum(), getInfoStr()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_getInfo clear.getInfoNum(), getInfoStr()
:xmp.
public native int     getInfoNum( int fInfoType ) throws Exception;
public native String  getInfoStr( int fInfoType ) throws Exception;
:exmp.
:p.These calls can be used to retrieve informations about the ODBC sub-system.
Because some informations are represented by number, some by strings, there are
two methods for accessing them. The following list shows the possible
request flags (:hp2.fInfoType:ehp2.)&colon.
:table cols='25 3 3 48'.
:row.
:c.name                      :c.NUM :c.STR :c.description
:row.
:c.CURSOR_COMMIT_BEHAVIOR    :c. *  :c.    :c.describes the reaction of open
cursors to COMMIT (see below).
:row.
:c.CURSOR_ROLLBACK_BEHAVIOR  :c. *  :c.    :c.describes the reaction of open
cursors to ROLLBACK (see below).
:row.
:c.DEFAULT_TXN_ISOLATION     :c. *  :c.    :c.returns a mask describing the
default transaction isolation level (see below).
:row.
:c.DRIVER_HDBC               :c. *  :c.    :c.returns the currently used
database context handle
:row.
:c.DRIVER_HENV               :c. *  :c.    :c.returns the currently used
environment handle
:row.
:c.DRIVER_HLIB               :c. *  :c.    :c.returns the currently used
library handle
:row.
:c.DRIVER_HSTMT              :c. *  :c.    :c.returns the currently used
statement handle
:row.
:c.DRIVER_NAME               :c.    :c. *  :c.returns the name of the ODBC
driver used
:row.
:c.DRIVER_ODBC_VER           :c.    :c. *  :c.returns the version of the ODBC
driver as string (like '2.1')
:row.
:c.NON_NULLABLE_COLUMNS      :c. *  :c.    :c.returns in a boolean value
whether table columns can be set equal :hp1.NULL:ehp1. or not.
:row.
:c.ODBC_VER                  :c.    :c. *  :c.returns the version string for
the ODBC driver (like '02.01')
:row.
:c.QUALIFIER_LOCATION        :c. *  :c.    :c.returns the location of the
qualifier in a qualified table name
:row.
:c.TXN_ISOLATION_OPTION      :c. *  :c.    :c.returns the transaction
isolation levels available at the current connection (see below).
:etable.

:p.Options for :hp2.CURSOR_COMMIT_BEHAVIOUR:ehp2. and
:hp2.CURSOR_ROLLBACK_BEHAVIOUR:ehp2.&colon.
:ul.
:li.:hp2.CB_DELETE:ehp2. = destroy cursors
:li.:hp2.CB_CLOSE:ehp2. = destroy cursors but keep access plans for dynamic SQL
statements
:li.:hp2.CB_PRESERVE:ehp2. = retain cursor and access plans.
:eul.

:p.Options for :hp2.DEFAULT_TXN_ISOLATION:ehp2. and
:hp2.TXN_ISOLATION_OPTION:ehp2.&colon.
:ul.
:li.bit :hp2.TXN_READ_UNCOMMITTED:ehp2. = changes are immediately perceived
by all transactions
:li.bit :hp2.TXN_READ_COMMITTED:ehp2. = changes are visible to queries only
after a :hp1.COMMIT:ehp1.
:li.bit :hp2.TXN_REPEATABLE_READ:ehp2. = a transaction can add or delete rows
matching the search criteria
:li.bit :hp2.TXN_SERIALIZEABLE:ehp2. = transactions are serialized
:li.bit :hp2.TXN_VERSIONING:ehp2. = transactions are revisioned
:eul.

.*------------------------------------------------------------------------------
.*   'getStmtOption...()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_getStmtOption clear.getStmtOption...()
:xmp.
public native int     getStmtOptionNum( int fOption ) throws Exception;
public native String  getStmtOptionStr( int fOption ) throws Exception;
:exmp.
:p.Returns informations about a statement handle. Possible values for
:hp2.fOption:ehp2. are&colon.
:table cols='25 3 3 48'.
:row.
:c.name                      :c.Num :c.Str :c.description
:row.
:c.ASYNC_ENABLE              :c. *  :c.    :c.returns TRUE when SQL statements
are executed asynchronously
:row.
:c.BIND_TYPE                 :c. *  :c.    :c.returns the binding type
:row.
:c.CONCURRENCY               :c. *  :c.    :c.returns cursor concurrencies,
see below.
:row.
:c.CURSOR_TYPE               :c. *  :c.    :c.returns the cursor type on the
statement handle
:row.
:c.GET_BOOKMARK              :c.    :c.    :c.not supported!
:row.
:c.KEYSET_SIZE               :c. *  :c.    :c.returns the size of the key set
:row.
:c.MAX_LENGTH                :c. *  :c.    :c.0 or the maximum length of a
result column of a query
:row.
:c.MAX_ROWS                  :c. *  :c.    :c.returns the maximum number of
rows produced by the last query executed
:row.
:c.NOSCAN                    :c. *  :c.    :c.returns TRUE if there is no scan
for escape sequences in SQL statements
:row.
:c.QUERY_TIMEOUT             :c. *  :c.    :c.returns the timeout value on
queries
:row.
:c.RETRIEVE_DATA             :c.    :c.    :c.not supported!
:row.
:c.ROW_NUMBER                :c.    :c.    :c.not supported!
:row.
:c.ROWSET_SIZE               :c. *  :c.    :c.returns the size of the row set
:row.
:c.SIMULATE_CURSOR           :c.    :c.    :c.not supported!
:row.
:c.USE_BOOKMARKS             :c.    :c.    :c.not supported!
:etable.

:p.Possible values for :hp2.CONCURRENCY:ehp2.&colon.
:lm margin=5.:ul.
:li.:hp2.CONCUR_READ_ONLY:ehp2. - cursor is read-only, no updates allowed
:li.:hp2.CONCUR_LOCK:ehp2. - update allowed using locking mechanism
:li.:hp2.CONCUR_ROWVER:ehp2. - update allowed using row version method
:li.:hp2.CONCUR_VALUES:ehp2. - update allowed
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'getTypeInfo()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_getTypeInfo clear.getTypeInfo()
:xmp.
public native void    getTypeInfo( int fSqlType ) throws Exception;
:exmp.
:p.Returns a result set (like a query does), describing details about the
given SQL data type (:hp2.fSqlType:ehp2.). See
':link reftype=hd refid=class_J2ODBC_constants.constants:elink.' for a
description of valid SQL data types.

.*------------------------------------------------------------------------------
.*   'moreResults()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_moreResults clear.moreResults()
:xmp.
public native boolean moreResults() throws Exception;
:exmp.
:p.Checks for further result sets and initializes them.

.*------------------------------------------------------------------------------
.*   'nativeSql()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_nativeSql clear.nativeSql()
:xmp.
public native String  nativeSql( String sqlStmt ) throws Exception;
:exmp.
:p.Translates a given SQL statement :hp2.sqlStmt:ehp2., containing database
specific extensions, into a native SQL statement.

.*------------------------------------------------------------------------------
.*   'numParams()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_numParams clear.numParams()
:xmp.
public native int     numParams() throws Exception;
:exmp.
:p.Returns the number of parameter markers set in a SQL statement, which has
been :link reftype=hd refid=class_J2ODBC_prepare.prepared:elink..

.*------------------------------------------------------------------------------
.*   'numResultCols()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_numResultCols clear.numResultCols()
:xmp.
public native int     numResultCols() throws Exception;
:exmp.
:p.Returns the number of columns available in a result set of a query. This
method may be called after a
:link reftype=hd refid=class_J2ODBC_prepare.prepare():elink. or a
:link reftype=hd refid=class_J2ODBC_execDirect.execDirect():elink. call.

.*------------------------------------------------------------------------------
.*   'paramData()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_paramData clear.paramData()
:xmp.
// public native void    paramData();
:exmp.
:p.:hp8.not implemented yet!:ehp8.

.*------------------------------------------------------------------------------
.*   'paramOptions...()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_paramOptions clear.paramOptions...()
:xmp.
public native void    paramOptions( int numOfParams ) throws Exception;
public int            paramOptionsResultNumber() { return paramResultNumber; }
:exmp.
:p.Allows the setting of various parameter arrays in combination with
:link reftype=hd refid=class_J2ODBC_setParam.setParam():elink..
:hp2.numOfParams:ehp2. specifies, how many entries in the array exists for one
parameter. The result of the :hp1.paramOptions():ehp1.-call can be gathered
by the :hp1.paramOptionsResultNumber:ehp1.-routine, which returns the number of
array indices successfully processed.

.*------------------------------------------------------------------------------
.*   'prepare()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_prepare clear.prepare()
:xmp.
public native void    prepare( String sqlStmt ) throws Exception;
:exmp.
:p.Before execution of a SQL statement (:hp2.sqlStmt:ehp2.) it has to be
prepared. This method causes the SQL engine to prepare the given statement for
execution, that can be then done by the
:link reftype=hd refid=class_J2ODBC_execute.execute():elink. method.

:p.Another way for direct execution is the
:link reftype=hd refid=class_J2ODBC_execDirect.execDirect():elink. method,
which combines preparation and execution state.

.*------------------------------------------------------------------------------
.*   'primaryKeys()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_primaryKeys clear.primaryKeys()
:xmp.
public native void    primaryKeys( String tableQualifier,
                                   String tableOwner,
                                   String tableName ) throws Exception;
:exmp.
:p.Returns the primary keys of tables matching the conditions in a result set,
like a query does. Before this method can be called, a statement handle has to
be :link reftype=hd refid=class_J2ODBC_allocStmt.obtained:elink.. The parameter
:hp2.tableQualifier:ehp2., if set, reduces the resulting list to those tables,
which are mapped to the specified qualifier (catalogue). The same do
:hp2.tableOwner:ehp2. for the owner of tables and :hp2.tableName:ehp2. for
table names. Setting a parameter :hp1.null:ehp1. disables this search criteria
and returns all data (matching the other criterias).

:p.In some string parameters a so-called joker ('%') may occur. It stands for
a variable-sized string of variable characters.

:note.
The result may vary depending on the database software (i.e. ODBC driver).
Consult the appropriate documentation there!

.*------------------------------------------------------------------------------
.*   'procedures()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_procedures clear.procedures()
:xmp.
public native void    procedures( String procQualifier,
                                  String procOwner,
                                  String procName ) throws Exception;
:exmp.
:p.This method returns names and other data of stored database procedures in
a result set, like a query does. :hp2.procQualifier:ehp2. specifies a search
criteria on qualifiers (catalogues), :hp2.procOwner:ehp2. on owners of such
procedures, and :hp2.procName:ehp2. on procedure names. Setting a parameter
:hp1.null:ehp1. disables this search criteria and returns all data (matching
the other criterias).

:p.In some string parameters a so-called joker ('%') may occur. It stands for
a variable-sized string of variable characters.

:note.
The result may vary depending on the database software (i.e. ODBC driver).
Consult the appropriate documentation there!

.*------------------------------------------------------------------------------
.*   'procedureColumns()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_procedureColumns clear.procedureColumns()
:xmp.
public native void    procedureColumns( String procQualifier,
                                        String procOwner,
                                        String procName,
                                        String columnName ) throws Exception;
:exmp.
:p.This method returns data about parameters of stored database procedures in
a result set, like a query does. :hp2.procQualifier:ehp2. specifies a search
criteria on qualifiers (catalogues), :hp2.procOwner:ehp2. on owners of such
procedures, :hp2.procName:ehp2. on procedure names, and :hp2.columnName:ehp2.
on column (i.e. parameters). Setting a parameter :hp1.null:ehp1. disables this
search criteria and returns all data (matching the other criterias).

:p.In some string parameters a so-called joker ('%') may occur. It stands for
a variable-sized string of variable characters.

:note.
The result may vary depending on the database software (i.e. ODBC driver).
Consult the appropriate documentation there!

.*------------------------------------------------------------------------------
.*   'putData()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_putData clear.putData()
:xmp.
// public native void    putData();
:exmp.
:p.:hp8.not implemented yet!:ehp8.

.*------------------------------------------------------------------------------
.*   'rowCount()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_rowCount clear.rowCount()
:xmp.
public native int     rowCount() throws Exception;
:exmp.
:p.Returns the number of rows affected by an :hp1.DELETE:ehp1.,
:hp1.INSERT:ehp1. or :hp1.UPDATE:ehp1. statement executed via
:link reftype=hd refid=class_J2ODBC_execute.execute():elink. or
:link reftype=hd refid=class_J2ODBC_execDirect.execDirect():elink..

.*------------------------------------------------------------------------------
.*   'setConnectOption...()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_setConnectOption clear.setConnectOption...()
:xmp.
public native void    setConnectOptionNum( int fOption,
                                           int paramValue ) throws Exception;
public native void    setConnectOptionStr( int fOption,
                                           String paramStr ) throws Exception;
:exmp.
:p.Sets options on a connection. :hp2.fOption:ehp2. specifies the
type of option to be set, which is done by the :hp2.paramValue:ehp2. or
:hp2.paramStr:ehp2. parameter. Possible values for :hp2.fOption:ehp2.
are&colon.

:table cols='25 3 3 48'.
:row.
:c.name                      :c.NUM :c.STR :c.description
:row.
:c.ACCESS_MODE               :c. *  :c.    :c.access mode to database source,
see below
:row.
:c.AUTOCOMMIT                :c. *  :c.    :c.automatical COMMIT on the end
of a session, see below
:row.
:c.CURRENT_QUALIFIER         :c.    :c. *  :c.current qualifier name
:row.
:c.LOGIN_TIMEOUT             :c. *  :c.    :c.timeout value on login,
LOGIN_TIMEOUT_DEFAULT specifies the default setting
:row.
:c.ODBC_CURSORS              :c. *  :c.    :c.type of cursors, see below
:row.
:c.OPT_TRACE                 :c. *  :c.    :c.trace mode setting, see below
:row.
:c.OPT_TRACEFILE             :c.    :c. *  :c.name of the trace file, when
tracing is enabled - OPT_TRACE_FILE_DEFAULT specifies the default file name
:row.
:c.QUIET_MODE                :c. *  :c.    :c.application window handle under
which dialog boxes are placed as childs
:row.
:c.PACKET_SIZE               :c. *  :c.    :c.transfer packets size
:row.
:c.TRANSLATE_DLL             :c.    :c. *  :c.name of the translation DLL
:row.
:c.TRANSLATE_OPTION          :c. *  :c.    :c.translation option
:row.
:c.TXN_ISOLATION             :c. *  :c.    :c.transaction isolation level,
TRUE, if transactions are isolated
:etable.

:p.Options possible for :hp2.ACCESS_MODE:ehp2.&colon.
:lm margin=5.:ul.
:li.:hp2.MODE_READ_WRITE:ehp2. - read/write access to database source
:li.:hp2.MODE_READ_ONLY:ehp2. - read-only access to database source
:li.:hp2.MODE_DEFAULT:ehp2. - use default setting
:eul.:lm margin=1.

:p.Options possible for :hp2.AUTOCOMMIT:ehp2.&colon.
:lm margin=5.:ul.
:li.:hp2.AUTOCOMMIT_OFF:ehp2. - prevent automatical COMMIT
:li.:hp2.AUTOCOMMIT_ON:ehp2. - enable automatical COMMIT
:li.:hp2.AUTOCOMMIT_DEFAULT:ehp2. - use default setting
:eul.:lm margin=1.

:p.Options possible for :hp2.ODBC_CURSORS:ehp2.&colon.
:lm margin=5.:ul.
:li.:hp2.CUR_USE_IF_NEEDED:ehp2. - use cursors only if needed
:li.:hp2.CUR_USE_ODBC:ehp2. - use ODBC cursors
:li.:hp2.CUR_USE_DRIVER:ehp2. - use cursors provided with the driver
:li.:hp2.CUR_DEFAULT:ehp2. - use default setting
:eul.:lm margin=1.

:p.Options possible for :hp2.OPT_TRACE:ehp2.&colon.
:lm margin=5.:ul.
:li.:hp2.OPT_TRACE_OFF:ehp2. - tracing disabled
:li.:hp2.OPT_TRACE_ON_:ehp2. - tracing enabled
:li.:hp2.OPT_TRACE_DEFAULT:ehp2. - use default setting
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'setCursorName()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_setCursorName clear.setCursorName()
:xmp.
public native void    setCursorName( String cursorName ) throws Exception;
:exmp.
:p.Sets the name of the cursor associated with the currently processed
statement to :hp2.cursorName:ehp2.

.*------------------------------------------------------------------------------
.*   'setParam()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_setParam clear.setParam()
:xmp.
// public native void    setParam();
:exmp.
:p.:hp8.not implemented yet!:ehp8.

.*------------------------------------------------------------------------------
.*   'setPos()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_setPos clear.setPos()
:xmp.
public native void    setPos( int rowIndex,
                              boolean fRefresh,
                              boolean fLock ) throws Exception;
:exmp.
:p.Sets a cursor to a specific row :hp2.rowIndex:ehp2. in the result set.
Boolean values describe whether to update the result set (:hp2.fRefresh:ehp2.)
and/or to lock the result set (:hp2.fLock:ehp2.), or not.

.*------------------------------------------------------------------------------
.*   'setScrollOptions()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_setScrollOptions clear.setScrollOptions()
:xmp.
public native void    setScrollOptions( int fConcurrency,
                                        int crowKeyset,
                                        int crowRowset ) throws Exception;
:exmp.
:p.Set scolling options.

.*------------------------------------------------------------------------------
.*   'setStmtOption...()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_setStmtOption clear.setStmtOption...()
:xmp.
public native void    setStmtOptionNum( int fOption,
                                        int paramValue ) throws Exception;
public native void    setStmtOptionStr( int fOption,
                                        String paramStr ) throws Exception;
:exmp.
:p.Sets options on a statement handle. :hp2.paramValue:ehp2. and
:hp2.paramStr:ehp2. are the values to be set, and :hp2.fOption:ehp2. is the
option reference. Possible values for :hp2.fOption:ehp2. are&colon.
:table cols='25 3 3 48'.
:row.
:c.name                      :c.Num :c.Str :c.description
:row.
:c.ASYNC_ENABLE              :c. *  :c.    :c.when set TRUE, SQL statements
are executed asynchronously
:row.
:c.BIND_TYPE                 :c. *  :c.    :c.sets the binding type
:row.
:c.CONCURRENCY               :c. *  :c.    :c.sets cursor concurrencies,
see below.
:row.
:c.CURSOR_TYPE               :c. *  :c.    :c.sets the cursor type on the
statement handle
:row.
:c.GET_BOOKMARK              :c.    :c.    :c.not supported!
:row.
:c.KEYSET_SIZE               :c. *  :c.    :c.sets the size of the key set
:row.
:c.MAX_LENGTH                :c. *  :c.    :c.sets the maximum length of a
result column of a query, use MAX_LENGTH_DEFAULT for no limit
:row.
:c.MAX_ROWS                  :c. *  :c.    :c.sets the maximum number of
rows producable by a query, use MAX_ROWS_DEFAULT for no limit
:row.
:c.NOSCAN                    :c. *  :c.    :c.when set TRUE, there is no scan
for escape sequences in SQL statements
:row.
:c.QUERY_TIMEOUT             :c. *  :c.    :c.sets the timeout value on
queries, use QUERY_TIMEOUT_DEFAULT for no limit
:row.
:c.RETRIEVE_DATA             :c.    :c.    :c.not supported!
:row.
:c.ROW_NUMBER                :c.    :c.    :c.not supported!
:row.
:c.ROWSET_SIZE               :c. *  :c.    :c.sets the size of the row set
:row.
:c.SIMULATE_CURSOR           :c.    :c.    :c.not supported!
:row.
:c.USE_BOOKMARKS             :c.    :c.    :c.not supported!
:etable.

:p.Possible values for :hp2.CONCURRENCY:ehp2.&colon.
:lm margin=5.:ul.
:li.:hp2.CONCUR_READ_ONLY:ehp2. - cursor is read-only, no updates allowed
:li.:hp2.CONCUR_LOCK:ehp2. - update allowed using locking mechanism
:li.:hp2.CONCUR_ROWVER:ehp2. - update allowed using row version method
:li.:hp2.CONCUR_VALUES:ehp2. - update allowed
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'specialColumns()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_specialColumns clear.specialColumns()
:xmp.
public native void    specialColumns( int fColType,
                                      String tableQualifier,
                                      String tableOwner,
                                      String tableName,
                                      int fScope,
                                      boolean fNullable ) throws Exception;
:exmp.
:p.Returns special columns (like primary keys or indices) of tables matching
the conditions in a result set, like a query does. Before this method can be
called, a statement handle has to be
:link reftype=hd refid=class_J2ODBC_allocStmt.obtained:elink..
:hp2.fColType:ehp2. is one of these&colon.
:lm margin=5.:ul.
:li.BEST_ROWID - return the best set of column(s) for identification of a row
:li.ROWVER - return all data (?)
:eul.:lm margin=1.

The parameter :hp2.tableQualifier:ehp2., if set, reduces the resulting list to
those tables, which are mapped to the specified qualifier (catalogue). The same
do :hp2.tableOwner:ehp2. for the owner of tables and :hp2.tableName:ehp2. for
table names. Setting a parameter :hp1.null:ehp1. disables this search criteria
and returns all data (matching the other criterias).

:p.In some string parameters a so-called joker ('%') may occur. It stands for
a variable-sized string of variable characters.

The parameter :hp2.fScope:ehp2. specifies the duration, on which a
:hp1.ROWID:ehp1. value identifying a single row is valid&colon.
:lm margin=5.:ul.
:li.SCOPE_CURROW - only for the next statement
:li.SCOPE_TRANSACTION - during this transaction
:li.SCOPE_SESSION - during this connection
:eul.:lm margin=1.

:note.
The result may vary depending on the database software (i.e. ODBC driver).
Consult the appropriate documentation there!

.*------------------------------------------------------------------------------
.*   'statistics()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_statistics clear.statistics()
:xmp.
public native void    statistics( String tableQualifier,
                                  String tableOwner,
                                  String tableName,
                                  boolean fUnique,
                                  boolean fAccuracy ) throws Exception;
:exmp.
:p.Returns statistics about one or more tables matching the search criterias
in a result set, like a query does. Before this method can be called, a
statement handle has to be
:link reftype=hd refid=class_J2ODBC_allocStmt.obtained:elink.. The parameter
:hp2.tableQualifier:ehp2., if set, reduces the resulting list to those tables,
which are mapped to the specified qualifier (catalogue). The same do
:hp2.tableOwner:ehp2. for the owner of tables and :hp2.tableName:ehp2. for
table names. Setting a parameter :hp1.null:ehp1. disables this search criteria
and returns all data (matching the other criterias). The parameter
:hp2.fUnique:ehp2. (if set TRUE) prevents redundancies in data about indices,
the parameter :hp2.fAccuracy:ehp2. (if set TRUE) ensures data returned to be
stable - under some conditions setting this may be necessary to prevent
inaccurate data.

:p.In some string parameters a so-called joker ('%') may occur. It stands for
a variable-sized string of variable characters.

:note.
The result may vary depending on the database software (i.e. ODBC driver).
Consult the appropriate documentation there!

.*------------------------------------------------------------------------------
.*   'tablePrivileges()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_tablePrivileges clear.tablePrivileges()
:xmp.
public native void    tablePrivileges( String tableQualifier,
                                       String tableOwner,
                                       String tableName ) throws Exception;
:exmp.
:p.Returns privileges on tables matching the conditions in a result set, like
a query does. Before this method can be called, a statement handle has to be
:link reftype=hd refid=class_J2ODBC_allocStmt.obtained:elink.. The parameter
:hp2.tableQualifier:ehp2., if set, reduces the resulting list to those tables,
which are mapped to the specified qualifier (catalogue). The same do
:hp2.tableOwner:ehp2. for the owner of tables and :hp2.tableName:ehp2. for
table names. Setting a parameter :hp1.null:ehp1. disables this search criteria
and returns all data (matching the other criterias).

:p.In some string parameters a so-called joker ('%') may occur. It stands for
a variable-sized string of variable characters.

:note.
The result may vary depending on the database software (i.e. ODBC driver).
Consult the appropriate documentation there!

.*------------------------------------------------------------------------------
.*   'tables()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_tables clear.tables()
:xmp.
public native void    tables( String tableQualifier,
                              String tableOwner,
                              String tableName,
                              String tableType ) throws Exception;
:exmp.
:p.Returns the tables matching the conditions in a result set, like a query
does. Before this method can be called, a statement handle has to be
:link reftype=hd refid=class_J2ODBC_allocStmt.obtained:elink.. The parameter
:hp2.tableQualifier:ehp2., if set, reduces the resulting list to those tables,
which are mapped to the specified qualifier (catalogue). The same do
:hp2.tableOwner:ehp2. for the owner of tables, :hp2.tableName:ehp2. for table
names and :hp2.tableType:ehp2. for the type of table (i.e. views, real tables,
aliases, synonyms, etc.). Setting a parameter :hp1.null:ehp1. disables this
search criteria and returns all data (matching the other criterias).

:p.In some string parameters a so-called joker ('%') may occur. It stands for
a variable-sized string of variable characters.

:note.
The result may vary depending on the database software (i.e. ODBC driver).
Consult the appropriate documentation there!

.*------------------------------------------------------------------------------
.*   'transact()'
.*------------------------------------------------------------------------------
:h4 id=class_J2ODBC_transact clear.transact()
:xmp.
public native void    transact( int fType ) throws Exception;
:exmp.
:p.Terminates all previous database transactions be validating
(:hp1.fType:ehp1. = :hp2.COMMIT:ehp2.) or invalidating (:hp2.ROLLBACK:ehp2.)
them.

.*------------------------------------------------------------------------------
