.*------------------------------------------------------------------------------
.* JdbcOdbc (OS/2) - info
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'Introduction'
.*------------------------------------------------------------------------------
:h1 id=introduction clear.Introduction
:p.:hp1.Java:ehp1., Sun's progressive new platform-independent language, is a
first-level choice of todays software development. Because of its strength -
to be platform independent - it fits the needs for having software on various
(different) hardware.

:p.But a programming language is one thing - another the access to the
peripherie, especially the access to data storages, as represented by SQL
databases. In order to prevent proprietary solutions, Sunsoft, a daughter firm
of Sun Systems, set up a standard for database access, called JDBC -
:hp1.Java DataBase Connection:ehp1.. This API is based on experiences of
previous solutions for other languages and systems - mainly X/Open's SQL
Call-Level Interface (:hp1.CLI:ehp1.) and Microsoft's Open DataBase
Connectivity (:hp1.ODBC:ehp1.)..

:p.The main idea is as follows&colon.

:artwork name='images\jdbc_1.bmp' align=center.

:lm margin=5.:ol.
:li.The :hp2.Java application:ehp2. talks to a standarized API, represented by
:li.the :hp2.JDBC driver manager:ehp2., that, depending on the connection
parameters set by the application, connects to one of the
:li.:hp2.JDBC drivers:ehp2.. They implement methods and routines for accessing
the data on a database. A JDBC driver may be either database specific, or
represent a
:li.:hp2.JDBC-ODBC bridge:ehp2., which translates :hp1.JDBC:ehp1. requests to
the appropriate :hp1.ODBC:ehp1. calls. These are then sent to the
:li.:hp2.ODBC driver manager:ehp2., that calls the proper
:li.:hp2.ODBC driver:ehp2. for database access.
:eol.:lm margin=1.

:p.One may say, that using a :hp1.JDBC-ODBC bridge:ehp1. reduces performance
of a Java application. Sure, each call-translation cost time. On the other
hand, there are not enough native Java JDBC drivers available, yet. A lot of
database vendors don't develop or haven't developed yet JDBC drivers. So for
many databases taking the ODBC driver is the only chance to get in connection
with the data.

.*------------------------------------------------------------------------------
.*   '1,2,3-Tier Solutions'
.*------------------------------------------------------------------------------
:h2 id=tiers clear.1,2,3-Tier Solutions
:p.Speaking of :hp1.Java DataBase Connection:ehp1. means speaking of connecting
two different worlds. Most databases are written in an other language than
Java, so interactions have to go across a border set up by the system(s).
To build the bridge between application and database, there are several
solutions depending the database system&colon.

:lm margin=5.:ol.
:li.The so-called :hp4.1-tier:ehp4. solution represents a JDBC driver, that
connects directly to the database system (i.e. to its proprietary protocol or
API). Such solutions are rare, because informations about internal protocols
and other details of databases are kept close by the manufacturer. A 1-tier
driver is always written entirely in Java and is platform-independent.
:li.Therefor :hp4.2-tier:ehp4. solutions use the official programming API or
interface of the database. This includes the indirect going via ODBC driver
manager and ODBC driver. Such a solutions consists of a JDBC driver written
in Java, which calls routines located in an external dynamic runtime library
(under Unix a dynamic library :hp2.lib*.sl:ehp2., under OS/2 or Windows a
dynamic link library :hp2.*.DLL:ehp2.), written mostly in C/C++. For that
reason, 2-tier solutions are :hp2.not:ehp2. platform-independent.
:li.At last, the :hp4.3-tier:ehp4. solutions take another step. A JDBC driver,
written entirely in Java, talks to a server process on the same or another
machine (i.e. TCP/IP-connection). This server process is written in another
language (C/C++, or anything else) and has the routines for database access
built-in. Here, the Java application stays platform-independent, only the
separate server process is platform dependent. But the server process may not
be located on the same machine as the application - it may be moved to any
machine the Java application may connect to. So the Java application can be a
web applet, which is downloadable by any user in the Internet.
:eol.:lm margin=1.

:p.For the moment, this JDBC-ODBC bridge is a :hp1.2-tier solution:ehp1., so
the Java applications needs its dynamic library on the same machine.
A :hp1.3-tier solution:ehp1. may be available at a later time ...

.*------------------------------------------------------------------------------
.*   'Further Informations ...'
.*------------------------------------------------------------------------------
:h2 id=further_info clear.Further Informations ...
:p.For further informations have a look on the following links and
references&colon.

:lm margin=5.:ul.
:li.IBM Center for Java Technologie -
:hp2.http&colon.//ncc.hursley.ibm.com/javainfo:ehp2.
:li.Java Home Page (Java, JDBC, JDBC driver manager) -
:hp2.http&colon.//java.sun.com:ehp2.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'Copyrights'
.*------------------------------------------------------------------------------
:h2 id=copyrights clear.Copyrights
:p.The Java(tm) technology is owned and exclusively licensed by
Sun Microsystems Inc.. Java is a trademark of Sun Microsystems Inc. in
the U.S. and other countries.

.*------------------------------------------------------------------------------
