.*------------------------------------------------------------------------------
.* JdbcOdbc (OS/2) - examples
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'Examples'
.*------------------------------------------------------------------------------
:h1 id=examples clear.Examples
:p.This section describe the sample programs coming with this JDBC-ODBC bridge.
They are located in the :hp2.JAVA\demo\:ehp2. directory.

:p.Currently, these demos or sample programs are available&colon.
:lm margin=5.:ul.
:li.:hp1.:link reftype=hd refid=example_1.Example1:elink.:ehp1.
- a simple skeleton program, showing how to connect to the JDBC-ODBC bridge.
:li.:hp1.:link reftype=hd refid=example_2.Example2:elink.:ehp1.
- creates a testing table, fills it, shows the data and drops the table.
:eul.:lm margin=1.

:note.
The following assumptions are made. If one or more are wrong, correct the data
in the sources, recompile and the try.
:lm margin=5.:ul.
:li.There is a database or a data source called :hp2.test:ehp2., providing a
SQL interface via the JDBC-ODBC bridge.
:li.For login on this database or data source, there is a user
:hp2.unknown:ehp2. with an :hp2.empty password:ehp2..
:li.For :link reftype=hd refid=example_2.example #2:elink., a testing table
:hp2.example2:ehp2. may be created temporarily.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.* 'Example #1'
.*------------------------------------------------------------------------------
:h2 id=example_1 clear.Example #1
:p.
:xmp.
//
// Example #1
//
// This example shows the use of the JDBC-ODBC bridge and may be used as a
// skeleton for further experiments.
//
// (c) 1996 by Dirk Ohme, all rights reserved
//

//---| imports |--------------------------------------------------------------
import java.net.URL;
import java.sql.*;

//---| class Example1 |-------------------------------------------------------
public class Example1 {
        //
        // definitions
        //
        //---| name of the database user |---
        private static final String dbUser = "unknown";
        //---| his password |---
        private static final String dbPwd = "";
        //---| which database source name or database server? |---
        private static final String dbSrc = "test";

        //
        // main function
        //
        public static void main( String argv[] ) {
                try {
                        // enable debugging
                        // DriverManager.setLogStream( System.out );

                        // capture JDBC-ODBC bridge
                        String jdbcDriver = "iODBC.sql.JdbcOdbcDriver";
                        Class.forName(jdbcDriver).newInstance();

                        // Make sure there is a JDBC-ODBC driver loaded.
                        System.out.println(
                                "trying to open JDBC interface ..."
                        );

                        // make connection to
                        Connection con = DriverManager.getConnection(
                                "jdbc&colon.odbc&colon."+dbSrc, dbUser, dbPwd
                        );
                        System.out.println( "connection established" );

                        // starting here, SQL statements may be executed
                        // ...

                        // close connection
                        con.close();
                        System.out.println( "connection closed" );

                } catch( Exception e ) {
                        System.out.println(e.getMessage());
                        e.printStackTrace();
                }
        }
} /* class Example1() */

//===| end of file |===========================================================
:exmp.

.*------------------------------------------------------------------------------
.* 'Example #2'
.*------------------------------------------------------------------------------
:h2 id=example_2 clear.Example #2
:p.
:xmp.
//
// Example #2
//
// This example shows the use of the JDBC-ODBC bridge.
//
// (c) 1996 by Dirk Ohme, all rights reserved
//

//---| imports |--------------------------------------------------------------
import java.net.URL;
import java.sql.*;

//---| class Example2 |-------------------------------------------------------
public class Example2 {
        //
        // definitions
        //
        //---| name of the database user |---
        private static final String dbUser = "unknown";
        //---| his password |---
        private static final String dbPwd = "";
        //---| which database source name or database server? |---
        private static final String dbSrc = "test";
        //---| which table to use for testing? |---
        private static final String dbTable = "example2";

        //
        // main function
        //
        public static void main( String argv[] ) {
                try {
                        // enable debugging
                        // DriverManager.setLogStream( System.out );

                        // capture JDBC-ODBC bridge
                        String jdbcDriver = "iODBC.sql.JdbcOdbcDriver";
                        Class.forName(jdbcDriver).newInstance();

                        // Make sure there is a JDBC-ODBC driver loaded.
                        System.out.println(
                                "trying to open JDBC interface ..."
                        );

                        // make connection to
                        Connection con = DriverManager.getConnection(
                                "jdbc&colon.odbc&colon."+dbSrc, dbUser, dbPwd
                        );
                        System.out.println( "connection established" );

                        // get a statement object
                        Statement stmt = con.createStatement();

                        // fill in some testing data
                        int result = 0;
                        System.out.println( "preparing testing data ..." );
                        result = stmt.executeUpdate(
                                "create table " + dbTable +
                                " (namestr CHAR(20), age INT, phone CHAR(40))"
                        );
                        System.out.print( " "+result );
                        result = stmt.executeUpdate(
                                "insert into " + dbTable +
                                " values ('Dirk Ohme', 25, '0-7071-123456')"
                        );
                        System.out.print( " "+result );
                        result = stmt.executeUpdate(
                                "insert into " + dbTable +
                                " values ('Marius Mustermann', 40, '98765')"
                        );
                        System.out.print( " "+result );
                        result = stmt.executeUpdate(
                                "insert into " + dbTable +
                                " values ('Erika Musterfrau', 18, '0815')"
                        );
                        System.out.print( " "+result );
                        System.out.println( " done." );

                        // query data
                        ResultSet rs = stmt.executeQuery(
                                "select * from " + dbTable
                        );
                        System.out.println("getting results&colon.");
                        int row = 0;
                        while( rs.next() ) {
                                // display results
                                String user  = rs.getString( 1 );
                                int    age   = rs.getInt( 2 );
                                String phone = rs.getString( 3 );
                                row++;

                                System.out.println(
                                        "  #" + row +
                                        " user = '"  + user  + "'," +
                                        " age = "    + age   + ", " +
                                        " phone = '" + phone + "'"
                                );
                        }

                        // close result set
                        rs.close();
                        System.out.println(
                                "all rows processed (" + row + ")"
                        );

                        // drop testing table
                        System.out.println( "droping testing data ..." );
                        result = stmt.executeUpdate(
                                "drop table " + dbTable
                        );
                        System.out.println( " "+result+" done." );

                        // closing statement handle
                        stmt.close();
                        System.out.println( "statement handle closed" );

                        // close connection
                        con.close();
                        System.out.println( "connection closed" );

                } catch( Exception e ) {
                        System.out.println(e.getMessage());
                        e.printStackTrace();
                }
        }
} /* class Example2() */

//===| end of file |===========================================================
:exmp.

.*------------------------------------------------------------------------------
