/*
** TRANSACT.C - This is the module containing the code for ODBC for
** processing transactions.
**
** (c) 1997 by Dirk Ohme - all rights reserved
*/

/*---| includes |------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <javaString.h>
#include <sqlcli_.h>

#include "iODBC_sql_dll_J2ODBC.h"

/*---------------------------------------------------------------------------*/
/*       Set Transaction                                                     */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_transact( struct HiODBC_sql_dll_J2ODBC *this,
                                    long fType )
{
        RETCODE         rc;
        SQLHENV         henv;
        SQLHDBC         hdbc;

        /*
        ** set transaction
        */
        henv = (SQLHENV) unhand(this)->henv;
        hdbc = (SQLHDBC) unhand(this)->hdbc;

        if( SQL_SUCCESS != (rc=SQLTransact(henv, hdbc, fType)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:transact] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "transact: cannot set transaction" );
        }
}

/*===| end of file |=========================================================*/
