//
// test.java
//
// Testing class for JDBC-ODBC-Gateway via dynamic link library
//
// (c) 1997 by Dirk Ohme
//

//---| imports |---------------------------------------------------------------
import java.lang.*;
import java.util.*;
import iODBC.sql.dll.*;

//---| class definition |------------------------------------------------------
class test {
  /*
  ** constructor
  */
  public test() {
        //---| empty |---
  }

  /*
  ** main routine
  */
  public static void main( String argv[] ) {

        J2ODBC     j2o = null;

        //---| initialize |---
        System.out.println( "[J2ODBC] initializing" );

        //---| start connection |---
        try {
                //---| start new connection |---
                System.out.println( "[J2ODBC]   starting connection" );
                j2o = new J2ODBC();
                j2o.allocEnv();
                j2o.allocConnect();
                j2o.connect( "test", "test", "unknown" );

        } catch( Exception e ) {
                //---| display exception message |---
                System.out.println(
                        "[J2ODBC]     Exception = '"
                        + e.getMessage() + "'"
                );
        }

        //---| perform some tests |---
        try {
                //---| start tests ... |---
                System.out.println( "[J2ODBC]   starting tests" );
                j2o.allocStmt();

                //---| create testing table |---
                System.out.println( "[J2ODBC]     create testing table" );
                j2o.execDirect(
                        "create table j2odbc_test ("
                        + "name char(20), age integer, phone char(40))"
                );
                j2o.freeStmt( j2o.CLOSE );

                //---| insert data |---
                System.out.println( "[J2ODBC]     insert data" );
                j2o.execDirect(
                        "insert into j2odbc_test values ("
                        + "'Dirk Ohme', 25, '+49-7071-703-190')"
                );
                j2o.freeStmt( j2o.CLOSE );
                j2o.execDirect(
                        "insert into j2odbc_test values ("
                        + "'Sysman', 0, '+49-7071-703-208')"
                );
                j2o.freeStmt( j2o.CLOSE );
                j2o.execDirect(
                        "insert into j2odbc_test values ("
                        + "'Sysman 2', 0, '+49-7071-703-174')"
                );
                j2o.freeStmt( j2o.CLOSE );

                //---| start query |---
                System.out.println( "[J2ODBC]     query testing data" );
                        //---| prepare |---
                j2o.prepare( "select * from j2odbc_test" );
                        //---| execute |---
                j2o.execute();
                        //---| number of rows and columns |---
                System.out.println( "[J2ODBC]       number of rows    = " +
                        j2o.rowCount()
                );
                int cols = j2o.numResultCols();
                System.out.println( "[J2ODBC]       number of columns = " +
                        cols
                );
                        //---| display column info |---
                int actCol = 0;
                System.out.println( "[J2ODBC]       column info:" );
                for( actCol = 1; actCol <= cols; actCol++ ) {
                        j2o.describeCol( actCol );
                        System.out.println( "[J2ODBC]         " + actCol +
                                " '" + j2o.describeColName() + "', " +
                                j2o.describeColType() + ", prec=" +
                                j2o.describeColPrecision() + ", scale=" +
                                j2o.describeColScale() + ", nullable=" +
                                j2o.describeColNullable()
                        );
                }
                        //---| fetch data |---
                int actRow = 0;
                System.out.println( "[J2ODBC]       data:" );
                while( j2o.fetch() ) {
                        actRow++;
                        System.out.print( "[J2ODBC]         " + actRow );
                        for( actCol = 1; actCol <= cols; actCol++ ) {
                                System.out.print(
                                        ", " + j2o.getDataString(actCol)
                                );
                        }
                        System.out.println();
                }
                        //---| free statement |---
                j2o.freeStmt( j2o.CLOSE );

                //---| drop testing table |---
                System.out.println( "[J2ODBC]     drop testing table" );
                j2o.execDirect( "drop table j2odbc_test" );
                j2o.freeStmt( j2o.CLOSE );

                //---| stop tests |---
                System.out.println( "[J2ODBC]   stopping tests" );
                j2o.freeStmt( j2o.DROP );

                //---| perform transaction |---
                j2o.transact( J2ODBC.COMMIT );
                // j2o.transact( J2ODBC.ROLLBACK );

        } catch( Exception e ) {
                //---| display exception message |---
                System.out.println(
                        "[J2ODBC]     Exception = '"
                        + e.getMessage() + "'"
                );

                //---| try to get SQL error message |---
                try {
                        //---| display SQL error message |---
                        System.out.println(
                                "[J2ODBC]     SqlError  = '"
                                + j2o.error() + "'"
                        );
                } catch( Exception ef ) {
                        //---| exception on trial to get SQL error message |---
                        System.out.println(
                                "[J2ODBC]     Follow-Up = '"
                                + ef.getMessage() + "'"
                        );
                }
        }

        //---| close connection |---
        try {
                //---| free connection |---
                System.out.println( "[J2ODBC]   closing connection" );
                j2o.disconnect();
                j2o.freeConnect();
                j2o.freeEnv();
                j2o = null;

        } catch( Exception e ) {
                //---| display exception message |---
                System.out.println(
                        "[J2ODBC]     Exception = '"
                        + e.getMessage() + "'"
                );
        }

        //---| exit |---
        System.out.println( "[J2ODBC] finalizing" );

  } /*---| main() |---*/
}

//===| end of file |===========================================================
