/*
** OPTIONS.C - This is the module containing the code for ODBC for
** setting options on a connection, statement, or else.
**
** (c) 1997 by Dirk Ohme - all rights reserved
*/

/*---| includes |------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <javaString.h>
#include <sqlcli_.h>

#include "iODBC_sql_dll_J2ODBC.h"

/*---------------------------------------------------------------------------*/
/*       Set a Connection Option                                             */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_setConnectOptionNum( struct HiODBC_sql_dll_J2ODBC *this,
                                               long fOption, long paramValue )
{
        RETCODE         rc;
        SQLHDBC         hdbc;

        /*
        ** set connection option
        */
        hdbc = (SQLHDBC) unhand(this)->hdbc;

        if( SQL_SUCCESS != (rc=SQLSetConnectOption(hdbc, fOption, paramValue)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:setConnectOptionNum] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "setConnectOptionNum: cannot set option" );
        }
}

void iODBC_sql_dll_J2ODBC_setConnectOptionStr(
                             struct HiODBC_sql_dll_J2ODBC *this,
                             long fOption, struct Hjava_lang_String *paramStr )
{
        RETCODE         rc;
        SQLHDBC         hdbc;
        SQLCHAR         szParamStr[ SQL_MAX_OPTION_STRING_LENGTH + 1 ];

        /*
        ** set connection option
        */
        javaString2CString( paramStr, szParamStr, sizeof(szParamStr) );

        hdbc = (SQLHDBC) unhand(this)->hdbc;

        if( SQL_SUCCESS != (rc=SQLSetConnectOption(hdbc, fOption,
                                                   (UDWORD) szParamStr)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:setConnectOptionStr] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "setConnectOptionStr: cannot set option" );
        }
}

/*---------------------------------------------------------------------------*/
/*       Set a Statement Option                                              */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_setStmtOptionNum( struct HiODBC_sql_dll_J2ODBC *this,
                                            long fOption, long paramValue )
{
        RETCODE         rc;
        SQLHDBC         hdbc;

        /*
        ** set statement option
        */
        hdbc = (SQLHDBC) unhand(this)->hdbc;

        if( SQL_SUCCESS != (rc=SQLSetStmtOption(hdbc, fOption, paramValue)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:setStmtOptionNum] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "setStmtOptionNum: cannot set option" );
        }
}

void iODBC_sql_dll_J2ODBC_setStmtOptionStr( struct HiODBC_sql_dll_J2ODBC *this,
                                            long fOption, struct Hjava_lang_String *paramStr )
{
        RETCODE         rc;
        SQLHDBC         hdbc;
        SQLCHAR         szParamStr[ SQL_MAX_OPTION_STRING_LENGTH + 1 ];

        /*
        ** set statement option
        */
        javaString2CString( paramStr, szParamStr, sizeof(szParamStr) );

        hdbc = (SQLHDBC) unhand(this)->hdbc;

        if( SQL_SUCCESS != (rc=SQLSetStmtOption(hdbc, fOption,
                                                (UDWORD) szParamStr)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:setStmtOptionStr] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "setStmtOptionStr: cannot set option" );
        }
}

/*---------------------------------------------------------------------------*/
/*       Get a Connection Option                                             */
/*---------------------------------------------------------------------------*/
long iODBC_sql_dll_J2ODBC_getConnectOptionNum( struct HiODBC_sql_dll_J2ODBC *this,
                                               long fOption )
{
        RETCODE         rc;
        SQLHDBC         hdbc;
        long            ulResult;

        /*
        ** get connection option
        */
        hdbc     = (SQLHDBC) unhand(this)->hdbc;
        ulResult = 0;

        rc = SQLGetConnectOption(hdbc, fOption, (SQLPOINTER) &ulResult );

        if( SQL_NO_DATA_FOUND == rc )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:getConnectOptionNum] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "java/lang/NullPointerException",
                             "getConnectOptionNum: option not set" );
                return 0;
        }

        if( SQL_SUCCESS != rc )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:getConnectOptionNum] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "getConnectOptionNum: cannot get option" );
                return 0;
        }

        /*
        ** return result
        */
        return ulResult;
}

Hjava_lang_String * iODBC_sql_dll_J2ODBC_getConnectOptionStr(
                             struct HiODBC_sql_dll_J2ODBC *this,
                             long fOption )
{
        RETCODE         rc;
        SQLHDBC         hdbc;
        SQLCHAR         szParamStr[ SQL_MAX_OPTION_STRING_LENGTH + 1 ];

        /*
        ** get connection option
        */
        hdbc          = (SQLHDBC) unhand(this)->hdbc;
        szParamStr[0] = '\0';

        rc = SQLGetConnectOption(hdbc, fOption, (SQLPOINTER) &szParamStr[0] );

        if( SQL_NO_DATA_FOUND == rc )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:getConnectOptionStr] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "java/lang/NullPointerException",
                             "getConnectOptionStr: option not set" );
                return NULL;
        }

        if( SQL_SUCCESS != rc )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:getConnectOptionStr] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "getConnectOptionStr: cannot get option" );
                return NULL;
        }

        /*
        ** return result
        */
        return makeJavaString(szParamStr, strlen(szParamStr));
}

/*---------------------------------------------------------------------------*/
/*       Get a Statement Option                                              */
/*---------------------------------------------------------------------------*/
long iODBC_sql_dll_J2ODBC_getStmtOptionNum( struct HiODBC_sql_dll_J2ODBC *this,
                                            long fOption )
{
        RETCODE         rc;
        SQLHDBC         hdbc;
        long            ulResult;

        /*
        ** get connection option
        */
        hdbc     = (SQLHDBC) unhand(this)->hdbc;
        ulResult = 0;

        rc = SQLGetStmtOption(hdbc, fOption, (SQLPOINTER) &ulResult );

        if( SQL_NO_DATA_FOUND == rc )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:getStmtOptionNum] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "java/lang/NullPointerException",
                             "getStmtOptionNum: option not set" );
                return 0;
        }

        if( SQL_SUCCESS != rc )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:getStmtOptionNum] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "getStmtOptionNum: cannot get option" );
                return 0;
        }

        /*
        ** return result
        */
        return ulResult;
}

Hjava_lang_String * iODBC_sql_dll_J2ODBC_getStmtOptionStr(
                             struct HiODBC_sql_dll_J2ODBC *this,
                             long fOption )
{
        RETCODE         rc;
        SQLHDBC         hdbc;
        SQLCHAR         szParamStr[ SQL_MAX_OPTION_STRING_LENGTH + 1 ];

        /*
        ** get connection option
        */
        hdbc          = (SQLHDBC) unhand(this)->hdbc;
        szParamStr[0] = '\0';

        rc = SQLGetStmtOption(hdbc, fOption, (SQLPOINTER) &szParamStr[0] );

        if( SQL_NO_DATA_FOUND == rc )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:getStmtOptionStr] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "java/lang/NullPointerException",
                             "getStmtOptionStr: option not set" );
                return NULL;
        }

        if( SQL_SUCCESS != rc )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:getStmtOptionStr] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "getStmtOptionStr: cannot get option" );
                return NULL;
        }

        /*
        ** return result
        */
        return makeJavaString(szParamStr, strlen(szParamStr));
}

/*===| end of file |=========================================================*/
