/*
 * makedefs
 *
 * generate a *.DEF file by parsing the *.C source(s)
 *
 * (c) 1997 by Dirk Ohme - all rights reserved
 */

/*---| includes |-------------------------------------------------------------*/
call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs

/*---| initializing |---------------------------------------------------------*/
say "MAKEDEFS is initializing ..."

if 0 = arg() then do
        say "  invalid syntax!"
        say "  Syntax: makedefs <outfile.def> {<infile.c>}"
        exit 1
end

outfile = word( arg(1), 1 );
infile  = subword( arg(1), 2 );

if 2 < SysFileDelete(outfile) then do
        say "  can't delete '"outfile"' prior re-creation!"
        exit 2
end

library = outfile
if 0 <> lastpos("\\", library) then library = substr(library, lastpos("\\", library)+1)
if 0 <> lastpos(".",  library) then library = substr(library, 1, lastpos(".",  library)-1)

/*---| generate head of outfile |---------------------------------------------*/
error = 0
error = error + lineout( outfile, ";" );
error = error + lineout( outfile, "; "library".DEF" );
error = error + lineout( outfile, ";" );
error = error + lineout( outfile, "; automated creation by MAKEDEFS" );
error = error + lineout( outfile, ";" );
error = error + lineout( outfile, "" );
error = error + lineout( outfile, "LIBRARY "library" INITINSTANCE" );
error = error + lineout( outfile, "DATA MULTIPLE NONSHARED" );
error = error + lineout( outfile, "" );
if 0 <> error then do
        say "  error generating outfile!"
        exit 3
end

/*---| scan infiles |---------------------------------------------------------*/
num = 1
do while 0 < length(infile)
        /*---| scan current file |--------------------------------------------*/
        do while lines( word(infile, 1) )
                /*---| read line from file |----------------------------------*/
                zeile = linein( word(infile, 1) )

                /*---| check for comments, includes, etc. |-------------------*/
                if "/" = substr(zeile, 1, 1) then zeile=""
                if "#" = substr(zeile, 1, 1) then zeile=""
                if "*" = substr(zeile, 1, 1) then zeile=""
                if "*" = substr(zeile, 2, 1) then zeile=""
                if 0 <> pos("{", zeile) then zeile = substr( zeile, 1, pos("{", zeile)+1 )
                if 0 <> pos("}", zeile) then zeile = substr( zeile, pos("}", zeile)+1 )
                if length(zeile) = lastpos(";", zeile) then zeile=""
                if " " = substr(zeile, 1, 1) then do
                        if "stack_item" <> word(zeile, 1) then zeile=""
                end

                /*---| check for function header |----------------------------*/
                end_delimiter   = pos( "(", zeile )
                start_delimiter = 0
                curr_delimiter  = 1
                do while 0 <> curr_delimiter
                        if curr_delimiter > end_delimiter then
                                curr_delimiter  = 0
                        else
                                start_delimiter = curr_delimiter
                        if 0 <> curr_delimiter then
                                curr_delimiter  = pos( " ", zeile, curr_delimiter+1 )
                end
                if 0 <> end_delimiter then do
                        if 0 <> start_delimiter then do
                                start_delimiter = start_delimiter + 1
                                end_delimiter   = end_delimiter - start_delimiter
                                zeile = substr(zeile, start_delimiter, end_delimiter)
                                say "  adding function #"num" - '"zeile"'"
                                error = error + lineout( outfile, "EXPORTS "zeile" @"num )
                                num   = num   + 1
                        end
                end
        end

        /*---| next file |----------------------------------------------------*/
        infile = subword( infile, 2 );
end

/*---| terminate |------------------------------------------------------------*/
error = error + lineout( outfile, "" );
error = error + lineout( outfile, ";===| end of file '"library".DEF' |===" );
error = error + lineout( outfile )
if 0 <> error then do
        say "  error closing '"outfile"'!!!"
        exit 4
end
say "  "num - 1" functions processed"
say "done."
exit 0

/*============================================================================*/
