/*
** INFO.C - This is the module containing the code for ODBC for
** gathering informations about the ODBC driver.
**
** (c) 1997 by Dirk Ohme - all rights reserved
*/

/*---| includes |------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <javaString.h>
#include <sqlcli_.h>

#include "iODBC_sql_dll_J2ODBC.h"

/*---------------------------------------------------------------------------*/
/*       Get Information                                                     */
/*---------------------------------------------------------------------------*/
long iODBC_sql_dll_J2ODBC_getInfoNum( struct HiODBC_sql_dll_J2ODBC *this,
                                      long fInfoType )
{
        RETCODE         rc;
        SQLHDBC         hdbc;
        long            ulResult;

        /*
        ** get information
        */
        hdbc     = (SQLHDBC) unhand(this)->hdbc;
        ulResult = 0;

        if( SQL_SUCCESS != (rc=SQLGetInfo(hdbc, fInfoType,
                                          (SQLPOINTER) &ulResult,
                                          sizeof(ulResult), NULL)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:getInfoNum] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "getInfoNum: cannot get info" );
                return 0;
        }

        /*
        ** return result
        */
        return ulResult;
}

Hjava_lang_String * iODBC_sql_dll_J2ODBC_getInfoStr(
                             struct HiODBC_sql_dll_J2ODBC *this,
                             long fInfoType )
{
        RETCODE         rc;
        SQLHDBC         hdbc;
        SQLCHAR         szResult[ SQL_MAX_OPTION_STRING_LENGTH + 1 ];
        SQLSMALLINT     cbResult;

        /*
        ** get information
        */
        hdbc        = (SQLHDBC) unhand(this)->hdbc;
        szResult[0] = '\0';
        cbResult    = 0;

        if( SQL_SUCCESS != (rc=SQLGetInfo(hdbc, fInfoType,
                                          (SQLPOINTER) &szResult[0],
                                          sizeof(szResult), &cbResult)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:getInfoStr] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "getInfoStr: cannot get info" );
                return NULL;
        }

        /*
        ** return result
        */
        return makeJavaString(szResult, cbResult);
}

/*---------------------------------------------------------------------------*/
/*       Get Information about SQL Data Types                                */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_getTypeInfo(
                             struct HiODBC_sql_dll_J2ODBC *this,
                             long fSqlType )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;

        /*
        ** get SQL type information
        */
        hstmt = (SQLHSTMT) unhand(this)->hstmt;

        if( SQL_SUCCESS != (rc=SQLGetTypeInfo(hstmt, fSqlType)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:getTypeInfo] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "getTypeInfo: cannot get info" );
        }
}

/*===| end of file |=========================================================*/
