/*
** EXECUTE.C - This is the module containing the code for ODBC for
** executing SQL Commands.
**
** (c) 1997 by Dirk Ohme - all rights reserved
*/

/*---| includes |------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <javaString.h>
#include <sqlcli_.h>

#include "iODBC_sql_dll_J2ODBC.h"

/*---------------------------------------------------------------------------*/
/*       Execute a prepared SQL Statement                                    */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_execute( struct HiODBC_sql_dll_J2ODBC *this )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;

        /*
        ** execute
        */
        hstmt = (SQLHSTMT) unhand(this)->hstmt;

        if( SQL_SUCCESS != (rc=SQLExecute(hstmt)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:execute] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "execute: cannot execute prepared SQL statement" );
        }
}

/*---------------------------------------------------------------------------*/
/*       Prepare and Execute a SQL Statement                                 */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_execDirect( struct HiODBC_sql_dll_J2ODBC *this,
                                      struct Hjava_lang_String *sqlStmt )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;
        SQLCHAR        *pszSqlStmt = NULL;

        /*
        ** prepare and execute
        */
        /*---| initialize parameters |---*/
        hstmt      = (SQLHSTMT) unhand(this)->hstmt;
        pszSqlStmt = allocCString( sqlStmt );

        /*---| perform preparation and execution |---*/
        rc = SQLExecDirect( hstmt, pszSqlStmt, SQL_NTS );

        /*---| free temporary memory |---*/
        if( NULL != pszSqlStmt )
        {
                free( pszSqlStmt );
                pszSqlStmt = NULL;
        }

        /*---| check results |---*/
        if( SQL_SUCCESS != rc )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:execDirect] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "execDirect: cannot execute SQL statement" );
        }
}

/*---------------------------------------------------------------------------*/
/*       Return a Driver pre-parsed SQL Statement                            */
/*---------------------------------------------------------------------------*/
Hjava_lang_String * iODBC_sql_dll_J2ODBC_nativeSql(
                             struct HiODBC_sql_dll_J2ODBC *this,
                             struct Hjava_lang_String *sqlStmt )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;
        SQLCHAR        *pszSqlStmt;
        SQLCHAR         szSqlResult[ 2048 ];
        SQLINTEGER      cbSqlResult;

        /*
        ** translate into native SQL
        */
        /*---| initialize parameters |---*/
        hstmt          = (SQLHSTMT) unhand(this)->hstmt;
        pszSqlStmt     = allocCString( sqlStmt );
        szSqlResult[0] = '\0';
        cbSqlResult    = 0;

        /*---| perform preparation and execution |---*/
        rc = SQLNativeSql( hstmt, pszSqlStmt, SQL_NTS,
                           szSqlResult, sizeof(szSqlResult),
                           &cbSqlResult );

        /*---| free temporary memory |---*/
        if( NULL != pszSqlStmt )
        {
                free( pszSqlStmt );
                pszSqlStmt = NULL;
        }

        /*---| check results |---*/
        if( SQL_SUCCESS != rc )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:nativeSql] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "nativeSql: cannot translate into native SQL" );
                return NULL;
        }
        return makeJavaString(szSqlResult, cbSqlResult);
}

/*---------------------------------------------------------------------------*/
/*       Supplies SQLExecute with Parameter Data                             */
/*---------------------------------------------------------------------------*/
/*
 * not implemented yet!
 *
 * RETCODE SQL_API SQLParamData(
 *         LPSTMT  lpstmt,
 *     PTR FAR *prbgValue)
 */

/*---------------------------------------------------------------------------*/
/*       Supplies SQLExecute with Parameter Data                             */
/*---------------------------------------------------------------------------*/
/*
 * not implemented yet!
 *
 * RETCODE SQL_API SQLPutData(
 *         LPSTMT  lpstmt,
 *         PTR     rgbValue,
 *         SDWORD  cbValue)
 */

/*---------------------------------------------------------------------------*/
/*       Cancel the current Statement (Action)                               */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_cancel( struct HiODBC_sql_dll_J2ODBC *this )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;

        /*
        ** execute
        */
        hstmt = (SQLHSTMT) unhand(this)->hstmt;

        if( SQL_SUCCESS != (rc=SQLCancel(hstmt)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:cancel] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "cancel: cannot cancel" );
        }
}

/*===| end of file |=========================================================*/
