/*
** CATALOG.C - This is the module containing the code for ODBC for
** executing Data Dictionary functions.
**
** (c) 1997 by Dirk Ohme - all rights reserved
*/

/*---| includes |------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <javaString.h>
#include <sqlcli_.h>

#include "iODBC_sql_dll_J2ODBC.h"

/*---------------------------------------------------------------------------*/
/*       Return Info about Database Tables                                   */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_tables( struct HiODBC_sql_dll_J2ODBC *this,
                                  struct Hjava_lang_String *tableQualifier,
                                  struct Hjava_lang_String *tableOwner,
                                  struct Hjava_lang_String *tableName,
                                  struct Hjava_lang_String *tableType )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;
        SQLCHAR         szTableQualifier[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableOwner[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableName[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableType[ SQL_MAX_DSN_LENGTH + 1 ];

        /*
        ** get tables info
        */
        hstmt = (SQLHSTMT) unhand(this)->hstmt;

        javaString2CString( tableQualifier, szTableQualifier,
                            sizeof(szTableQualifier) );
        javaString2CString( tableOwner, szTableOwner, sizeof(szTableOwner) );
        javaString2CString( tableName, szTableName, sizeof(szTableName) );
        javaString2CString( tableType, szTableType, sizeof(szTableType) );

        if( SQL_SUCCESS != (rc=SQLTables(hstmt,
                                         szTableQualifier, SQL_NTS,
                                         szTableOwner,     SQL_NTS,
                                         szTableName,      SQL_NTS,
                                         szTableType,      SQL_NTS)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:tables] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "tables: cannot get list with tables" );
        }
}

/*---------------------------------------------------------------------------*/
/*       Return Info about Table Columns                                     */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_columns( struct HiODBC_sql_dll_J2ODBC *this,
                                   struct Hjava_lang_String *tableQualifier,
                                   struct Hjava_lang_String *tableOwner,
                                   struct Hjava_lang_String *tableName,
                                   struct Hjava_lang_String *columnName )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;
        SQLCHAR         szTableQualifier[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableOwner[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableName[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szColumnName[ SQL_MAX_CURSOR_NAME + 1 ];

        /*
        ** get columns info
        */
        hstmt = (SQLHSTMT) unhand(this)->hstmt;

        javaString2CString( tableQualifier, szTableQualifier,
                            sizeof(szTableQualifier) );
        javaString2CString( tableOwner, szTableOwner, sizeof(szTableOwner) );
        javaString2CString( tableName, szTableName, sizeof(szTableName) );
        javaString2CString( columnName, szColumnName, sizeof(szColumnName) );

        if( SQL_SUCCESS != (rc=SQLColumns(hstmt,
                                          szTableQualifier, SQL_NTS,
                                          szTableOwner,     SQL_NTS,
                                          szTableName,      SQL_NTS,
                                          szColumnName,     SQL_NTS)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:columns] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "columns: cannot get list with columns" );
        }
}

/*---------------------------------------------------------------------------*/
/*       Return Statistics                                                   */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_statistics( struct HiODBC_sql_dll_J2ODBC *this,
                                      struct Hjava_lang_String *tableQualifier,
                                      struct Hjava_lang_String *tableOwner,
                                      struct Hjava_lang_String *tableName,
                                      long fUnique,
                                      long fAccuracy )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;
        SQLCHAR         szTableQualifier[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableOwner[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableName[ SQL_MAX_DSN_LENGTH + 1 ];

        /*
        ** get statistics
        */
        hstmt = (SQLHSTMT) unhand(this)->hstmt;

        javaString2CString( tableQualifier, szTableQualifier,
                            sizeof(szTableQualifier) );
        javaString2CString( tableOwner, szTableOwner, sizeof(szTableOwner) );
        javaString2CString( tableName, szTableName, sizeof(szTableName) );

        if( SQL_SUCCESS != (rc=SQLStatistics(hstmt,
                                             szTableQualifier, SQL_NTS,
                                             szTableOwner,     SQL_NTS,
                                             szTableName,      SQL_NTS,
                                             fUnique, fAccuracy)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:statistics] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "statistics: cannot get list with statistics" );
        }
}

/*---------------------------------------------------------------------------*/
/*       Return Privileges for Database Tables                               */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_tablePrivileges(
                             struct HiODBC_sql_dll_J2ODBC *this,
                             struct Hjava_lang_String *tableQualifier,
                             struct Hjava_lang_String *tableOwner,
                             struct Hjava_lang_String *tableName )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;
        SQLCHAR         szTableQualifier[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableOwner[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableName[ SQL_MAX_DSN_LENGTH + 1 ];

        /*
        ** get privileges
        */
        hstmt = (SQLHSTMT) unhand(this)->hstmt;

        javaString2CString( tableQualifier, szTableQualifier,
                            sizeof(szTableQualifier) );
        javaString2CString( tableOwner, szTableOwner, sizeof(szTableOwner) );
        javaString2CString( tableName, szTableName, sizeof(szTableName) );

        if( SQL_SUCCESS != (rc=SQLTablePrivileges(hstmt,
                                                  szTableQualifier, SQL_NTS,
                                                  szTableOwner,     SQL_NTS,
                                                  szTableName,      SQL_NTS)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:tablePrivileges] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "tablePrivileges: cannot get list with statistics" );
        }
}

/*---------------------------------------------------------------------------*/
/*       Return Special Columns of a Database Table (primary key, indices)   */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_specialColumns(
                             struct HiODBC_sql_dll_J2ODBC *this,
                             long fColType,
                             struct Hjava_lang_String *tableQualifier,
                             struct Hjava_lang_String *tableOwner,
                             struct Hjava_lang_String *tableName,
                             long fScope,
                             long fNullable )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;
        SQLCHAR         szTableQualifier[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableOwner[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableName[ SQL_MAX_DSN_LENGTH + 1 ];

        /*
        ** get special columns
        */
        hstmt = (SQLHSTMT) unhand(this)->hstmt;

        javaString2CString( tableQualifier, szTableQualifier,
                            sizeof(szTableQualifier) );
        javaString2CString( tableOwner, szTableOwner, sizeof(szTableOwner) );
        javaString2CString( tableName, szTableName, sizeof(szTableName) );

        if( SQL_SUCCESS != (rc=SQLSpecialColumns(hstmt,
                                                 fColType,
                                                 szTableQualifier, SQL_NTS,
                                                 szTableOwner,     SQL_NTS,
                                                 szTableName,      SQL_NTS,
                                                 fScope, fNullable)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:specialColumns] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "specialColumns: cannot get list" );
        }
}

/*---------------------------------------------------------------------------*/
/*       Return Primary Key Columns of a Database Table                      */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_primaryKeys(
                             struct HiODBC_sql_dll_J2ODBC *this,
                             struct Hjava_lang_String *tableQualifier,
                             struct Hjava_lang_String *tableOwner,
                             struct Hjava_lang_String *tableName )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;
        SQLCHAR         szTableQualifier[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableOwner[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szTableName[ SQL_MAX_DSN_LENGTH + 1 ];

        /*
        ** get primary keys
        */
        hstmt = (SQLHSTMT) unhand(this)->hstmt;

        javaString2CString( tableQualifier, szTableQualifier,
                            sizeof(szTableQualifier) );
        javaString2CString( tableOwner, szTableOwner, sizeof(szTableOwner) );
        javaString2CString( tableName, szTableName, sizeof(szTableName) );

        if( SQL_SUCCESS != (rc=SQLPrimaryKeys(hstmt,
                                              szTableQualifier, SQL_NTS,
                                              szTableOwner,     SQL_NTS,
                                              szTableName,      SQL_NTS)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:primaryKeys] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "primaryKeys: cannot get list" );
        }
}

/*---------------------------------------------------------------------------*/
/*       Return Foreign Key Columns of a Database Table                      */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_foreignKeys(
                             struct HiODBC_sql_dll_J2ODBC *this,
                             struct Hjava_lang_String *pkTableQualifier,
                             struct Hjava_lang_String *pkTableOwner,
                             struct Hjava_lang_String *pkTableName ,
                             struct Hjava_lang_String *fkTableQualifier,
                             struct Hjava_lang_String *fkTableOwner,
                             struct Hjava_lang_String *fkTableName )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;
        SQLCHAR         szFkTableQualifier[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szPkTableQualifier[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szFkTableOwner[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szPkTableOwner[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szFkTableName[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szPkTableName[ SQL_MAX_DSN_LENGTH + 1 ];

        /*
        ** get foreign keys
        */
        hstmt = (SQLHSTMT) unhand(this)->hstmt;

        javaString2CString( fkTableQualifier, szFkTableQualifier,
                            sizeof(szFkTableQualifier) );
        javaString2CString( pkTableQualifier, szPkTableQualifier,
                            sizeof(szPkTableQualifier) );
        javaString2CString( fkTableOwner, szFkTableOwner,
                            sizeof(szFkTableOwner) );
        javaString2CString( pkTableOwner, szPkTableOwner,
                            sizeof(szPkTableOwner) );
        javaString2CString( fkTableName, szFkTableName,
                            sizeof(szFkTableName) );
        javaString2CString( pkTableName, szPkTableName,
                            sizeof(szPkTableName) );

        if( SQL_SUCCESS != (rc=SQLForeignKeys(hstmt,
                                              szPkTableQualifier, SQL_NTS,
                                              szPkTableOwner,     SQL_NTS,
                                              szPkTableName,      SQL_NTS,
                                              szFkTableQualifier, SQL_NTS,
                                              szFkTableOwner,     SQL_NTS,
                                              szFkTableName,      SQL_NTS)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:foreignKeys] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "foreignKeys: cannot get list" );
        }
}

/*---------------------------------------------------------------------------*/
/*       Return List with Stored Procedures                                  */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_procedures(
                             struct HiODBC_sql_dll_J2ODBC *this,
                             struct Hjava_lang_String *procQualifier,
                             struct Hjava_lang_String *procOwner,
                             struct Hjava_lang_String *procName )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;
        SQLCHAR         szProcQualifier[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szProcOwner[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szProcName[ SQL_MAX_DSN_LENGTH + 1 ];

        /*
        ** get procedures
        */
        hstmt = (SQLHSTMT) unhand(this)->hstmt;

        javaString2CString( procQualifier, szProcQualifier,
                            sizeof(szProcQualifier) );
        javaString2CString( procOwner, szProcOwner, sizeof(szProcOwner) );
        javaString2CString( procName, szProcName, sizeof(szProcName) );

        if( SQL_SUCCESS != (rc=SQLProcedures(hstmt,
                                             szProcQualifier, SQL_NTS,
                                             szProcOwner,     SQL_NTS,
                                             szProcName,      SQL_NTS)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:procedures] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "procedures: cannot get list" );
        }
}

/*---------------------------------------------------------------------------*/
/*       Return List with In- and Output Parameters of Stored Procedures     */
/*---------------------------------------------------------------------------*/
void iODBC_sql_dll_J2ODBC_procedureColumns(
                             struct HiODBC_sql_dll_J2ODBC *this,
                             struct Hjava_lang_String *procQualifier,
                             struct Hjava_lang_String *procOwner,
                             struct Hjava_lang_String *procName,
                             struct Hjava_lang_String *columnName )
{
        RETCODE         rc;
        SQLHSTMT        hstmt;
        SQLCHAR         szProcQualifier[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szProcOwner[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szProcName[ SQL_MAX_DSN_LENGTH + 1 ];
        SQLCHAR         szColumnName[ SQL_MAX_CURSOR_NAME + 1 ];

        /*
        ** get procedure parameters
        */
        hstmt = (SQLHSTMT) unhand(this)->hstmt;

        javaString2CString( procQualifier, szProcQualifier,
                            sizeof(szProcQualifier) );
        javaString2CString( procOwner, szProcOwner, sizeof(szProcOwner) );
        javaString2CString( procName, szProcName, sizeof(szProcName) );
        javaString2CString( columnName, szColumnName, sizeof(szColumnName) );

        if( SQL_SUCCESS != (rc=SQLProcedureColumns(hstmt,
                                                   szProcQualifier, SQL_NTS,
                                                   szProcOwner,     SQL_NTS,
                                                   szProcName,      SQL_NTS,
                                                   szColumnName,    SQL_NTS)) )
        {
                /*---| throw exception |---*/
#ifdef DEBUG
                fprintf( stderr, "! [J2ODBC:%s:procedureColumns] rc = %d\n", __FILE__, rc );
#endif
                SignalError( 0, "iODBC/sql/dll/J2ODBCException",
                             "procedureColumns: cannot get list" );
        }
}

/*===| end of file |=========================================================*/
