//
// J2ODBC.java
//
// Interface class for JDBC-ODBC-Gateway via dynamic link library
//
// (c) 1997 by Dirk Ohme
//

//---| package |---------------------------------------------------------------
package iODBC.sql.dll;

//---| imports |---------------------------------------------------------------
import java.lang.*;
import java.util.*;

//---| class definition |------------------------------------------------------
public class J2ODBC {

  /*
  ** force load of dynmaic link library
  */
  static {
        System.loadLibrary( "J2ODBC" );
  }

  /*
  ** variables section
  */
  //---| commonly used |---
  private int           henv                     =   0;
  private int           hdbc                     =   0;
  private int           hstmt                    =   0;

  //---| used by colAttributes..() |---
  private String        attrDesc                 = null;
  private int           attrValue                =   0;

  //---| used by describeCol..(), describeParam..() |---
  private String        colName                  = null;
  private int           colSqlType               =   0;
  private int           colPrecision             =   0;
  private int           colScale                 =   0;
  private boolean       colNullable              = false;

  //---| used by getData..() |---
  private boolean       colIsNull                = false;

  //---| used by paramOptions(), paramOptionsResultNumber() |---
  private int           paramResultNumber        =   0;

  /*
  ** constants
  */
  //---| global constants |---
  public static final int FALSE                  =   0;
  public static final int TRUE                   =   1;

  //---| SQL data types |---
  public static final int SQL_UNKNOWN            =   0;
  public static final int SQL_CHAR               =   1;
  public static final int SQL_TINYINT            =   1;
  public static final int SQL_NUMERIC            =   2;
  public static final int SQL_DECIMAL            =   3;
  public static final int SQL_INTEGER            =   4;
  public static final int SQL_C_LONG             =   4;
  public static final int SQL_SMALLINT           =   5;
  public static final int SQL_C_SHORT            =   5;
  public static final int SQL_FLOAT              =   6;
  public static final int SQL_REAL               =   7;
  public static final int SQL_DOUBLE             =   8;
  public static final int SQL_DATETIME           =   9;
  public static final int SQL_INTERVAL           =  10;
  public static final int SQL_VARCHAR            =  12;
  public static final int SQL_BIT                =  14;
  public static final int SQL_BIT_VARYING        =  15;
  public static final int SQL_DBCHAR             =  16;
  public static final int SQL_DATE               =  17;
  public static final int SQL_TIME               =  18;
  public static final int SQL_TIMESTAMP          =  19;
  public static final int SQL_BINARY             =  20;
  public static final int SQL_BLOB               =  21;
  public static final int SQL_BLOB_LOCATOR       =  22;
  public static final int SQL_CLOB               =  23;
  public static final int SQL_CLOB_LOCATOR       =  24;
  public static final int SQL_DBCLOB             =  25;
  public static final int SQL_DBCLOB_LOCATOR     =  26;
  public static final int SQL_GRAPHIC            =  27;
  public static final int SQL_LONGVARCHAR        =  28;
  public static final int SQL_LONGVARBINARY      =  29;
  public static final int SQL_LONGVARGRAPHIC     =  30;
  public static final int SQL_VARBINARY          =  31;
  public static final int SQL_VARGRAPHIC         =  32;

  public static final int SQL_ALL_TYPES          =   0;
  public static final int SQL_DEFAULT            =  99;
  public static final int SQL_TYPE_MIN           = SQL_BIT;
  public static final int SQL_TYPE_MAX           = SQL_VARCHAR;
  public static final int SQL_TYPE_NULL          =   0;

  //---| ... for method colAttributes() |---
  public static final int COLUMN_COUNT           =   0;
  public static final int COLUMN_NAME            =   1;
  public static final int COLUMN_TYPE            =   2;
  public static final int COLUMN_LENGTH          =   3;
  public static final int COLUMN_PRECISION       =   4;
  public static final int COLUMN_SCALE           =   5;
  public static final int COLUMN_DISPLAY_SIZE    =   6;
  public static final int COLUMN_NULLABLE        =   7;
  public static final int COLUMN_UNSIGNED        =   8;
  public static final int COLUMN_MONEY           =   9;
  public static final int COLUMN_UPDATABLE       =  10;
  public static final int   ATTR_READONLY        =   0;
  public static final int   ATTR_WRITE           =   1;
  public static final int   ATTR_READWRITE_UNKNOWN = 2;
  public static final int COLUMN_AUTO_INCREMENT  =  11;
  public static final int COLUMN_CASE_SENSITIVE  =  12;
  public static final int COLUMN_SEARCHABLE      =  13;
  public static final int   UNSEARCHABLE         =   0;
  public static final int   LIKE_ONLY            =   1;
  public static final int   ALL_EXCEPT_LIKE      =   2;
  public static final int   SEARCHABLE           =   3;
  public static final int COLUMN_TYPE_NAME       =  14;
  public static final int COLUMN_TABLE_NAME      =  15;
  public static final int COLUMN_OWNER_NAME      =  16;
  public static final int COLUMN_QUALIFIER_NAME  =  17;
  public static final int COLUMN_LABEL           =  18;
  public static final int COLUMN_SCHEMA_NAME     =  19;
  public static final int COLUMN_CATALOG_NAME    =  20;
  public static final int COLUMN_DRIVER_START    =1000;
  public static final int COLUMN_DISTINCT_TYPE   =1250;
  public static final int COLATT_OPT_MAX         = COLUMN_LABEL;
  public static final int COLATT_OPT_MIN         = COLUMN_COUNT;

  //---| ... for method driverConnect() |---
  public static final int DRIVER_NOPROMPT        =   0;
  public static final int DRIVER_COMPLETE        =   1;
  public static final int DRIVER_PROMPT          =   2;
  public static final int DRIVER_COMPLETE_REQUIRED = 3;

  //---| ... for method extendedFetch() |---
  public static final int FETCH_NEXT             =   1;
  public static final int FETCH_FIRST            =   2;
  public static final int FETCH_LAST             =   3;
  public static final int FETCH_PRIOR            =   4;
  public static final int FETCH_ABSOLUTE         =   5;
  public static final int FETCH_RELATIVE         =   6;
  public static final int FETCH_BOOKMARK         =   8;

  //---| ... for method freeStmt() |---
  public static final int CLOSE                  =   0;
  public static final int DROP                   =   1;
  public static final int UNBIND                 =   2;
  public static final int RESET_PARAMS           =   3;

  //---| ... for methods getConnectOptionNum(), getConnectOptionStr(), |---
  //---| setConnectOptionNum(), setConnectOptionStr() |---
  public static final int ACCESS_MODE            = 101;
  public static final int   MODE_READ_WRITE      =   0;
  public static final int   MODE_READ_ONLY       =   1;
  public static final int   MODE_DEFAULT         = MODE_READ_WRITE;
  public static final int AUTOCOMMIT             = 102;
  public static final int   AUTOCOMMIT_OFF       =   0;
  public static final int   AUTOCOMMIT_ON        =   1;
  public static final int   AUTOCOMMIT_DEFAULT   = AUTOCOMMIT_ON;
  public static final int LOGIN_TIMEOUT          = 103;
  public static final int   LOGIN_TIMEOUT_DEFAULT = 15;
  public static final int OPT_TRACE              = 104;
  public static final int   OPT_TRACE_OFF        =   0;
  public static final int   OPT_TRACE_ON         =   1;
  public static final int   OPT_TRACE_DEFAULT    = OPT_TRACE_OFF;
  public static final int OPT_TRACEFILE          = 105;
  public static final String OPT_TRACE_FILE_DEFAULT = "odbc.log";
  public static final int TRANSLATE_DLL          = 106;
  public static final int TRANSLATE_OPTION       = 107;
  public static final int TXN_ISOLATION          = 108;
  public static final int CURRENT_QUALIFIER      = 109;
  public static final int ODBC_CURSORS           = 110;
  public static final int   CUR_USE_IF_NEEDED    =   0;
  public static final int   CUR_USE_ODBC         =   1;
  public static final int   CUR_USE_DRIVER       =   2;
  public static final int   CUR_DEFAULT          = CUR_USE_DRIVER;
  public static final int QUIET_MODE             = 111;
  public static final int PACKET_SIZE            = 112;

  public static final int CONN_OPT_MAX           = PACKET_SIZE;
  public static final int CONN_OPT_MIN           = ACCESS_MODE;
  public static final int CONNECT_OPT_DRVR_START = 1000;

  //---| ... for methods getInfoNum(), getInfoStr() |---
  public static final int INFO_FIRST             =   0;
  public static final int DRIVER_HDBC            =   3;
  public static final int DRIVER_HENV            =   4;
  public static final int DRIVER_HSTMT           =   5;
  public static final int DRIVER_NAME            =   6;
  public static final int ODBC_VER               =  10;
  public static final int CURSOR_COMMIT_BEHAVIOR =  23;
  public static final int CURSOR_ROLLBACK_BEHAVIOR = 24;
  public static final int   CB_DELETE            =   0;
  public static final int   CB_CLOSE             =   1;
  public static final int   CB_PRESERVE          =   2;
  public static final int DEFAULT_TXN_ISOLATION  =  26;
  public static final int TXN_ISOLATION_OPTION   =  72;
  public static final int   TXN_READ_UNCOMMITTED =   1;
  public static final int   TXN_READ_COMMITTED   =   2;
  public static final int   TXN_REPEATABLE_READ  =   4;
  public static final int   TXN_SERIALIZABLE     =   8;
  public static final int   TXN_VERSIONING       =  16;
  public static final int NON_NULLABLE_COLUMNS   =  75;
  public static final int DRIVER_HLIB            =  76;
  public static final int DRIVER_ODBC_VER        =  77;
  public static final int QUALIFIER_LOCATION     = 114;

  public static final int INFO_LAST              = QUALIFIER_LOCATION;
  public static final int INFO_DRIVER_START      = 1000;

  //---| ... for methods getStmtOptionNum(), getStmtOptionStr(), |---
  //---| setStmtOptionNum(), setStmtOptionStr() |---
  public static final int QUERY_TIMEOUT          =   0;
  public static final int   QUERY_TIMEOUT_DEFAULT =  0;
  public static final int MAX_ROWS               =   1;
  public static final int   MAX_ROWS_DEFAULT     =   0;
  public static final int NOSCAN                 =   2;
  public static final int MAX_LENGTH             =   3;
  public static final int   MAX_LENGTH_DEFAULT   =   0;
  public static final int ASYNC_ENABLE           =   4;
  public static final int BIND_TYPE              =   5;
  public static final int CURSOR_TYPE            =   6;
  public static final int CONCURRENCY            =   7;
  public static final int   CONCUR_READ_ONLY     =   1;
  public static final int   CONCUR_LOCK          =   2;
  public static final int   CONCUR_ROWVER        =   3;
  public static final int   CONCUR_VALUES        =   4;
  public static final int KEYSET_SIZE            =   8;
  public static final int ROWSET_SIZE            =   9;
  public static final int SIMULATE_CURSOR        =  10;
  public static final int RETRIEVE_DATA          =  11;
  public static final int USE_BOOKMARKS          =  12;
  public static final int GET_BOOKMARK           =  13;
  public static final int ROW_NUMBER             =  14;

  public static final int STMT_OPT_MAX           = ROW_NUMBER;
  public static final int STMT_OPT_MIN           = QUERY_TIMEOUT;

  //---| ... for method specialColumns() |---
  public static final int BEST_ROWID             =   1;
  public static final int ROWVER                 =   2;
  public static final int SCOPE_CURROW           =   0;
  public static final int SCOPE_TRANSACTION      =   1;
  public static final int SCOPE_SESSION          =   2;

  //---| ... for method transact() |---
  public static final int COMMIT                 =   0;
  public static final int ROLLBACK               =   1;

  /*
  ** constructor(s)
  */
  //---| ... for a new connection |---
  public J2ODBC() {
        // System.out.println( "*** Dynamic Link Library loaded ***" );
  }

  //---| ... for the current connection, but with new statement handle |---
  public J2ODBC( J2ODBC currConnection ) {
        henv  = currConnection.henv;
        hdbc  = currConnection.hdbc;
        // System.out.println( "*** Current Connection cloned ***" );
  }

  /*
  ** public functions
  */
  //---| ... common |---
  public Object         clone() {
        J2ODBC newConnection = new J2ODBC( this );
        newConnection.hstmt = this.hstmt;
        return newConnection;
  }

  //---| ... implemented in catalog.c |---
  public native void    tables( String tableQualifier,
                                String tableOwner,
                                String tableName,
                                String tableType ) throws Exception;
  public native void    columns( String tableQualifier,
                                 String tableOwner,
                                 String tableName,
                                 String columnName ) throws Exception;
  public native void    statistics( String tableQualifier,
                                    String tableOwner,
                                    String tableName,
                                    boolean fUnique,
                                    boolean fAccuracy ) throws Exception;
  public native void    tablePrivileges( String tableQualifier,
                                         String tableOwner,
                                         String tableName ) throws Exception;
  public native void    specialColumns( int fColType,
                                        String tableQualifier,
                                        String tableOwner,
                                        String tableName,
                                        int fScope,
                                        boolean fNullable ) throws Exception;
  public native void    primaryKeys( String tableQualifier,
                                     String tableOwner,
                                     String tableName ) throws Exception;
  public native void    foreignKeys( String pkTableQualifier,
                                     String pkTableOwner,
                                     String pkTableName,
                                     String fkTableQualifier,
                                     String fkTableOwner,
                                     String fkTableName ) throws Exception;
  public native void    procedures( String procQualifier,
                                    String procOwner,
                                    String procName ) throws Exception;
  public native void    procedureColumns( String procQualifier,
                                          String procOwner,
                                          String procName,
                                          String columnName ) throws Exception;

  //---| ... implemented in connect.c |---
  public native void    allocEnv() throws Exception;
  public native void    allocConnect() throws Exception;
  public native void    connect( String dsn,
                                 String uid,
                                 String pwd ) throws Exception;
  public native String  driverConnect( String connStr,
                                        int fDrvCmpl ) throws Exception;
  public native String  browseConnect( String connStr ) throws Exception;
  public native void    disconnect() throws Exception;
  public native void    freeConnect() throws Exception;
  public native void    freeEnv() throws Exception;

  //---| ... implemented in execute.c |---
  public native void    execute() throws Exception;
  public native void    execDirect( String sqlStmt ) throws Exception;
  public native String  nativeSql( String sqlStmt ) throws Exception;
  // public native void    paramData();
  // public native void    putData();
  public native void    cancel() throws Exception;

  //---| ... implemented in info.c |---
  public native int     getInfoNum( int fInfoType ) throws Exception;
  public native String  getInfoStr( int fInfoType ) throws Exception;
  public native void    getTypeInfo( int fSqlType ) throws Exception;

  //---| ... implemented in options.c |---
  public native void    setConnectOptionNum( int fOption,
                                             int paramValue ) throws Exception;
  public native void    setConnectOptionStr( int fOption,
                                             String paramStr ) throws Exception;
  public native void    setStmtOptionNum( int fOption,
                                          int paramValue ) throws Exception;
  public native void    setStmtOptionStr( int fOption,
                                          String paramStr ) throws Exception;
  public native int     getConnectOptionNum( int fOption ) throws Exception;
  public native String  getConnectOptionStr( int fOption ) throws Exception;
  public native int     getStmtOptionNum( int fOption ) throws Exception;
  public native String  getStmtOptionStr( int fOption ) throws Exception;

  //---| ... implemented in prepare.c |---
  public native void    allocStmt() throws Exception;
  public native void    freeStmt( int fOption ) throws Exception;
  public native void    prepare( String sqlStmt ) throws Exception;
  // public native void    setParam();
  public native void    describeParam( int paramIndex ) throws Exception;
  public int            describeParamType() { return colSqlType; }
  public int            describeParamPrecision() { return colPrecision; }
  public int            describeParamScale() { return colScale; }
  public boolean        describeParamNullable() { return colNullable; }
  public native void    paramOptions( int numOfParams ) throws Exception;
  public int            paramOptionsResultNumber() { return paramResultNumber; }
  public native int     numParams() throws Exception;
  public native void    setScrollOptions( int fConcurrency,
                                          int crowKeyset,
                                          int crowRowset ) throws Exception;
  public native void    setCursorName( String cursorName ) throws Exception;
  public native String  getCursorName() throws Exception;

  //---| ... implemented in results.c |---
  public native int     numResultCols() throws Exception;
  public native void    describeCol( int colIndex ) throws Exception;
  public String         describeColName() { return colName; }
  public int            describeColType() { return colSqlType; }
  public int            describeColPrecision() { return colPrecision; }
  public int            describeColScale() { return colScale; }
  public boolean        describeColNullable() { return colNullable; }
  public native void    colAttributes( int colIndex,
                                       int fDescType ) throws Exception;
  public String         colAttributesString() { return attrDesc; }
  public int            colAttributesValue() { return attrValue; }
  // public native void    bindCol();
  public native boolean fetch() throws Exception;
  public boolean        getDataCheckForNull() { return colIsNull; }
  public native boolean getDataBoolean( int colIndex ) throws Exception;
  // public native Date  getDataDate( int colIndex ) throws Exception;
  public native double  getDataDouble( int colIndex ) throws Exception;
  public native float   getDataFloat( int colIndex ) throws Exception;
  public native int     getDataInteger( int colIndex ) throws Exception;
  public native String  getDataString( int colIndex ) throws Exception;
  public native boolean moreResults() throws Exception;
  public native int     rowCount() throws Exception;
  public native void    setPos( int rowIndex,
                                boolean fRefresh,
                                boolean fLock ) throws Exception;
  // public native boolean extendedFetch();
  public native String  error() throws Exception;

  //---| ... implemented in transact.c |---
  public native void    transact( int fType ) throws Exception;

} /*---| class J2ODBC |---*/

//===| end of file |===========================================================
