//
// Example #1
//
// This example shows the use of the JDBC-ODBC bridge and may be used as a
// skeleton for further experiments.
//
// (c) 1997 by Dirk Ohme, all rights reserved
//

//---| imports |--------------------------------------------------------------
import java.net.URL;
import java.sql.*;

//---| class Example1 |-------------------------------------------------------
public class Example1 {
        //
        // definitions
        //
        //---| name of the database user |---
        private static final String dbUser = "unknown";
        //---| his password |---
        private static final String dbPwd = "";
        //---| which database source name or database server? |---
        private static final String dbSrc = "test";

        //
        // main function
        //
        public static void main( String argv[] ) {
                try {
                        // enable debugging
                        // DriverManager.setLogStream( System.out );

                        // capture JDBC-ODBC bridge
                        String jdbcDriver = "iODBC.sql.JdbcOdbcDriver";
                        Class.forName(jdbcDriver).newInstance();

                        // Make sure there is a JDBC-ODBC driver loaded.
                        System.out.println(
                                "trying to open JDBC interface ..."
                        );

                        // make connection to
                        Connection con = DriverManager.getConnection(
                                "jdbc:odbc:"+dbSrc, dbUser, dbPwd
                        );
                        System.out.println( "connection established" );

                        // starting here, SQL statements may be executed
                        // ...

                        // close connection
                        con.close();
                        System.out.println( "connection closed" );

                } catch( Exception e ) {
                        System.out.println(e.getMessage());
                        e.printStackTrace();
                }
        }
} /* class Example1() */

//===| end of file |===========================================================
