/* -*- mode: c++; c-basic-offset: 4 -*- */

#ifndef __TUPLE_H__
#define __TUPLE_H__

#include "socket/compat.h"

/*************************************************/
/* STRUCT TupleField                             */
/*************************************************/
/* An array of TupleFields describes one entity  */
/* returned by the server.                       */
/* This struct is supposed to be used only in    */
/* connection with struct TupleNode              */
/*************************************************/

typedef struct _TupleField {
    Int4 len;     /* length of the current Tuple */
    void *value;  /* an array representing the value */
    /* is a null-terminated string for non-binary queries */
} TupleField;

/**************************************************/
/* STRUCT TupleNode                               */
/**************************************************/
/*A list of TupleNodes represents the result of a */
/*query.                                          */
/*  prev, next -> Pointers to the respective      */ 
/*        entities (preceeding, succeeding ones)  */ 
/*  tuple -> A dynamically allocated array of     */
/*        TupleFields representing the current    */
/*        entity that is stored in that node      */
/**************************************************/

typedef struct _TupleNode {
    struct _TupleNode *prev, *next;
    TupleField tuple[1];
    /* C-trick for dynamically allocating a variable length buffer */
} TupleNode;

void set_tuplefield_null(TupleField *tuple_field);
void set_tuplefield_string(TupleField *tuple_field, char *string);
void set_tuplefield_int2(TupleField *tuple_field, Int2 value);
void set_tuplefield_int4(TupleField *tuple_field, Int4 value);
void free_tuplefield(TupleField *tuple_field);

#endif
