/* -*- mode: c++; c-basic-offset: 4 -*- */

#include "tuple.h"
#include "socket/compat.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

void set_tuplefield_null(TupleField *tuple_field)
{
    tuple_field->len = 0;
    tuple_field->value = strdup("");

    /* CC: All the routines I wrote are not expecting null pointers here.
           (Wanted to avoid another special case to handle)
           So assign a minimal string even in that case
    */       
}

void set_tuplefield_string(TupleField *tuple_field, char *string)
{
    tuple_field->len = strlen(string);
    tuple_field->value = malloc(strlen(string)+1);
    strcpy(tuple_field->value, string);
}


/* CC: All fields are internally represented as strings!
       So do an appropriate conversion, but do net store the binary representation!
       Have a look at "copy_and_convert" so see what is expected. (I experienced some nice GPFs ;-)


void set_tuplefield_int2(TupleField *tuple_field, Int2 value)
{
    tuple_field->len = 2;
    tuple_field->value = malloc(2);
    *((Int2 *)tuple_field->value) = value;
}

void set_tuplefield_int4(TupleField *tuple_field, Int4 value)
{
    tuple_field->len = 4;
    tuple_field->value = malloc(4);
    *((Int4 *)tuple_field->value) = value;
}
*/



void set_tuplefield_int2(TupleField *tuple_field, Int2 value)
{
 char buffer[10];

 sprintf(buffer,"%d", value);
 /* CC: should hopefully work in Win32 too... */

 tuple_field->len = strlen(buffer)+1;
 /* +1 ... is this correct (better be on the save side-...) */
 tuple_field->value = strdup(buffer);
}

void set_tuplefield_int4(TupleField *tuple_field, Int4 value)
{
 char buffer[15];

 sprintf(buffer,"%ld", value);
 /* CC: long should mean 4 bytes for Win16 and Win32 */    

 tuple_field->len = strlen(buffer)+1;
 /* +1 ... is this correct (better be on the save side-...) */
 tuple_field->value = strdup(buffer);
}



void free_tuplefield(TupleField *tuple_field)
{
    if(tuple_field->value) {
        free(tuple_field->value);
    }
    tuple_field->len = 0;
}
