/********************************************************************
    POSTODBCL.DLL - A library to talk to Postgres95 by using the
                    WINDOWS ODBC Interface

    Copyright (C) 1996; Christian Czezatke

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details. 

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    How to contact the author:
    
    email to: e9025461@student.tuwien.ac.at
********************************************************************/ 
/*
** TRANSACT.C - This is the PostODBC driver code for
** processing transactions.
*/



//      -       -       -       -       -       -       -       -       -

//      SQLC transaction control functions.

//      -       -       -       -       -       -       -       -       -

#include "globals.h"

/* CC: works */
RETCODE SQL_API SQLTransact(
        HENV    henv,
        HDBC    hdbc,
        UWORD   fType)
{
 ConnectionClass *conn = HI_connfromhdbc(the_handles, hdbc);
 ResultC *res;
 char ok, *stmt_string;
 int lf;


 if ((NULL == conn) && (SQL_NULL_HDBC != hdbc))
    return SQL_INVALID_HANDLE;

 if (SQL_NULL_HDBC == hdbc) {
     // well, in that case we have to end every transaction currently going on
     // we do that by recursive calls to SQLTransact
     for (lf=0; lf <MAX_CONNECTIONS; lf++)
       conn= the_handles->conns[lf];
       if (NULL != conn)
          if (SQL_SUCCESS != SQLTransact(henv, conn->hdbc, fType))
             return SQL_ERROR;
      return SQL_SUCCESS;       
 }     

 // ok, what stays left is that we have to end a transaction on a single hdbc:
 if (SQL_COMMIT == fType) {
     stmt_string = "end transaction";
 } else if (SQL_ROLLBACK == fType) {
     stmt_string = "abort transaction";
 } else {
     conn->errornumber = CONN_INVALID_ARGUMENT_NO;
#ifdef _ENGLISH_
     conn->errormsg ="SQLTransact can only be called with SQL_COMMIT or SQL_ROLLBACK as parameter";
#else     
     conn->errormsg ="SQLTransact kann nur mit SQL_COMMIT oder SQL_ROLLBACK aufgerufen werden";
#endif     
     return SQL_ERROR;
 }    

 /* now end the transaction that is currently going on */
 if ( ! ((conn->transact_status) & CONN_IN_AUTOCOMMIT)  && /* we are in manual commit mode */
        ((conn->transact_status) & CONN_IN_TRANSACTION) /* and there is a transaction going on */
    )
    {             
      /* End the transaction */

      res = ConnectionC_send_query(conn->connection, stmt_string);
      conn->transact_status &= ~CONN_IN_TRANSACTION;
      if (NULL == res)
         return SQL_ERROR;
      ok = ResultC_command_successful(res);   
      ResultC_Destructor(res);
      if (!ok)
        return SQL_ERROR;
    }    
    return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -
