/********************************************************************
    POSTODBCL.DLL - A library to talk to Postgres95 by using the
                    WINDOWS ODBC Interface

    Copyright (C) 1996; Christian Czezatke

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details. 

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    How to contact the author:
    
    email to: e9025461@student.tuwien.ac.at
********************************************************************/   

#ifndef __WRAPPER_H__
#define __WRAPPER_H__

#include "compat.h"
#include "../tuple.h"

typedef void ConnectionC;
typedef void ResultC;
typedef long ErrClassC;
typedef UInt4 Oid;

ConnectionC *ConnectionC_Constructor();

char ConnectionC_open_db(ConnectionC *connobj, char *DSN, char *machine, 
                         UInt2 port, char *database, char *user);

char *ConnectionC_get_dbname(ConnectionC *connobj);

char *ConnectionC_get_DSN(ConnectionC *connobj);

ResultC *ConnectionC_send_query(ConnectionC *to_whom, char *query);

void ConnectionC_Destructor(ConnectionC *connobj);

char *ConnectionC_get_errmsg(ConnectionC *conn);

void ConnectionC_clear_errmsg(ConnectionC *conn);

ResultC *ResultC_Constructor(void);

void ResultC_set_num_fields(ResultC *resobj, int new_num_fields);

void ResultC_set_field_info(ResultC *resobj, int field_num, char *name, 
                            Oid adtid, Int2 adtsize);

void ResultC_add_tuple(ResultC *resobj, TupleNode *new_tuple);

void ResultC_Destructor(ResultC *resobj);

Int2 ResultC_NumResultCols(ResultC *resobj);

char *ResultC_get_fieldname(ResultC *resobj, Int2 colnum);

Int2 ResultC_get_fieldsize(ResultC *resobj, Int2 colnum);

Oid ResultC_get_field_type(ResultC *resobj, Int2 colnum);

Int2 ResultC_attribs_per_tuple(ResultC *resobj);

void *ResultC_get_value(ResultC *resobj, Int4 tupleno, Int2 fieldno);

char *ResultC_get_message(ResultC *resobj);

char ResultC_command_successful(ResultC *resobj);

Int4 ResultC_get_num_tuples(ResultC *resobj);


char *ErrClassC_get_errmsg(ErrClassC *self);

void ErrClassC_clear_errmsg(ErrClassC *self);

#endif
