/* -*- mode: c++; c-basic-offset: 4 -*- */
/********************************************************************
    POSTODBCL.DLL - A library to talk to Postgres95 by using the
                    WINDOWS ODBC Interface

    Copyright (C) 1996; Christian Czezatke

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details. 

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    How to contact the author:
    
    email to: e9025461@student.tuwien.ac.at
********************************************************************/   


///// Wrapper.h - Provide access to the C++ classes
///// in the socket/*.cpp files from plain C code

/// #include <dos.h>
#include "connect.h"

typedef int ConnectionC;
typedef char ResultC;
typedef long ErrClassC;


extern "C" { 

ConnectionC *ConnectionC_Constructor()
{
 ConnectionC *rv = (ConnectionC *) new Connection();
 return rv;
}

char ConnectionC_open_db(ConnectionC *connobj, char *DSN, 
			 char *machine, UInt2 port, char *database, char *user)
{
     return ((Connection *)connobj)->open_db(DSN, machine, port, database, user);
}

char *ConnectionC_get_dbname(ConnectionC *connobj)
{
    return ((Connection *)connobj)->get_dbname();
}

char *ConnectionC_get_DSN(ConnectionC *connobj)
{
    return ((Connection *)connobj)->get_DSN();
}

ResultC *ConnectionC_send_query(ConnectionC *to_whom, char *query)
{
    return (ResultC *) ((Connection *)to_whom)->send_query(query); 
}    

void ConnectionC_Destructor(ConnectionC *connobj)
{
        delete (Connection *)connobj;
}

char *ConnectionC_get_errmsg(ConnectionC *conn)
{
  return ((Connection *)conn)->get_errmsg();
}

void ConnectionC_clear_errmsg(ConnectionC *conn)
{
  ((Connection *)conn)->clear_error();
}

ResultC *ResultC_Constructor(void)
{
    ResultC *res = (ResultC *) new QResult();
    return res;
}

void ResultC_set_num_fields(ResultC *resobj, int new_num_fields)
{
    ((QResult *)resobj)->set_num_fields(new_num_fields);
}

void ResultC_set_field_info(ResultC *resobj, int field_num, char *name,
			    Oid adtid, Int2 adtsize)
{
    ((QResult *)resobj)->set_field_info(field_num, name, adtid, adtsize);
}

void ResultC_add_tuple(ResultC *resobj, TupleNode *new_tuple)
{
    ((QResult *)resobj)->add_tuple(new_tuple);
}

Int2 ResultC_NumResultCols(ResultC *resobj)
{
    return (Int2)((QResult *)resobj)->attribs_per_tuple();
}

void ResultC_Destructor(ResultC *res)
{
    delete (QResult *)res;
}

char *ResultC_get_fieldname(ResultC *resobj, Int2 colnum)
{
    return ((QResult *)resobj)->get_fieldname(colnum);
}

Int2 ResultC_get_fieldsize(ResultC *resobj, Int2 colnum)
{
    return ((QResult *)resobj)->get_fieldsize(colnum);
}

Oid ResultC_get_field_type(ResultC *resobj, Int2 colnum)
{
    return ((QResult *)resobj)->get_field_type(colnum);
}

Int2 ResultC_attribs_per_tuple(ResultC *resobj)
{
    return ((QResult *)resobj)->attribs_per_tuple();
}

void *ResultC_get_value(ResultC *resobj, Int4 tupleno, Int2 fieldno)
{
    return ((QResult *)resobj)->get_value(tupleno, fieldno);
}

char *ResultC_get_message(ResultC *resobj)
{
    return ((QResult *)resobj)->get_message();
}
    

Int4 ResultC_get_num_tuples(ResultC *resobj)
{
    return ((QResult *)resobj)->get_num_tuples();
}

char ResultC_command_successful(ResultC *resobj)
{
    QueryResultCode rescode;

    rescode = ((QResult *)resobj)->get_status();

    return
    !( (PGRES_BAD_RESPONSE == rescode)   ||
       (PGRES_NONFATAL_ERROR == rescode) ||
       (PGRES_FATAL_ERROR == rescode)    ); 
}

char *ErrClassC_get_errmsg(ErrClassC *self)
{
    return ((PgErrorClass *)self)->get_errmsg();
}
    

void ErrClassC_clear_errmsg(ErrClassC *self)
{
    ((PgErrorClass *)self)->clear_error();
}


}

