/********************************************************************
    POSTODBCL.DLL - A library to talk to Postgres95 by using the
                    WINDOWS ODBC Interface

    Copyright (C) 1996; Christian Czezatke

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details. 

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    How to contact the author:
    
    email to: e9025461@student.tuwien.ac.at
********************************************************************/   



#ifndef __SOCKIO_H__
#define __SOCKIO_H__

#include <winsock.h>
#include "compat.h"
#include "errclass.h"

#define SOCKET_ALREADY_CONNECTED 1
#define SOCKET_HOST_NOT_FOUND 2
#define SOCKET_COULD_NOT_CREATE_SOCKET 3
#define SOCKET_COULD_NOT_CONNECT 4
#define SOCKET_READ_ERROR 5
#define SOCKET_WRITE_ERROR 6
#define SOCKET_NULLPOINTER_PARAMETER 7
#define SOCKET_PUT_INT_WRONG_LENGTH 8
#define SOCKET_GET_INT_WRONG_LENGTH 9

class StreamSocket : public PgErrorClass
{
 public:
   StreamSocket(UInt2 bufsize = 8193);
   char connect_to(UInt2 port, char *hostname);
   virtual ~StreamSocket();

   char get_char();
   void get_n_char(char *buffer, Int4 len);
   void get_string(char *buffer, Int4 bufsize);
   // Get a string, but max strlen(buffer)+1 == bufsize
   // so this will read at most bufsize-1 bytes
   // from the stream socket
   Int4 get_int(Int2 len);

   void put_char(char c);
   void put_n_char(char *buffer, Int4 len);
   void put_string(char *string);
   void put_int(Int4 value, Int2 len);
   // Valid lengths are 1 to 4 the bytes
   // are written in the order lsB -> msB

   void flush_output();

 private:
   unsigned char StreamSocket::get_next_byte();
   void put_next_byte(unsigned char next_byte);
 
   SOCKET sock;
   
   UInt2 buffersize;
   UInt2 buffer_filled_in, buffer_filled_out;
   UInt2 buffer_read_in;
   unsigned char *buffer_in, *buffer_out;
};



#endif
