/********************************************************************
    POSTODBCL.DLL - A library to talk to Postgres95 by using the
                    WINDOWS ODBC Interface

    Copyright (C) 1996; Christian Czezatke

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details. 

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    How to contact the author:
    
    email to: e9025461@student.tuwien.ac.at
********************************************************************/   


#ifndef __ERRORCODE_H__
#define __ERRORCODE_H__

#include <stdlib.h>
#include "compat.h"

#if _DEBUG && WIN32
#define debug_decls HANDLE hStdout; DWORD bytes_written; hStdout = GetStdHandle(STD_OUTPUT_HANDLE)
#define debug_out(x) WriteFile(hStdout, x, strlen(x), &bytes_written, NULL)
#else
#define debug_decls
#define debug_out(x)
#endif

#include <windows.h>
#include <stdio.h>

class PgErrorClass
{
protected:
  Int2 errnumber;
  char *errorMsg;

public:
  PgErrorClass();

  Int2 get_errcode()
  { return errnumber; }

  char *get_errmsg()
  { 
   return errorMsg; 
  }

  void clear_error()
  { errnumber = 0; errorMsg = NULL; }
};


#endif
