/*
** POSTODBC.H - This is the ODBC sample driver include file.
**
**      This code is furnished on an as-is basis as part of the ODBC SDK and is
**      intended for example purposes only.
**
*/
#ifndef _POSTODBC_H_
#define _POSTODBC_H_
//      -       -       -       -       -       -       -       -       -
#ifdef OS2
#  define FAR
#else
#  undef WINVER
#  define WINVER 0x0300  // prevent Windows 3.1 feature usage
#  include  <windows.h>  // Windows include file
#  include  <windowsx.h> // message crackers
#endif

//      -       -       -       -       -       -       -       -       -

/* #include "w16macro.h"*/
#ifdef iODBC
#  include "isql.h"
#  include "isqlext.h"
#else
#  include "sql.h"
#  include "sqlext.h"
#endif

#include "custom.h"

//      Definitions to be used in function prototypes.
//      The SQL_API is to be used only for those functions exported for driver
//              manager use.
//      The EXPFUNC is to be used only for those functions exported but used
//              internally, ie, dialog procs.
//      The INTFUNC is to be used for all other functions.
#ifdef _WIN32
#define INTFUNC  __stdcall
#define EXPFUNC  __stdcall
#else
#define INTFUNC PASCAL
#define EXPFUNC __export CALLBACK
#endif

//      Database connection information.  This is allocated by "SQLAllocConnect".

typedef struct  tagDBC {
    short   DummyEntry;
}       DBC,
        FAR * LPDBC;


//      -       -       -       -       -       -       -       -       -
//  Statment information.  This is allocated by "SQLAllocStmt".

typedef struct  tagSTMT {
    short   DummyEntry;
}       STMT,
        FAR *LPSTMT;

//      Environment information.

typedef struct  tagENV {
    short   DummyEntry;
}       ENV,
        FAR * LPENV;

extern HINSTANCE NEAR s_hModule;


/* ODBC.INI keywords */
/* CC: Changed this to "#define" because
        1) Watcom otherwise complained about "expression must be constant" in setup.c
        2) Watcom issued warnings in all other files including "postodbc.h" that did not
           use the defines about "XXX has been defined, but not referenced"
*/

#ifndef iODBC
#  define ODBC_INI   "ODBC.INI"         /* ODBC initialization file */
#endif
#define INI_DSN      "Postgres95"       /* Name of Datasource in ini file */
#define INI_KDESC    "Description"      /* Data source description */
#define INI_SERVER   "Servername"       /* Name of Server running the Postgres service */
#define INI_PORT     "Port"             /* Port on which the Postmaster is listening */
#define INI_DATABASE "Database"         /* Database Name */
#define INI_USER     "Username"         /* Default User Name */


#endif
