/* -*- mode: c++; c-basic-offset: 4 -*- */
/********************************************************************
    POSTODBCL.DLL - A library to talk to Postgres95 by using the
                    WINDOWS ODBC Interface

    Copyright (C) 1996; Dan McGuirk

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details. 

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    How to contact the author:
    
    email to: mcguirk@indirect.com              (Dan McGuirk)
    
********************************************************************/  


#ifndef __PGTYPES_H__
#define __PGTYPES_H__

#include "socket/compat.h"

/* the type numbers are defined by the OID's of the types' rows */
/* in table pg_type */

#define PG_TYPE_BOOL         16
#define PG_TYPE_BYTEA        17
#define PG_TYPE_CHAR         18
#define PG_TYPE_NAME         19
#define PG_TYPE_CHAR16       20
#define PG_TYPE_INT2         21
#define PG_TYPE_INT28        22
#define PG_TYPE_INT4         23
#define PG_TYPE_REGPROC      24
#define PG_TYPE_TEXT         25
#define PG_TYPE_OID          26
#define PG_TYPE_TID          27
#define PG_TYPE_XID          28
#define PG_TYPE_CID          29
#define PG_TYPE_OID8         30
#define PG_TYPE_SET          32
#define PG_TYPE_CHAR2       409
#define PG_TYPE_CHAR4       410
#define PG_TYPE_CHAR8       411
#define PG_TYPE_POINT       600
#define PG_TYPE_LSEG        601
#define PG_TYPE_PATH        602
#define PG_TYPE_BOX         603
#define PG_TYPE_POLYGON     604
#define PG_TYPE_FILENAME    605
#define PG_TYPE_FLOAT4      700
#define PG_TYPE_FLOAT8      701
#define PG_TYPE_ABSTIME     702
#define PG_TYPE_RELTIME     703
#define PG_TYPE_TINTERVAL   704
#define PG_TYPE_UNKNOWN     705
#define PG_TYPE_OIDINT2     810
#define PG_TYPE_OIDINT4     910
#define PG_TYPE_OIDNAME     911
#define PG_TYPE_BPCHAR     1042
#define PG_TYPE_VARCHAR    1043
#define PG_TYPE_DATE       1082
#define PG_TYPE_TIME       1083

extern Int4 pgtypes_defined[];

Int2 pgtype_to_sqltype(Int4 type);
Int2 pgtype_to_ctype(Int4 type);
char *pgtype_to_name(Int4 type);
Int4 pgtype_precision(Int4 type);
Int4 pgtype_length(Int4 type);
Int2 pgtype_scale(Int4 type);
Int2 pgtype_radix(Int4 type);
Int2 pgtype_nullable(Int4 type);
Int4 pgtype_auto_increment(Int4 type);
Int4 pgtype_case_sensitive(Int4 type);
Int4 pgtype_money(Int4 type);
Int4 pgtype_searchable(Int4 type);
Int4 pgtype_unsigned(Int4 type);
char *pgtype_literal_prefix(Int4 type);
char *pgtype_literal_suffix(Int4 type);
char *pgtype_create_params(Int4 type);

Int2 sqltype_to_default_ctype(Int2 sqltype);

#endif
