/********************************************************************
    POSTODBCL.DLL - A library to talk to Postgres95 by using the
                    WINDOWS ODBC Interface

    Copyright (C) 1996; Christian Czezatke, Dan McGuirk

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details. 

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    How to contact the authors:
    
    email to: e9025461@student.tuwien.ac.at     (Christian Czezatke)
              mcguirk@indirect.com              (Dan McGuirk)  
********************************************************************/  

/*
** OPTIONS.C - This is the PostODBC driver code for
** executing Set/GetConnect/StmtOption.
*/

//      -       -       -       -       -       -       -       -       -

#include "globals.h"
#include <string.h>

/* Implements only SQL_AUTOCOMMIT */
RETCODE SQL_API SQLSetConnectOption(
        HDBC    hdbc,
        UWORD   fOption,
        UDWORD  vParam)
{
    ConnectionClass *conn = HI_connfromhdbc(the_handles, hdbc);

    if (NULL == conn) 
       return SQL_INVALID_HANDLE;

    switch (fOption) {
      case SQL_AUTOCOMMIT:
        if (conn->transact_status & CONN_IN_TRANSACTION) {
#ifdef _ENGLISH_
           conn->errormsg = "Cannot switch commit mode while a transaction is in progres";
#else
           conn->errormsg = "Es ist gerade eine Transaktion im Gange";
#endif            
           conn->errornumber = CONN_TRANSACT_IN_PROGRES;
           return SQL_ERROR;
        }
        if (SQL_AUTOCOMMIT_OFF == vParam)
           conn->transact_status = 0;
        else if (SQL_AUTOCOMMIT_ON == vParam)
           conn->transact_status = CONN_IN_AUTOCOMMIT;
        else {
#ifdef _ENGLISH_
           conn->errormsg = "Illegal parameter value for SQL_AUTOCOMMIT";
#else
           conn->errormsg = "Unggltiger Parameter fr SQL_AUTOCOMMIT"; 
#endif            
            

           conn->errornumber = CONN_INVALID_ARGUMENT_NO;
           return SQL_ERROR;
        }   
      break;
    case SQL_LOGIN_TIMEOUT:
        return SQL_SUCCESS;
        break;
    case SQL_ACCESS_MODE:
        return SQL_SUCCESS;
        break;
      default:
#ifdef _ENGLISH_
        conn->errormsg = "This option is currently unsupported by the driver";
#else
        conn->errormsg = "Diese Option wird zur Zeit nicht untersttzt";           
#endif            
        conn->errornumber = CONN_UNSUPPORTED_OPTION;
        return SQL_ERROR;
      break;

    }    
    return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -

RETCODE SQL_API SQLSetStmtOption(
        HSTMT   hstmt,
        UWORD   fOption,
        UDWORD  vParam)
{
    StatementClass *stmt;

    // thought we could fake Access out by just returning SQL_SUCCESS
    // all the time, but it tries to set a huge value for SQL_MAX_LENGTH
    // and expects the driver to reduce it to the real value

    stmt = HI_stmtfromhstmt(the_handles, hstmt);
    if(!stmt) {
        return SQL_INVALID_HANDLE;
    }

    switch(fOption) {
    case SQL_QUERY_TIMEOUT:
        return SQL_SUCCESS;
        break;
    case SQL_MAX_LENGTH:
/* CC: Some apps consider returning SQL_SUCCESS_WITH_INFO to be an error */
/* so if we're going to return SQL_SUCCESS, we better not set an */
/* error message.  (otherwise, if a subsequent function call returns */
/* SQL_ERROR without setting a message, things can get confused.) */

      /*
        stmt->errormsg = "Requested value changed.";
        stmt->errornumber = STMT_OPTION_VALUE_CHANGED;
       */

        return SQL_SUCCESS;
        break;
    case SQL_BIND_TYPE:
        stmt->binding_type_or_offset = vParam;
        return SQL_SUCCESS;
        break;
    case SQL_ROWSET_SIZE:
        if(vParam <= 0) {
            stmt->rowset_size = 1;
            stmt->errormsg = "Tried to set a rowset size (SQLSetStmtOption/SQL_ROWSET_SIZE) to less than 1.";
            stmt->errornumber = STMT_OPTION_VALUE_CHANGED;
            return SQL_SUCCESS_WITH_INFO;
        }

        stmt->rowset_size = vParam;
        return SQL_SUCCESS;
        break;
    default:
        return SQL_ERROR;
    }

    return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -

/* This function just can tell you whether you are in Autcommit mode or not */
RETCODE SQL_API SQLGetConnectOption(
        HDBC    hdbc,
        UWORD   fOption,
        PTR     pvParam)
{
    ConnectionClass *conn = HI_connfromhdbc(the_handles, hdbc);

    if (NULL == conn) 
       return SQL_INVALID_HANDLE;

    switch (fOption) {
      case SQL_AUTOCOMMIT:
      /* CC 28.05.96: Do not set fOption, but pvParam */
        *((UDWORD *)pvParam) = (UDWORD)((conn->transact_status) & CONN_IN_AUTOCOMMIT ?
                                        SQL_AUTOCOMMIT_ON : SQL_AUTOCOMMIT_OFF);
      break;
      /* we don't use qualifiers */
    case SQL_CURRENT_QUALIFIER:
      if(pvParam) {
        strcpy(pvParam, "");
      }
      break;
    default:
#ifdef _ENGLISH_
        conn->errormsg = "This option is currently unsupported by the driver";
#else
        conn->errormsg = "Diese Option wird zur Zeit nicht untersttzt";
#endif
        conn->errornumber = CONN_UNSUPPORTED_OPTION;
        return SQL_ERROR;
      break;

    }    

    return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -

RETCODE SQL_API SQLGetStmtOption(
        HSTMT   hstmt,
        UWORD   fOption,
        PTR     pvParam)
{
    switch(fOption) {
    case SQL_QUERY_TIMEOUT:
        // how long we wait on a query before returning to the
        // application (0 == forever)
        *((SDWORD *)pvParam) = 0;
        break;
    case SQL_MAX_LENGTH:
        // what is the maximum length that will be returned in
        // a single column
        *((SDWORD *)pvParam) = 4096;
        break;
    default:
        return SQL_ERROR;
    }

    return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -
