/* -*- mode: c++; c-basic-offset: 4 -*- */
/********************************************************************
    POSTODBCL.DLL - A library to talk to Postgres95 by using the
                    WINDOWS ODBC Interface

    Copyright (C) 1996; Christian Czezatke, Dan McGuirk

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details. 

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    How to contact the authors:
    
    email to: e9025461@student.tuwien.ac.at     (Christian Czezatke)
              mcguirk@indirect.com              (Dan McGuirk)  
********************************************************************/  


/*
** EXECUTE.C - This is the PostODBC driver code for
** executing SQL Commands.
**
*/

//      -       -       -       -       -       -       -       -       -

#include "globals.h"

//      -       -       -       -       -       -       -       -       -

//      Execute a prepared SQL statement
/* CC: Fully implemented */
RETCODE SQL_API SQLExecute(
        HSTMT   hstmt)          // statement to execute.
{
    StatementClass *stmt;
    ConnectionClass *conn;
    ResultC *res;
    char ok;

    /* see if shortcut helps to find the statementclass quickly */
    if (last_hstmt == hstmt) {
        /* yes, it did help! */
        stmt = last_stmt;
    } else {
        /* no, it did not help! */
        stmt = HI_stmtfromhstmt(the_handles, hstmt);
        if (NULL == stmt) {
            return SQL_INVALID_HANDLE;
        }
        last_stmt = stmt;
        last_hstmt = stmt->hstmt;
    }

    /* CC: Check if the statement is premature. If it is, just turn it into
           a finished statement, and we are done!
    */
    if (STMT_PREMATURE == stmt->status) {
      stmt->status = STMT_FINISHED;       
      return stmt->errormsg == NULL ? SQL_SUCCESS : SQL_ERROR;
    }  
    
    SC_clear_error(stmt);

    conn = SC_get_conn(stmt);
    /* now check if we have to start a transaction */
    if ( ! ((conn->transact_status) & CONN_IN_AUTOCOMMIT)  && /* we are in manual commit mode */
         ! ((conn->transact_status) & CONN_IN_TRANSACTION) /* and there is no transaction going on */
       )
    {             
       /* fire up a transaction before doing anything */
 
       res = ConnectionC_send_query(conn->connection, "begin transaction");
       if (NULL == res) {
#ifdef _ENGLISH_         
           stmt->errormsg = "Could not start a transaction.";
#else
           stmt->errormsg = "Fehler beim Starten einer Transaktion.";
#endif         
           stmt->errornumber = STMT_EXEC_ERROR;
           return SQL_ERROR;
       }
       ok = ResultC_command_successful(res);   
       ResultC_Destructor(res);
       if (!ok)
          return SQL_ERROR;
       else
          conn->transact_status |= CONN_IN_TRANSACTION;
    } /* CC: we had to start a transaction */

    if (!SC_do_execute(stmt))
        return SQL_ERROR;

/* CC: Some Apps consider that as an error   return SQL_SUCCESS_WITH_INFO; */
    return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -

//      Performs the equivalent of SQLPrepare, followed by SQLExecute.

RETCODE SQL_API SQLExecDirect(
        HSTMT     hstmt,
        UCHAR FAR *szSqlStr,
        SDWORD    cbSqlStr)
{
    StatementClass *stmt;
    ConnectionClass *conn;
    ResultC *res;
    char ok;
    
    /* see if shortcut helps to find the statementclass quickly */
    if (last_hstmt == hstmt) {
        /* yes, it did help! */
        stmt = last_stmt;
    } else {
        /* no, it did not help! */
        stmt = HI_stmtfromhstmt(the_handles, hstmt);
        if (NULL == stmt) {
            return SQL_INVALID_HANDLE;
        }
        last_stmt = stmt;
        last_hstmt = stmt->hstmt;
    }
    SC_clear_error(stmt);
    conn = SC_get_conn(stmt);


    /* now check if we have to start a transaction */
    if ( ! ((conn->transact_status) & CONN_IN_AUTOCOMMIT)  && /* we are in manual commit mode */
         ! ((conn->transact_status) & CONN_IN_TRANSACTION) /* and there is no transaction going on */
       )
    {             
       /* fire up a transaction before doing anything */

       res = ConnectionC_send_query(conn->connection, "begin transaction");
       if (NULL == res) {
            // this time we won't be able to get the error from the QResult object
#ifdef _ENGLISH_            
            stmt->errormsg = "Got a null result from the query.";
#else
            stmt->errormsg = "Fehler beim Starten der Transaktion.";
#endif
            stmt->errornumber = STMT_EXEC_ERROR;
            return SQL_ERROR;
       }            
       ok = ResultC_command_successful(res);   
       ResultC_Destructor(res);
       if (!ok)
          return SQL_ERROR;
       else
          conn->transact_status |= CONN_IN_TRANSACTION;   
    }    



    /* now we have got the right statement handle, so fire up the query */
    if (!SC_start_execution(stmt, szSqlStr, cbSqlStr)) {
        // SC_start_execution sets the error message        
        return SQL_ERROR;
    }
    
/* CC: Some apps consider that being an error   return SQL_SUCCESS_WITH_INFO; */
   return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -

//      Returns the SQL string as modified by the driver.

RETCODE SQL_API SQLNativeSql(
        LPDBC      lpdbc,
        UCHAR FAR *szSqlStrIn,
        SDWORD     cbSqlStrIn,
        UCHAR FAR *szSqlStr,
        SDWORD     cbSqlStrMax,
        SDWORD FAR *pcbSqlStr)
{
    // since we don't translate the SQL, this is pretty easy.
    // (well, actually we do a little, in copy_and_convert_statement.
    // but that's just removing newlines, etc.)
    strncpy_null(szSqlStr, szSqlStrIn, cbSqlStrMax);

    return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -

//      Supplies parameter data at execution time.      Used in conjuction with
//      SQLPutData.

RETCODE SQL_API SQLParamData(
        HSTMT   hstmt,
        PTR FAR *prgbValue)
{
        return SQL_ERROR;
}

//      -       -       -       -       -       -       -       -       -

//      Supplies parameter data at execution time.      Used in conjunction with
//      SQLParamData.

RETCODE SQL_API SQLPutData(
        HSTMT   hstmt,
        PTR     rgbValue,
        SDWORD  cbValue)
{
        return SQL_ERROR;
}

//      -       -       -       -       -       -       -       -       -


/* We do not support SQLCancel */
RETCODE SQL_API SQLCancel(
        HSTMT   hstmt)  // Statement to cancel.
{
        return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -
