/********************************************************************
    POSTODBCL.DLL - A library to talk to Postgres95 by using the
                    WINDOWS ODBC Interface

    Copyright (C) 1996; Christian Czezatke, Dan McGuirk

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details. 

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    How to contact the authors:
    
    email to: e9025461@student.tuwien.ac.at     (Christian Czezatke)
              mcguirk@indirect.com              (Dan McGuirk)  
********************************************************************/ 


/*
** DLL.C - This is the PostODBC driver code for
** LIBMAIN processing.
**
** Since I am not a Windows Guru I have to admit that I 
** Can't explain all the stuff that I used in here :-)
**
*/

//      -       -       -       -       -       -       -       -       -

#include "postodbc.h"
#include "globals.h"
#include <winsock.h>

HINSTANCE NEAR s_hModule;               // Saved module handle.

#ifdef _WIN32

#ifdef __WATCOMC__
int __stdcall LibMain(HANDLE hInst,DWORD ul_reason_being_called,LPVOID lpReserved) 
#else
int __stdcall DllMain(HANDLE hInst,DWORD ul_reason_being_called,LPVOID lpReserved) 
#endif
{
    switch (ul_reason_being_called) {
    case DLL_PROCESS_ATTACH:        // case of libentry call in win 3.x
        s_hModule = hInst;
        /* CC: Moved that from SQLAllocEnv to that location in order to be able to
               cope with Win16 restrictions without adding more "ifdef"s
        */       
        the_handles = HI_Constructor();
        if (NULL == the_handles)
          /* CC: Initialisation failed due to lack of memory */
          return FALSE;

        // init some more globals
        last_stmt = NULL;
        last_hstmt = SQL_NULL_HSTMT;
        break;
    case DLL_THREAD_ATTACH:
        break;
    case DLL_PROCESS_DETACH:        // case of wep call in win 3.x
        if (NULL != the_handles) {
          if (HI_Destructor(the_handles)) {
            WSACleanup();
            return TRUE;
          }
        }  
        // there is a query that is currently being executed
        // or SQLFreeEnv has already been called    
        return FALSE;
    case DLL_THREAD_DETACH:
        break;
    default:
        break;
    } /* switch */

    return TRUE;                                                                
                                                                                
    UNREFERENCED_PARAMETER(lpReserved);                                         
} /* LibMain */

#else   //      _WIN32

//      -       -       -       -       -       -       -       -       -

//      This routine is called by LIBSTART.ASM at module load time.  All it
//      does in this sample is remember the DLL module handle.  The module
//      handle is needed if you want to do things like load stuff from the
//      resource file (for instance string resources).

int _export FAR PASCAL libmain(
        HANDLE     hModule,
        short      cbHeapSize,
        UCHAR FAR *lszCmdLine)
{

  s_hModule = hModule;

  the_handles = HI_Constructor();
  if (NULL == the_handles)
      return FALSE;

  // init some more globals
  last_stmt = NULL;
  last_hstmt = SQL_NULL_HSTMT;
  
  return TRUE;
}


int _export CALLBACK WEP(int exittype)
/* unloading the DLL results in Closing all sockets and in calling WSACleanup */
{
    if (NULL != the_handles) {
      if (HI_Destructor(the_handles)) {
        WSACleanup();
        return TRUE;
      }
    }
    // there is a query that is currently being executed
    // or SQLFreeEnv has already been called    
    return FALSE;
}


#endif  //      _WIN32


void EXPFUNC FAR PASCAL LoadByOrdinal(void);
//      Entry point to cause DM to load using ordinals
void EXPFUNC FAR PASCAL LoadByOrdinal(void)
{
}
