#ifndef _CUSTOM_H_
#define _CUSTOM_H_

// defines to customize PostODBC

/*
 * comment this out if you want to get german error messages
 */
#define _ENGLISH_

/*
 * Uncomment this if you want SQLGetInfo to claim that PostODBC supports
 * EVERY function of the ODBC API.  Only useful for development since it
 * allows you to use a tool like ODBC Spy to see which functions a special
 * application tries to call.
 */
// #define GETINFO_LIE

/*
 * Uncomment this if you want to have the Postgres95 OID field returned in
 * a call to SQLColumns.  This is quite useful, but might be dangerous
 * when used for establishing relations between tuples.
 *
 * djm: Actually, after using it for a while it seems that
 * it tends to screw up a lot of stuff--use it at your own risk.
 */
// #define SHOW_OID

/*
 * This sets the maximum size for the Postgres95 types 'text', 'char', and
 * 'varchar' to 255.  This is useful when you're using Access--if the driver
 * reports a size greater than 255 to Access, it will treat your text fields
 * as memo fields, which can't be indexed.  (This can result in an
 * 'invalid field name in index' error that prevents you from linking a table.)
 *
 * Basically, Access assumes that because _it_ can't have an index
 * on a long text field, nobody can.
 *
 */
#define SMALL_TEXT_FIELDS

/*
 *
 * This fakes the result of SQLRowCount, which is supposed to tell how many
 * rows were affected by an insert or an update.  Access needs this if you
 * want to do inserts.
 *
 */
#define FAKE_ROWCOUNT


// No user - serviceable parts beyond that line...

#if defined(OS2) || defined(WIN32) || defined(_WIN32)
#  define COMPILE_FOR_32_BIT
#else
#  define COMPILE_FOR_16_BIT
#endif


#define DRIVERNAME "MinimalPostgresODBC"
#define POSTGRESDRIVERVERSION "00.21.0000"


#endif
