/********************************************************************
    POSTODBCL.DLL - A library to talk to Postgres95 by using the
                    WINDOWS ODBC Interface

    Copyright (C) 1996; Christian Czezatke, Dan McGuirk

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    How to contact the authors:

    email to: e9025461@student.tuwien.ac.at (Christian Czezatke)
              mcguirk@indirect.com          (Dan McGuirk)
********************************************************************/

/*
** CONNECT.C - This is the PostODBC driver code for
** allocation and connection.
**
*/

//      -       -       -       -       -       -       -       -       -

#ifdef OS2
#  include <os2.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include "socket\wrapper.h"
#include "globals.h"
#if defined(OS2)
#  include <sys/types.h>
#  include <sys/socket.h>
#  include <netinet/in.h>
#  include <signal.h>
#  include <netdb.h>
#  define BSD_SELECT
#  include <arpa/nameser.h>
#else
#  include <winsock.h>
#  include <sqlext.h>
#endif
#include <malloc.h>
#include "postodbc.h"
#include <string.h>
#ifndef OS2
#  include <windows.h>
#endif

//#include "ctl3d.h"

//      -       -       -       -       -       -       -       -       -

/* CC: The following makro was obviousely missing: */
#ifdef __WATCOMC__
#define GET_WM_COMMAND_ID(x,y) (x)
#endif


//      CONNECT.C
//
//      SQLC connection functions.

//      -       -       -       -       -       -       -       -       -

//      Allocate an environment (ENV) block.

RETCODE SQL_API SQLAllocEnv(
        HENV FAR *phenv)
{
  /* At first establish the connection to the WINSOCK.DLL */
  WSADATA socke;
  WORD requested_version;

  *phenv = (HENV FAR *)malloc(sizeof(HENV));

  requested_version = (1 << 8) + 1;
  // CC: HIBYTE = Major, LOBYTE = Minor Version

  if (WSAStartup(requested_version, &socke) != 0) {
      HI_Destructor(the_handles);
      return FALSE;
  }
  return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -

//      Allocate a DBC block.



RETCODE SQL_API SQLAllocConnect(
                                HENV     henv,
                                HDBC FAR *phdbc)
{
    HGLOBAL hdbc;
    EnvironmentClass *env = (EnvironmentClass *)henv;
    ConnectionClass *conn;

    hdbc = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT, sizeof (DBC));
    if (!hdbc || (*phdbc = (HDBC)GlobalLock (hdbc)) == SQL_NULL_HDBC) {
        GlobalFree (hdbc);      //      Free it if lock fails
#ifdef _ENGLISH_
        env->errormsg = "Couldn't allocate memory for HDBC.";
#else
        env->errormsg = "Speicheranforderung fr HDBC schlug fehl.";
#endif
        env->errornumber = ENV_ALLOC_ERROR;
        return SQL_ERROR;
    }

    // create the connection object here, too.
    conn = CC_Constructor();
    if(!conn) {
#ifdef _ENGLISH_
        env->errormsg = "Couldn't allocate memory for Connection object.";
#else
        env->errormsg = "Konnte keinen Speicher fr ein \"Connection object\" anfordern.";
#endif
        env->errornumber = ENV_ALLOC_ERROR;
        return SQL_ERROR;
    }

    if (!HI_add_connection(the_handles, conn)) {
        /* number of max. allowed connections exceeded */
#ifdef _ENGLISH_
        env->errormsg = "Maximum number of connections exceeded.";
#else
        env->errormsg = "Maximale Verbindungsanzahl wurde berschritten.";
#endif
        env->errornumber = ENV_ALLOC_ERROR;
        CC_Destructor(conn);
        return SQL_ERROR;
    }

    conn->hdbc = *phdbc;
    /* CC: I think we should not associate the handle before the connection gets
           actually opened. CC_Construcor initializes that with SQL_NULL_HDBC.
           I just would like to keep explicit assignments to "struct" members
           to a minimum
    */
    return SQL_SUCCESS;
}


//      -       -       -       -       -       -       -       -       -

RETCODE SQL_API SQLConnect(
                           HDBC      hdbc,
                           UCHAR FAR *szDSN,
                           SWORD     cbDSN,
                           UCHAR FAR *szUID,
                           SWORD     cbUID,
                           UCHAR FAR *szAuthStr,
                           SWORD     cbAuthStr)
{
    ConnectionClass *conn;
    char machine[80], port[10], dbasename[80], username[80];

    conn = HI_connfromhdbc(the_handles, hdbc);
    if(!conn) {
        return SQL_INVALID_HANDLE;
    }

    /* get the defaults from the registry */
    CC_get_defaults(szDSN,
                    machine, sizeof(machine),
                    port, sizeof(port),
                    dbasename, sizeof(dbasename),
                    username, sizeof(username));

    /* now do the actual connect */
    if (!CC_connect(conn, hdbc, szDSN, szUID, machine, port, dbasename)) {
        return SQL_ERROR;
    }

    return SQL_SUCCESS;
}



//      -       -       -       -       -       -       -       -       -

//      This function as its "normal" behavior is supposed to bring up a
//      dialog box if it isn't given enough information via "szConnStrIn".  If
//      it is given enough information, it's supposed to use "szConnStrIn" to
//      establish a database connection.  In either case, it returns a
//      string to the user that is the string that was eventually used to
//      establish the connection.

// SQLDriverConnect-related routines

static char *DSN    =NULL,
             *driver =NULL,
             *uid    =NULL,
             *pwd    =NULL,
             *server =NULL,
             *port   =NULL,
             *database=NULL;

void dconn_GetDialogValues(HWND hdlg)
{
    if(server) { free(server); }
    server = (char *)malloc(128);
    GetDlgItemText(hdlg, 1501, server, 127);

    if(port) { free(port); }
    port = (char *)malloc(128);
    GetDlgItemText(hdlg, 1502, port, 127);

    if(database) { free(database); }
    database = (char *)malloc(128);
    GetDlgItemText(hdlg, 1503, database, 127);

    if(uid) { free(uid); }
    uid = (char *)malloc(128);
    GetDlgItemText(hdlg, 1504, uid, 127);
}


#ifdef _WIN32
BOOL FAR PASCAL dconn_FDriverConnectProc(
#else
BOOL FAR PASCAL _export dconn_FDriverConnectProc(
/* CC: Weird things happen when the "_export" statement is missing. Declaring that
       function as exported in the .DEF file did not help either...
*/
#endif
                                         HWND    hdlg,
                                         UINT    wMsg,
                                         WPARAM  wParam,
                                         LPARAM  lParam)
{
    switch (wMsg) {
    case WM_INITDIALOG:
        if(server)
          SetDlgItemText(hdlg, 1501, server);
        if(port)
            SetDlgItemText(hdlg, 1502, port);
        if(database)
            SetDlgItemText(hdlg, 1503, database);
        if(uid)
            SetDlgItemText(hdlg, 1504, uid);
        break; /* CC: break inserted */
    case WM_COMMAND:
        switch (GET_WM_COMMAND_ID(wParam, lParam)) {
        case IDOK:
            dconn_GetDialogValues(hdlg);
        case IDCANCEL:
            EndDialog(hdlg, GET_WM_COMMAND_ID(wParam, lParam) == IDOK);
            return TRUE;
        }
    }

    return FALSE;
}



void dconn_get_connect_attributes(UCHAR FAR *connect_string,
                                  char **DSN,
                                  char **driver,
                                  char **uid,
                                  char **pwd,
                                  char **server,
                                  char **port,
                                  char **database)
{
    char *our_connect_string;
    char *attribute, *value;
    char *strtok_arg;

    *DSN = 0;
    *driver = 0;
    *uid = 0;
    *pwd = 0;
    *server = 0;
    *port = 0;
    *database = 0;

    our_connect_string = strdup(connect_string);
    strtok_arg = our_connect_string;

    while(1) {
        attribute = strtok(strtok_arg, "=");
        if(strtok_arg) {
            strtok_arg = 0;
        }
        if(!attribute) {
            break;
        }

        value = strtok(strtok_arg, ";");
        if(!value) {
            break;
        }

        if(stricmp(attribute, "DSN") == 0) {
            *DSN = strdup(value);
        } else if(stricmp(attribute, "driver") == 0) {
            *driver = strdup(value);
        } else if(stricmp(attribute, "uid") == 0) {
            *uid = strdup(value);
        } else if(stricmp(attribute, "pwd") == 0) {
            *pwd = strdup(value);
        } else if((stricmp(attribute, "server") == 0) ||
                  (stricmp(attribute, "servername") == 0)) {
            *server = strdup(value);
        } else if(stricmp(attribute, "port") == 0) {
            *port = strdup(value);
        } else if(stricmp(attribute, "database") == 0) {
            *database = strdup(value);
        }
    }


    free(our_connect_string);
}



RETCODE dconn_DoDialog(HWND hwnd)
{
    int dialog_result;

    DLGPROC dlgproc;


    if(hwnd) {
        dialog_result = DialogBox(s_hModule, MAKEINTRESOURCE(101),
                                  hwnd, dconn_FDriverConnectProc);
        if(!dialog_result || (dialog_result == -1)) {
            return SQL_NO_DATA_FOUND;
        } else {
            return SQL_SUCCESS;
        }
    }
    /* CC: if HWND is not set, return SQL_ERROR */
    return SQL_ERROR;
}



void dconn_free_stuff(void)
{
    if(DSN) { free(DSN); }
    if(driver) { free(driver); }
    if(uid) { free(uid); }
    if(pwd) { free(pwd); }
    if(server) { free(server); }
    if(port) { free(port); }
    if(database) { free(database); }
}



RETCODE SQL_API SQLDriverConnect(
                                 HDBC      hdbc,
                                 HWND      hwnd,
                                 UCHAR FAR *szConnStrIn,
                                 SWORD     cbConnStrIn,
                                 UCHAR FAR *szConnStrOut,
                                 SWORD     cbConnStrOutMax,
                                 SWORD FAR *pcbConnStrOut,
                                 UWORD     fDriverCompletion)
{
    char default_server[80], default_port[10],
        default_database[80], default_username[80];
    RETCODE dialog_result;
    ConnectionClass *conn;
    char *connect_string;

   conn = HI_connfromhdbc(the_handles, hdbc);
    if(!conn) {
        return SQL_INVALID_HANDLE;
    }

    dconn_get_connect_attributes(szConnStrIn, &DSN, &driver, &uid, &pwd,
                                 &server, &port, &database);
    if((!DSN) || (DSN[0] == '\0')) {
        // should really get the info for the 'default' data source
        // do we have one?
        dconn_free_stuff();
        return SQL_NO_DATA_FOUND;
    }

    CC_get_defaults(DSN,
                    default_server, sizeof(default_server),
                    default_port, sizeof(default_port),
                    default_database, sizeof(default_database),
                    default_username, sizeof(default_username));

    if((!server) || (server[0] == '\0')) {
        if(server) { free(server); }
        server = strdup(default_server);
    }

    if(!port || port[0] == '\0') {
        if(port) { free(port); }
        port = strdup(default_port);
    }
    if(!database || database[0] == '\0') {
        if(database) { free(database); }
        database = strdup(default_database);
    }
    if(!uid || uid[0] == '\0') {
        if(uid) { free(uid); }
        uid = strdup(default_username);
    }

    switch(fDriverCompletion) {
    case SQL_DRIVER_PROMPT:
        dialog_result = dconn_DoDialog(hwnd);
        if(dialog_result != SQL_SUCCESS) {
            return dialog_result;
        }
        break;
    case SQL_DRIVER_COMPLETE:
    case SQL_DRIVER_COMPLETE_REQUIRED:
        if(!uid       || uid[0]       == '\0' ||
           !server    || server[0]    == '\0' ||
           !port      || port[0]      == '\0' ||
           !database  || database[0]  == '\0') {
            dialog_result = dconn_DoDialog(hwnd);
            if(dialog_result != SQL_SUCCESS) {
                return dialog_result;
            }
        }
        break;
    case SQL_DRIVER_NOPROMPT:
        break;
    }

    if(!uid       || uid[0]       == '\0' ||
       !server    || server[0]    == '\0' ||
       !port      || port[0]      == '\0' ||
       !database  || database[0]  == '\0') {
        return SQL_NO_DATA_FOUND;
    }

    if(szConnStrOut) {
        // return the completed string to the caller
        connect_string = (char *)malloc(4 +             /* DSN= */
                                        strlen(DSN) +
                                        5 +             /* ;UID= */
                                        strlen(uid) +
                                        8 +             /* ;SERVER= */
                                        strlen(server) +
                                        6 +             /* ;PORT= */
                                        strlen(port) +
                                        10 +            /* ;DATABASE= */
                                        strlen(database) +
                                        1);
        strcpy(connect_string, "DSN=");
        strcat(connect_string, DSN);
        strcat(connect_string, ";UID=");
        strcat(connect_string, uid);
        strcat(connect_string, ";SERVER=");
        strcat(connect_string, server);
        strcat(connect_string, ";PORT=");
        strcat(connect_string, port);
        strcat(connect_string, ";DATABASE=");
        strcat(connect_string, database);

        if(pcbConnStrOut) {
            *pcbConnStrOut = strlen(connect_string);
        }
        strncpy_null(szConnStrOut, connect_string, cbConnStrOutMax);
    }

    // do the actual connect
    if (!CC_connect(conn, hdbc, DSN, uid, server, port, database)) {
        return SQL_ERROR;
    }

    return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -

RETCODE SQL_API SQLBrowseConnect(
        HDBC      hdbc,
        UCHAR FAR *szConnStrIn,
        SWORD     cbConnStrIn,
        UCHAR FAR *szConnStrOut,
        SWORD     cbConnStrOutMax,
        SWORD FAR *pcbConnStrOut)
{
        return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -

RETCODE SQL_API SQLDisconnect(
        HDBC      hdbc)
{
    ConnectionClass *conn;


        conn = HI_connfromhdbc(the_handles, hdbc);

        if (NULL == conn)
            return SQL_INVALID_HANDLE;

        if (!HI_remove_connection(the_handles, conn)) {
            // destructing failed because a query is currently
            // being executed
            conn->errornumber = CONN_IN_USE;
#ifdef _ENGLISH_
            conn->errormsg = "A query is currently being executed";
#else
            conn->errormsg = "Es wird gerade eine Abfrage ueber diese Verbindung durchgefuehrt.";
#endif
            return SQL_ERROR;
        }

        CC_Destructor(conn);

        return SQL_SUCCESS;
}


//      -       -       -       -       -       -       -       -       -

RETCODE SQL_API SQLFreeConnect(
        HDBC      hdbc)
{
        GlobalUnlock (GlobalPtrHandle(hdbc));
        GlobalFree (GlobalPtrHandle(hdbc));
        return SQL_SUCCESS;
}

//      -       -       -       -       -       -       -       -       -

RETCODE SQL_API SQLFreeEnv(
                           HENV      henv)
{
    EnvironmentClass *env = (EnvironmentClass *)henv;

    if (NULL != the_handles) {
 /*       if (HI_Destructor(the_handles)) { CC: Moved to DLL unloading routine due to 16bit restrictions */
            WSACleanup();
            if(env) {
                EN_Destructor(env);
            }
            return SQL_SUCCESS;
 /*      } CC: Moved to DLL unloading routine due to 16bit restrictions */
    }

    // there is a query that is currently being executed
    // or SQLFreeEnv has already been called

    return SQL_ERROR;
}

