#include <global.h>

void bmove(dst, src, len)
register char *dst;
register const char *src;
register uint len;
{
  while (len-- != 0) *dst++ = *src++;
}

void bmove_allign(dst, src, len)
register char *dst;
register const char *src;
register uint len;
{
  while (len-- != 0) *dst++ = *src++;
}

void bmove_upp(dst, src, len)
register char *dst;
register const char *src;
register uint len;
{
  while (len-- != 0) *--dst = *--src;
}

void strappend(s,len,fill)
register char *s,fill;
size_s len;
{
  register char *endpos;

  endpos = s+len;
  while (*s++) ;
  s--;
  while (s<endpos) *(s++) = fill;
  *(endpos) = '\0';
} /* strappend */


string strcont(str,set)
reg1 string str;
reg2 string set;
{
  reg3 string start = set;

  while (*str)
  {
    while (*set)
    {
      if (*set++ == *str)
	return (str);
    }
    set=start; str++;
  }
  return (NullS);
} /* strcont */

char *strend(s)
register const char *s;
{
  while (*s++) ;
  return (char*) (s-1);
}

string strfill(s,len,fill)
reg1 string s;
reg3 char fill;
reg2 size_s len;
{
  while (len--) *s++ = fill;
  *(s) = '\0';
  return(s);
} /* strfill */

char *strcend(s, c)
register const char *s;
register pchar c;
{
  for (;;)
  {
     if (*s == (char) c) return (char*) s;
     if (!*s++) return (char*) s-1;
  }
}


char *strfind(str,search)
register const char *str;
const char *search;
{
 register char *i,*j;

skipp:
  while (*str != '\0') {
    if (*str++ == *search) {
      i=(char*) str; j=(char*) search+1;
      while (*j)
	if (*i++ != *j++) goto skipp;
      return ((char*) str-1);
    }
  }
  return ((char*) 0);
} /* strfind */


uint strinstr(str,search)
reg1 const char *str;
reg4 const char *search;
{
  reg2 string i,j;
  string start = (string) str;

 skipp:
  while (*str != '\0')
    {
      if (*str++ == *search)
	{
	  i=(char*) str; j= (char*) search+1;
	  while (*j)
	    if (*i++ != *j++) goto skipp;
	  return ((uint) (str - start));
	}
    }
  return (0);
}

char *strmake(dst, src, length)
reg1 char *dst;
reg2 const char *src;
reg3 size_s  length;
{
  while (length--)
    if (! (*dst++ = *src++))
      return dst-1;
  *dst=0;
  return dst;
}

char *strmake_overlapp(dst, src, length)
reg1 char *dst;
reg2 const char *src;
reg3 size_s  length;
{
  while (length--)
    if (! (*dst++ = *src++))
      return dst-1;
  *dst=0;
  return dst;
}

char *strnmov(dst, src, n)
     reg1 char *dst;
     reg2 const char *src;
     reg3 size_s n;
{
  while (n-- != 0) {
    if (!(*dst++ = *src++)) {
      return (char*) dst-1;
    }
  }
  return dst;
}

size_s strnlen(src,max_len)
     reg1 char *src;
     reg2 size_s max_len;
{
  char *start,*end;
  for (start=src,end=start+max_len ; *src && src != end ; src++) ;
  return (size_s) (src-start);
}


#include <varargs.h>

char *strxmov(va_alist)
va_dcl
{
  va_list pvar;
  char * dst;
  const char *src;

  va_start(pvar);
  dst=va_arg(pvar,char *);
  src=va_arg(pvar,const char*);
  while (src != NullS) {
    while (*dst++ = *src++) ;
    dst--;
    src = va_arg(pvar, char *);
  }
  *dst = 0;			/* there might have been no sources! */
  return dst;
}
