/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

#define USES_TYPES
#include "mysys_priv.h"
#include "errors.h"
#include <errno.h>
#ifdef MSDOS
#include <share.h>
#include <io.h>
#endif

	/* Extern variabels and functions used in this file */
extern int	my_file_opened;

	/* Open a file */

File my_open(FileName, Flags, MyFlags)
const char *FileName;		/* Path-name of file */
int Flags;			/* Read | write .. */
myf MyFlags;			/* Special flags */
{
  File fd;
  DBUG_ENTER("my_open");
  DBUG_PRINT("my",("Name: '%s'  Flags: %d  MyFlags: %d",
		   FileName, Flags, MyFlags));
#if defined(USG) || defined(VMS)
  fd = open((string) FileName, Flags);
#else
#ifdef MSDOS
  if (Flags & O_SHARE)
    fd = sopen((string) FileName, (Flags & ~O_SHARE) | O_BINARY, SH_DENYNO);
  else
    fd = open((string) FileName, Flags | O_BINARY);
#else
  fd = open(FileName, Flags, 0);
#endif
#endif

  if ((int) fd >= 0)
  {
    pthread_mutex_lock(&THR_LOCK_open);
    if ((my_file_info[fd].name = (char*) my_strdup(FileName,MyFlags)))
    {
      my_file_opened++;
      my_file_info[fd].type = FILE_BY_OPEN;
      pthread_mutex_unlock(&THR_LOCK_open);
      DBUG_PRINT("exit",("fd: %d",fd));
      DBUG_RETURN(fd);
    }
    pthread_mutex_unlock(&THR_LOCK_open);
    VOID(my_close(fd,MyFlags));
    my_errno=ENOMEM;
    DBUG_PRINT("error",("error %d on open",errno));
  }
  else
    my_errno=errno;
  if (MyFlags & (MY_FFNF | MY_FAE | MY_WME))
    my_error(EE_FILENOTFOUND, MYF(ME_BELL+ME_WAITTANG), FileName,my_errno);
  DBUG_RETURN(fd);
} /* my_open */


	/* Close a file */

int my_close(fd, MyFlags)
File fd;
myf MyFlags;
{
  int err;
  DBUG_ENTER("my_close");
  DBUG_PRINT("my",("fd: %d  MyFlags: %d",fd, MyFlags));

  pthread_mutex_lock(&THR_LOCK_open);
  if ((err = close(fd)) != 0)
  {
    my_errno=errno;
    if (MyFlags & (MY_FAE | MY_WME))
      my_error(EE_BADCLOSE, MYF(ME_BELL+ME_WAITTANG),my_filename(fd),errno);
  }
  if (my_file_info[fd].type != UNOPEN)
  {
    my_file_opened--;
    my_free(my_file_info[fd].name, MYF(0));
    my_file_info[fd].type = UNOPEN;
  }
  pthread_mutex_unlock(&THR_LOCK_open);
  DBUG_RETURN(err);
} /* my_close */
