/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

#include <m_curses.h>
#include <m_string.h>
#include <my_sys.h>
#include <m_input.h>
#include <time.h>

#define ERRTIME	3

	/* Ring bell for user */

#ifndef __NCURSES_H
#if defined(M_TERMCAP) || defined(VAXCURSES)
void beep()
{
  putchar('\007');				/* This should make a bell */
} /* beep */
#endif
#endif

int my_message_curses(str, MyFlags)
const char *str;
reg1 myf MyFlags;
{
  int	  flag,row,old_row,old_kol,ret_value,length;
  WINDOW * win;
  DBUG_ENTER("my_message");

  ret_value=0;
  ATTR_CUR_OFF();
  put_cursor_on_screen = 1;			/* reset, we may be in input */
  length=strlen(str);
  if (!(MyFlags & ME_OLDWIN))
  {
    int rows= (max(length,1)+COLS-1)/COLS;
    win = my_newwin(rows, COLS, LINES - rows, 0);
    row = 0;
    LINT_INIT(old_row); LINT_INIT(old_kol);
  }
  else
  {
    getyx(stdscr,old_row,old_kol);
    win = stdscr;
    row = LINES - 1;
  }
  wmove(win,row,0); wclrtoeol(win);
  wmove(win, row, (int) (COLS - length) / 2);

  if (MyFlags & ME_BELL) beep();
  if ((flag=(MyFlags >> ME_HIGHBYTE)) == 0)
  { ATTR_FATAL_ERROR(win); }	/* Very important error */
  else if (flag == 1)
  { ATTR_INFO(win);}		/* Some information */
  else if (flag == 2)
  { ATTR_WORKING(win);}		/* Computer is working at something */
  else if (flag == 3)
  { ATTR_ERROR(win); }		/* Some error */

  waddstr(win,(char *) str);

  if ((flag=(MyFlags >> ME_HIGHBYTE)) == 0)
  { ATTR_FATAL_ERROR_OFF(win); }
  else if (flag == 1)
  { ATTR_INFO_OFF(win);}
  else if (flag == 2)
  { ATTR_WORKING_OFF(win);}
  else if (flag == 3)
  { ATTR_ERROR_OFF(win); }

  wmove(win, row, 0);
  if (!(MyFlags & ME_NOREFRESH) || win != stdscr ||
      (MyFlags & (ME_WAITTOT+ME_WAITTANG)))
  {
    refresh();
    if (win != stdscr)
      wrefresh(win);
  }
  if (MyFlags & ME_NOINPUT)
  {
    if (MyFlags & (ME_WAITTOT | ME_WAITTANG))
      sleep(ERRTIME);
  }
  else
  {
    if (my_input_inited)
    {
      if (!(MyFlags & ME_HOLDTANG))
	empty_keybuffer(1);
      if (MyFlags & ME_WAITTOT)
	ret_value= (sleeptang(ERRTIME) >= FUNKTANG + T_RESET);
      else if (MyFlags & ME_WAITTANG)
	ret_value= (get_cur_tang(1) >= FUNKTANG+T_RESET);
    }
    else if (MyFlags & (ME_WAITTANG+ME_WAITTOT))
      sleep(ERRTIME);
  }
  if (!(MyFlags & ME_OLDWIN))
  {
    my_delwin(win);				/* Remove win and fix screen */
    if (!(MyFlags & ME_NOREFRESH))
      my_refresh();
  }
  else
    move(old_row,old_kol);	/* Put cursor on old pos */
  DBUG_RETURN(ret_value);
}
