/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*$Header: /usr/home/my/tmp/usr/my/srclib/mycurses/RCS/my_inter.c,v 1.1 90/08/17 09:59:06 root Exp $*/
/*
   Functions to handle interrupts with curses and input
   One can set my_sigtstp_cleanup and my_sigtstp_restart to point at
   functions to execute before and after SIGTSTP is recived.
   Theese functions fixes (curses) screen on exit and re-entry
*/

#include <m_curses.h>
#include <my_sys.h>
#include <signal.h>

#define S_STOP	1

void	(*my_sigtstp_cleanup)() =0, (*my_sigtstp_restart)() =0;
int	NEAR my_recived_signals=0, NEAR my_safe_to_handle_signal=0;

	/* Handling of SIGTSTP signal ( jump to shell with ^Z) */


sig_handler sigtstp_handler(signal_number)
int signal_number;
{
#ifdef SIGTSTP
  signal(SIGTSTP, sigtstp_handler);
  my_recived_signals |= S_STOP;
#endif
  return;
}

	/* Handle recived signals */
	/* Use this to execute recived signals */

void handle_recived_signals()
{

#ifdef SIGTSTP
  if (my_recived_signals & S_STOP)		/* If we have got signal */
  {
    WINDOW *win;
    sig_return old_sigint;
#ifdef SIGTTOU
    signal(SIGTTOU, SIG_IGN);
#endif
    old_sigint=signal(SIGINT,SIG_IGN);		/* Don't allow to stop */
    if (my_sigtstp_cleanup)			/* Execute user cleanup */
      (*my_sigtstp_cleanup)();

    if ((win=my_newwin(1,COLS,LINES-1,0)))
    {
      my_refresh();
      my_delwin(win);
    }
    resetterm();
#ifdef SIGTTOU
    signal(SIGTTOU, SIG_DFL);
#endif
    signal(SIGTSTP, SIG_DFL);
    kill(getpid(), SIGTSTP);			/* Godbye... */

    signal(SIGTSTP, sigtstp_handler);
    fixterm();					/* fix terminal and screen */
    clearok(curscr,1);
    my_refresh();
    if (my_sigtstp_restart)			/* Execute user restart */
      (*my_sigtstp_restart)();
    signal(SIGINT,old_sigint);			/* restore sigint */
  }
#endif
  my_recived_signals=0 ;
  return;
} /* handle_recived_signals */
