/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

#include "mysys_priv.h"
#include "my_static.h"
#include "errors.h"
#include <signal.h>
#ifdef HAVE_GETRUSAGE
#include <sys/time.h>
#include <sys/resource.h>
extern int     getrusage _A((int, struct rusage *));
#endif
#ifdef VMS
#include <my_static.c>
#include <m_ctype.h>
#endif

	/* Init my_sys functions and my_sys variabels */

#ifdef THREAD
#include <pthread.h>
static pthread_key_t THR_KEY_my_errno;
pthread_key_t THR_KEY_sigset;
pthread_mutex_t THR_LOCK_malloc=PTHREAD_MUTEX_INITIALIZER,
  THR_LOCK_open=PTHREAD_MUTEX_INITIALIZER,
  THR_LOCK_keycash=PTHREAD_MUTEX_INITIALIZER;
#endif

void my_init()
{
  string str;
  DBUG_ENTER("my_init");

  if (!home_dir)
  {						/* Don't initialize twice */
    if ((home_dir=getenv("HOME")) != 0)
      home_dir=intern_filename(home_dir_buff,home_dir);
#ifndef VMS
    if ((str=getenv("UMASK")) != 0)
      my_umask=atoi(str);		/* Default creation of new files */
#endif
#ifdef VMS
    init_ctype();			/* Stupid linker don't link _ctype.c */
#endif
#ifdef THREAD
    if (pthread_key_create(&THR_KEY_my_errno,free) ||
	pthread_key_create(&THR_KEY_sigset,free))
    {
      fprintf(stderr,"Can't initialize threads: error %d\n",errno);
      exit(1);
    }
    my_thread_init();
    sigfillset(&my_signals);		/* signals blocked by mf_brkhant */
#endif
    DBUG_PRINT("exit",("home: '%s'",home_dir));
  }
  DBUG_VOID_RETURN;
} /* my_init */


	/* End my_sys */

void my_end(infoflag)
int infoflag;
{
  FILE *info_file;
  DBUG_ENTER("my_end");

  if (!(info_file=DBUG_FILE))
    info_file=stderr;
  if (infoflag & MY_CHECK_ERROR || info_file != stderr)
  {					/* Test if some file is left open */
    if (my_file_opened | my_stream_opened)
    {
      sprintf(errbuff[0],EE(EE_OPEN_WARNING),my_file_opened,my_stream_opened);
      VOID(my_message_no_curses(errbuff[0],ME_BELL));
      DBUG_PRINT("error",("%s",errbuff[0]));
    }
  }
  if (infoflag & MY_GIVE_INFO || info_file != stderr)
  {
#ifdef HAVE_GETRUSAGE
    struct rusage rus;
    getrusage(RUSAGE_SELF, &rus);
    fprintf(info_file,"\nUser time %.2f, System time %.2f\nMaximum resident set size %d, Integral resident set size %d\nNon physical pagefaults %d, Physical pagefaults %d, Swaps %d\nBlocks in %d out %d, Messages in %d out %d, Signals %d\nVouluntary contexts switches %d, Invouluntary contexts switches %d\n",
	    (rus.ru_utime.tv_sec * SCALE_SEC +
	     rus.ru_utime.tv_usec / SCALE_USEC) / 100.0,
	    (rus.ru_stime.tv_sec * SCALE_SEC +
	     rus.ru_stime.tv_usec / SCALE_USEC) / 100.0,
	    rus.ru_maxrss, rus.ru_idrss,
	    rus.ru_minflt, rus.ru_majflt,
	    rus.ru_nswap, rus.ru_inblock, rus.ru_oublock,
	    rus.ru_msgsnd, rus.ru_msgrcv, rus.ru_nsignals,
	    rus.ru_nvcsw, rus.ru_nivcsw);
#endif
#ifdef MSDOS
    fprintf(info_file,"\nRun time: %.1f\n",(double) clock()/CLOCKS_PER_SEC);
#endif
#ifdef SAFEMALLOC
    TERMINATE(stderr);		/* Give statistic on screen */
#endif
  }
#ifdef THREAD
  pthread_mutex_destroy(&THR_LOCK_keycash);
  pthread_mutex_destroy(&THR_LOCK_malloc);
  pthread_mutex_destroy(&THR_LOCK_open);
#endif
  DBUG_VOID_RETURN;
} /* my_end */


#ifdef THREAD
void my_thread_init()
{
  pthread_setspecific(THR_KEY_my_errno,calloc(1,sizeof(int)));
  pthread_setspecific(THR_KEY_sigset,calloc(1,sizeof(sigset_t)));
}

int *_my_errno(void)
{
  return pthread_getspecific(THR_KEY_my_errno);
}
#endif
