/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/* USE_MY_STREAM isn't set because we can't thrust my_fclose! */

#include "mysys_priv.h"
#include "errors.h"

	/* Read a chunk of bytes from a file  */
	/* Returns (uint) -1 if error as my_read() */

uint my_fread(stream, Buffer, Count, MyFlags)
FILE	*stream;	/* File descriptor */
byte	*Buffer;	/* Buffer must be at least count bytes */
uint	Count;		/* Max number of bytes returnd */
myf	MyFlags;	/* Flags on what to do on error */
{
  uint readbytes;
  DBUG_ENTER("my_fread");
  DBUG_PRINT("my",("stream: %lx  Buffer: %lx  Count: %u  MyFlags: %d",
		   stream, Buffer, Count, MyFlags));

  if ((readbytes = (uint) fread(Buffer,sizeof(char),(size_t) Count,stream))
      != Count)
  {
    DBUG_PRINT("error",("Read only %d bytes",readbytes));
    if (MyFlags & (MY_WME | MY_FAE | MY_FNABP))
    {
      if (ferror(stream))
	my_error(EE_READ, MYF(ME_BELL+ME_WAITTANG),
		 my_filename(fileno(stream)),errno);
      else
      if (MyFlags & (MY_NABP | MY_FNABP))
	my_error(EE_EOFERR, MYF(ME_BELL+ME_WAITTANG),
		 my_filename(fileno(stream)),errno);
    }
    my_errno=errno;
    if (ferror(stream) || MyFlags & (MY_NABP | MY_FNABP))
      DBUG_RETURN((uint) -1);			/* Return with error */
  }
  if (MyFlags & (MY_NABP | MY_FNABP))
    DBUG_RETURN(0);				/* Read ok */
  DBUG_RETURN(readbytes);
} /* my_fread */


	/* Write a chunk of bytes to a stream */
	/* Returns (uint) -1 if error as my_write() */
	/* ARGSUSED */

uint my_fwrite(stream, Buffer, Count, MyFlags)
FILE *stream;
const byte *Buffer;
uint Count;
myf MyFlags;
{
  uint writenbytes;
#if !defined(NO_BACKGROUND) && defined(USE_MY_STREAM)
  uint errors;
  long seekptr;
#endif
  DBUG_ENTER("my_fwrite");
  DBUG_PRINT("my",("stream: %lx  Buffer: %lx  Count: %u  MyFlags: %d",
		   stream, Buffer, Count, MyFlags));

#if !defined(NO_BACKGROUND) && defined(USE_MY_STREAM)
  LINT_INIT(seekptr);
  errors=0;
  if (MyFlags & MY_WAIT_IF_FULL)
    seekptr=ftell(stream);
#endif
  for (;;)
  {
    if ((writenbytes = (uint) fwrite((char*) Buffer,sizeof(char),
				     (size_t) Count, stream))
	!= Count)
    {
      DBUG_PRINT("error",("Write only %d bytes",writenbytes));
      my_errno=errno;
#if !defined(NO_BACKGROUND) && defined(USE_MY_STREAM)
      if (errno == ENOSPC && (MyFlags & MY_WAIT_IF_FULL))
      {
	if (!(errors++ % MY_WAIT_GIVE_USER_A_MESSAGE))
	  my_error(EE_DISK_FULL,MYF(ME_BELL | ME_NOREFRESH));
	sleep(MY_WAIT_FOR_USER_TO_FIX_PANIC);
	VOID(my_fseek(stream,seekptr,MY_SEEK_SET,MYF(0)));
	continue;
      }
#endif
      if (ferror(stream) || MyFlags & (MY_NABP | MY_FNABP))
      {
	if (MyFlags & (MY_WME | MY_FAE | MY_FNABP))
	{
	  my_error(EE_WRITE, MYF(ME_BELL+ME_WAITTANG),
		   my_filename(fileno(stream)),errno);
	}
	DBUG_RETURN((uint) -1); /* Return that we got error */
      }
    }
    if (MyFlags & (MY_NABP | MY_FNABP))
      DBUG_RETURN(0);		/* Everything OK */
    DBUG_RETURN(writenbytes);
  }
} /* my_fwrite */

	/* Seek to position in file */
	/* ARGSUSED */

ulong my_fseek(stream, pos, whence, MyFlags)
FILE *stream;
ulong pos;
int whence;
myf MyFlags;
{
  DBUG_ENTER("my_fseek");
  DBUG_PRINT("my",("stream: %lx  pos: %lu  whence: %d  MyFlags: %d",
		   stream, pos, whence, MyFlags));
  DBUG_RETURN(fseek(stream, (long) pos, whence) ?
	      (ulong) -1 : (ulong) ftell(stream));
} /* my_seek */


	/* Tell current position of file */
	/* ARGSUSED */

ulong my_ftell(stream, MyFlags)
FILE *stream;
myf MyFlags;
{
  long pos;
  DBUG_ENTER("my_ftell");
  DBUG_PRINT("my",("stream: %lx  MyFlags: %d",stream, MyFlags));
  pos=ftell(stream);
  DBUG_PRINT("exit",("ftell: %lu",pos));
  DBUG_RETURN((ulong) pos);
} /* my_ftell */
