/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*$Header: /my/CVSRepository/my/srclib/mycurses/my_curses.c,v 1.5 1993/04/10 22:47:14 monty Exp $*/
/*
   Some functions to make curses use many windows on top of eatchother
   with restoring of screen when on is deleted
*/

#include <m_curses.h>
#include <m_string.h>
#include <my_sys.h>

#define MAX_OPEN_WINDOWS 10			/* Open windows at same time */

static WINDOW	*open_windows[MAX_OPEN_WINDOWS];
static int	open_index=0;

	/* Open new window and save pointer to window in "open_windows" */

WINDOW *my_newwin(num_lines, num_columns, begy, begx)
int num_lines, num_columns, begy, begx;
{
  reg1 WINDOW *win;
  reg2 int i;
  DBUG_ENTER("my_newwin");

  if ((win=newwin(num_lines, num_columns, begy, begx)) != 0)
    open_windows[open_index++]=win;

  WNOUTREFRESH(stdscr);				/* refresh on bottom screens */
  for (i= 0 ; i < open_index-1 ; i++)
    WNOUTREFRESH(open_windows[i]);
  DBUG_RETURN(win);
} /* my_newwin */


	/* Delete window and make screen look ok */

void my_delwin(win)
reg2 WINDOW *win;
{
  reg1 int i;
  DBUG_ENTER("my_delwin");

  delwin(win);					/* Remove window */
  for (i=open_index-1 ; i >=0 ; i--)
  {
    if (open_windows[i] == win)
    {
      open_index--;
      memcpy((byte*) &open_windows[i],(byte*) &open_windows[i+1],
	     sizeof(WINDOW*)*(open_index-i));
      my_touchwindows();
    }
  }
  DBUG_VOID_RETURN;
} /* my_delwin */


	/* touch all windows to make screen look ok */

void my_touchwindows()
{
  reg1 int i;
  DBUG_ENTER("my_touchwindows");

  touchwin(stdscr); WNOUTREFRESH(stdscr);		/* stdscr at bottom */
  for (i= 0 ; i < open_index ; i++)
  {
    touchwin(open_windows[i]);
    WNOUTREFRESH(open_windows[i]);
  }
  DBUG_VOID_RETURN;
} /* my_touchwindows */


	/* Make a refresh for window on top */

void my_refresh()
{
  DBUG_ENTER("my_refresh");
  if (mysys_uses_curses)
  {					/* If we are allowed to use curses */
    if (open_index)
      wrefresh(open_windows[open_index-1]);
    else
      refresh();
  }
  DBUG_VOID_RETURN;
} /* my_refresh */


	/* When insertnl doesn't work */

#ifdef VMS

my_winsertln(win)
WINDOW *win;
{
  register int col,max_row;
  int min_row,cols,chr;

  getyx(win,min_row,cols);		/* Insert from current row */
  max_row=win->_max_y; cols=win->_max_x;

  while (--max_row  > min_row)
    for (col=0 ; col < cols ; col++)
    {
      wmove(win,max_row-1,col); chr=winch(win);
      wmove(win,max_row,col); waddch(win,chr);
    }
  wmove(win,min_row,0); wclrtoeol(win);
} /* my_winsertln */
#endif
