/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
  This functions is to read a bunch of records in one read from a (locked?)
  database for quick access when reading in postion order.
  Uses asyncronic io if database is locked.
  init_record_cash() is to init cash_handler.
  read_cash_record() reads a record to buffert.
  end_record_cash() frees cash-memory.
  This is obsolite; Its only used with M-ISAM and P-ISAM.
 */

#include "mysys_priv.h"
#include <m_string.h>
#include "my_nosys.h"

#ifdef HAVE_ASYNC_IO
#undef HAVE_ASYNC_IO			/* Don't get new bugs in old code */
#endif

	/* if cashsize == 0 then use default cashsize (from s-file) */
	/* returns 0 if we have enough memory */

int init_record_cash(info,cashsize,file,reclength,type,use_async_io)
RECORD_CASH *info;
uint cashsize,reclength;
File file;
enum cash_type type;
pbool use_async_io __attribute__((unused));
{
  uint count;
  DBUG_ENTER("init_record_cash");

  info->file=file;
  if (cashsize == 0)
    cashsize= my_default_record_cash_size;
  for (;;)
  {
    if ((count=((cashsize-1)/reclength & (uint) ~1)) <= 1)
    {
      info->rc_length=0;			/* Set for test if cashing */
      info->rc_record_pos=INT_MAX32;
      DBUG_RETURN(2);				/* No nead for cashing */
    }
    info->rc_length=count*reclength;
    if ((info->rc_buff= (byte*) my_malloc(info->rc_length+1,MYF(0))) != 0)
      break;					/* Enough memory found */
    cashsize= (uint) ((long) cashsize*3/4);	/* Try with less memory */
  }
  info->rc_record_pos=0L;
  info->rc_seek=1;
  info->rc_end= (type == READ_CASH ? info->rc_buff :
		 info->rc_buff+info->rc_length);
  info->rc_pos=info->rc_end;
  info->read_length=info->rc_length;
  info->reclength=reclength;
  info->end_of_file=INT_MAX32;			/* May be changed by user */
  info->type=type;
  info->error=info->inited=0;
#ifdef HAVE_ASYNC_IO
  if ((info->use_async_io=(int) use_async_io))
  {
    info->rc_request_pos=info->rc_buff;
    info->read_length/=2;
    info->rc_buff2=info->rc_buff+info->read_length;
  }
  info->inited=info->aio_result.pending=0;
#endif
  DBUG_RETURN(0);
} /* init_record_cash */


#ifdef HAVE_ASYNC_IO
static void my_aiowait(result)
my_aio_result *result;
{
  if (result->pending)
  {
    struct aio_result_t *tmp;
    for (;;)
    {
      if ((int) (tmp=aiowait((struct timeval *) 0)) == -1)
      {
	if (errno == EINTR)
	  continue;
	DBUG_PRINT("error",("No aio request, error: %d",errno));
	tmp->aio_errno=errno;
	result->pending=0;			/* Assume everythings is ok */
	break;
      }
      ((my_aio_result*) tmp)->pending=0;
      if ((my_aio_result*) tmp == result)
	break;
    }
  }
  return;
}
#endif

	/* Returns 0 if record read */

int read_cash_record(info,to)
reg1 RECORD_CASH *info;
byte *to;					/* Read record here */
{
  uint length;
  long max_length;

  for ( ;; )					/* Instead of tail-recursion */
  {
#ifdef MSDOS					/* MSDOS and segments !!! */
    if ((ulong) info->rc_pos+(ulong) info->reclength <= (ulong) info->rc_end)
#else
    if (info->rc_pos+info->reclength <= info->rc_end)
#endif
    {						/* Record in cash */
      memcpy(to,info->rc_pos,(size_t) info->reclength);
      info->rc_pos+=info->reclength;
      info->rc_record_pos+=info->reclength;
      return 0;
    }
    if (info->rc_pos != info->rc_end)
    {
      info->error=0;				/* Not actual error */
      return 2;					/* End of file, chars left */
    }
#ifdef HAVE_ASYNC_IO
    if (info->inited)
    {				/* wait for read block */
      info->inited=0;
      my_aiowait(&info->aio_result);
      if (info->aio_result.aio_errno)
      {
	my_errno(info->aio_result.aio_errno);
	return(info->aio_result.aio_errno);
      }
      if (! (length=info->aio_result.aio_return) || length == (uint) -1)
      {
	info->error=(int) length;
	return(1);
      }
      info->rc_pos=info->rc_request_pos;
      info->rc_end=info->rc_pos+length;
    }
    else
#endif
    {
      max_length=(long) (info->end_of_file - info->rc_record_pos);
      if (max_length > (long) info->read_length)
	max_length=(long) info->read_length;
      if (info->rc_seek)
      {						/* File touched, do seek */
	VOID(my_seek(info->file,info->rc_record_pos,MY_SEEK_SET,MYF(0)));
	info->rc_seek=0;
      }
      if ((length=my_read(info->file,info->rc_buff,(uint) max_length,
			   MYF(0))) == 0 ||
	  length == (uint) -1)
      {
	info->error= (int) length;			/* Got error */
	return 1;
      }
      info->rc_pos=info->rc_buff;
      info->rc_end=info->rc_buff+length;
#ifdef HAVE_ASYNC_IO
      if (! info->use_async_io)
	continue;
#endif
    }

	/* Read next block with asyncronic io */
#ifdef HAVE_ASYNC_IO
    max_length=info->end_of_file - info->rc_record_pos - length;
    if (max_length > (long) info->read_length)
      max_length=(long) info->read_length;
    if (info->rc_request_pos != info->rc_buff)
      info->rc_request_pos=info->rc_buff;
    else
      info->rc_request_pos=info->rc_buff2;
    info->aio_result.aio_errno=AIO_INPROGRESS;
    if (!aioread(info->file,info->rc_request_pos,max_length,
		 info->rc_record_pos+length,MY_SEEK_SET,
		 &info->aio_result.result))
    {							/* Skipp async io */
      info->inited=info->use_async_io=0;
      info->read_length=info->rc_length;		/* Use hole buffer */
    }
    else
      info->inited=info->aio_result.pending=1;
#endif
  }
} /* read_cash_record */


int end_record_cash(info)
RECORD_CASH *info;
{
  int error=0;
  DBUG_ENTER("end_record_cash");
  if (info->rc_buff)
  {
    if (info->type == WRITE_CASH)
      error=flush_write_cash(info);
#ifdef HAVE_ASYNC_IO
    else
      my_aiowait(&info->aio_result);
#endif
    my_free((gptr) info->rc_buff,MYF(MY_WME));
    info->rc_buff=NullS;
    info->rc_length=0;
  }
  DBUG_RETURN(error);
} /* end_record_cash */


	/* Returns != 0 if error on write */

int write_cash_record(info,filepos,record,length)
reg1 RECORD_CASH *info;
ulong filepos;
const byte *record;
uint length;
{
  uint rest_length;
  if (!info->rc_length)			/* Write with no cash */
    return test(my_write(info->file,record,length,
			 MYF(MY_NABP | MY_WAIT_IF_FULL)));

#ifdef MSDOS				/* MSDOS and segments !!! */
  if ((ulong) info->rc_pos+(ulong) length > (ulong) info->rc_end)
#else
  if (info->rc_pos+length > info->rc_end)
#endif
  {
    rest_length=(uint) (info->rc_end - info->rc_pos);

    memcpy(info->rc_pos,record,(size_t) rest_length);
    record+=rest_length;
    length-=rest_length;
    info->rc_pos+=rest_length;
    info->rc_record_pos+=rest_length;
    if (flush_write_cash(info))
      return 1;
    info->inited=1;
    info->rc_pos=info->rc_buff;
    info->rc_record_pos=filepos;
  }
  if (length > info->rc_length)
  {					/* Probably using blobs */
    return test(my_write(info->file,record,length,
			 MYF(MY_NABP | MY_WAIT_IF_FULL)));
  }
  memcpy(info->rc_pos,record,(size_t) length);
  info->rc_pos+=length;
  info->rc_record_pos+=length;
  return 0;
} /* write_cash_record */


	/* Flush write cash */

int flush_write_cash(info)
RECORD_CASH *info;
{
  uint length;
  if (info->inited)
  {
    length=(uint) (info->rc_pos - info->rc_buff);
    if (info->rc_seek)
    {						/* File touched, do seek */
      VOID(my_seek(info->file,info->rc_record_pos-length,MY_SEEK_SET,MYF(0)));
      info->rc_seek=0;
    }
    info->inited=0;
    info->rc_pos=info->rc_end;
    return test(my_write(info->file,info->rc_buff,length,
			 MYF(MY_NABP | MY_WAIT_IF_FULL)));
  }
  else
    info->rc_seek=1;		/* We are here again after flush - seek may */
				/* be neaded */
  return 0;
} /* flush_write_cash */
