/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

#include "mysys_priv.h"
#include <m_string.h>
#ifdef MSDOS
#include <io.h>
#endif

static char *find_file_in_path _A((char *to,const char *name));

	/* Finds where program can find it's files.
	   pre_pathname is found by first locking at progname (argv[0]).
	   if progname contains path the path is returned.
	   else if progname is found in path, return it
	   else if progname is given and POSIX environmentvariable "_" is set
	   then path is taken from "_".
	   If filename doesn't contain a path append MY_BASEDIR_VERSION or
	   MY_BASEDIR if defined, else append "/my/running".
	   own_path_name_part is concatinated to result.
	   my_path puts result in to and returns to */

string my_path(to, progname, own_pathname_part)
  string to;					/* Put output here */
  const char *progname;				/* May be NullS */
  const char *own_pathname_part;		/* Put this after path */
{
  string start,end,prog;
  DBUG_ENTER("my_path");

  start=to;					/* Return this */
  if (progname && (dirname(to, progname) ||
		   find_file_in_path(to,progname) ||
		   ((prog=getenv("_")) != 0 && dirname(to,prog))))
  {
    VOID(intern_filename(to,to));
    if (!test_if_hard_path(to))
    {
      if (!my_getwd(curr_dir,FN_REFLEN,MYF(0)))
	bchange(to,0,curr_dir,strlen(curr_dir),strlen(to)+1);
    }
  }
  else
  {
    if ((end = getenv("MY_BASEDIR_VERSION")) == 0 &&
	(end = getenv("MY_BASEDIR")) == 0)
      end="/my/running";
    VOID(intern_filename(to,end));
    to=strend(to);
    if (to != start && to[-1] != FN_LIBCHAR)
      *to++ = FN_LIBCHAR;
    VOID(strmov(to,own_pathname_part));
  }
  DBUG_PRINT("exit",("to: '%s'",start));
  DBUG_RETURN(start);
} /* my_path */


	/* Returns full load-path for a file */
	/* if path is a hard-path return path */
	/* if path starts with home-dir return path */
	/* if path starts with current dir or parent-dir unpack path */
	/* if prefix is null unpack prepend own_path_prefix if given */
	/* else unpack path according to current dir */

string my_load_path(to,path,own_path_prefix)
string to;
const char *path;
const char *own_path_prefix;
{
  DBUG_ENTER("my_load_path");
  DBUG_PRINT("enter",("path: %s  prefix: %d",path,own_path_prefix));

  if ((path[0] == FN_HOMELIB && path[1] == FN_LIBCHAR) ||
      test_if_hard_path(path))
    VOID(strmov(to,path));
  else if ((path[0] == FN_CURLIB && path[1] == FN_LIBCHAR) ||
	   (is_prefix((gptr) path,FN_PARENTDIR) &&
	    path[strlen(FN_PARENTDIR)] == FN_LIBCHAR) ||
	   ! own_path_prefix)
  {
    if (! my_getwd(to,(uint) (FN_REFLEN-strlen(path)),MYF(0)))
      VOID(strcat(to,path));
    else
      VOID(strmov(to,path));
  }
  else
    VOID(strxmov(to,own_path_prefix,path,NullS));
  DBUG_PRINT("exit",("to: %s",to));
  DBUG_RETURN(to);
} /* my_load_path */


	/* Test if hard pathname */
	/* Returns 1 if dirname is a hard path */

int test_if_hard_path(dir_name)
reg1 const char *dir_name;
{
  if (dir_name[0] == FN_HOMELIB && dir_name[1] == FN_LIBCHAR)
    return (home_dir != NullS && test_if_hard_path(home_dir));
  if (dir_name[0] == FN_LIBCHAR)
    return (TRUE);
#ifdef FN_DEVCHAR
  return (strchr(dir_name,FN_DEVCHAR) != 0);
#else
  return FALSE;
#endif
} /* test_if_hard_path */


	/* test if file without filename is found in path */
	/* Returns to if found and to has dirpart if found, else NullS */

#ifdef MSDOS
#define F_OK 0
#endif

static char *find_file_in_path(to,name)
char *to;
const char *name;
{
  char *path,*pos,dir[2];

  if (!(path=getenv("PATH")))
    return NullS;
  dir[0]=FN_LIBCHAR; dir[1]=0;

  for (pos=path ; pos=strchr(pos,':') ; path= ++pos)
  {
    if (path != pos)
    {
      VOID(strmov(strmov(strnmov(to,path,(uint) (pos-path)),dir),name));
      if (!access(to,F_OK))
      {
	to[(uint) (pos-path)+1]=0;	/* Return path only */
	return to;
      }
    }
  }
  return NullS;			/* File not found */
}
