/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

#include "myodbc.h"

/* Use own fields instead of sql fields */

void mysql_link_fields(MYSQL_RES *result,MYSQL_FIELD *fields,uint field_count)
{
  result->fields=fields;
  result->field_count=field_count;
  result->current_field=0;
}


void fix_result_types(STMT *stmt)
{
  MYSQL_RES *result=stmt->result;
  if ((stmt->odbc_types=(SWORD*) my_malloc(sizeof(SWORD)*result->field_count,
					   MYF(0))))
  {
    uint i;
    for (i=0 ; i < result->field_count ; i++)
    {
     MYSQL_FIELD *field=result->fields+i;
      stmt->odbc_types[i]=(SWORD) unireg_to_c_datatype(field);
    }
  }
}

	/* change a string + length to a zero terminated string */

char *fix_str(char *to,char *from,int length)
{
  if (!from)
    return "";
  if (length == SQL_NTS)
    return from;
  strmake(to,from,length);
  return to;
}


char *dupp_str(char *from,int length)
{
  char *to;
  if (!from)
    return my_strdup("",MYF(MY_WME));
  if (length == SQL_NTS)
    length=strlen(from);
  if ((to=my_malloc(length+1,MYF(MY_WME))))
  {
    memcpy(to,from,length);
    to[length]=0;
  }
  return to;
}

	/* Return 1 if from is a null pointer or a empty string */

bool empty_str(char *from,int length)
{
  if (!from)
    return 1;
  if (length == SQL_NTS)
    return from[0] == 0;
  return !length;
}

void remove_escape(char *name)
{
  char *to;
  for (to=name ; *name ; name++)
  {
    if (*name == '\\' && name[1])
      name++;
    *to++= *name;
  }
  *to=0;
}


RETCODE copy_result(DBC *dbc,UCHAR FAR *rgbValue,SWORD cbValueMax,
		    SWORD FAR *pcbValue,char *src)
{
  UCHAR FAR *dst=rgbValue; /* era char giovanni */
  if (!dst)
    return SQL_SUCCESS;
  while (cbValueMax--)
    if (! (*dst++ = *src++))
    {
      if (pcbValue)
        *pcbValue= (SWORD) (dst-1 - rgbValue);
      return SQL_SUCCESS;
    }
  *dst=0;
  if (pcbValue)
    *pcbValue=(SWORD) (dst- rgbValue);
  if (dbc)
    set_error(dbc,"01004","Data truncated");
  return SQL_SUCCESS_WITH_INFO;
}


RETCODE copy_lresult(DBC FAR *dbc,UCHAR FAR *rgbValue,SDWORD cbValueMax,
		     SDWORD FAR *pcbValue,char *src,uint src_length,ulong max_length)
{
  char *dst=(char*) rgbValue;
  uint length;
  if (max_length && (ulong) cbValueMax > max_length)
    cbValueMax=max_length;
  length=min(src_length,(uint) cbValueMax);
  if (pcbValue)
    *pcbValue=length;
  memcpy(dst,src,length);
  dst[length]=0;
  if ((uint) cbValueMax >= src_length ||
      ((ulong) cbValueMax == max_length && max_length))
    return SQL_SUCCESS;
  if (dbc)
    set_error(dbc,"01004","Data truncated");
  return SQL_SUCCESS_WITH_INFO;
}


RETCODE set_error(DBC FAR *dbc,char *state,char *message)
{
  DBUG_ENTER("set_error");
  DBUG_PRINT("error",("message: %s",message));
  strmov(dbc->sqlstate,state);
  strmov(mysql_error(&dbc->mysql),message);
  DBUG_RETURN(SQL_ERROR);
}


int unireg_to_sql_datatype(MYSQL_FIELD *field,char *buff,uint *c_length)
{
  *c_length=0;		/* Default (if not fixed size argument) */
  switch(field->type) {
  case FIELD_TYPE_DECIMAL:
    if (buff) strmov(buff,"decimal");
    return SQL_DECIMAL;
  case FIELD_TYPE_CHAR:
    if (buff) strmov(buff,"tinyint");
    *c_length=1;
    return SQL_TINYINT;
  case FIELD_TYPE_SHORT:
    if (buff) strmov(buff,"smallint");
    *c_length=2;
    return SQL_SMALLINT;
  case FIELD_TYPE_INT24:
    if (buff) strmov(buff,"mediumint");
    *c_length=4;
    return SQL_INTEGER;
  case FIELD_TYPE_LONG:
    if (buff) strmov(buff,"int");
    *c_length=4;
    return SQL_INTEGER;
  case FIELD_TYPE_LONGLONG:
    if (buff) strmov(buff,"bigint");
    *c_length=20;
    return SQL_BIGINT;
  case FIELD_TYPE_FLOAT:
    if (buff) strmov(buff,"float");
    *c_length=4;
    return SQL_REAL;
  case FIELD_TYPE_DOUBLE:
    if (buff) strmov(buff,"double");
    *c_length=8;
    return SQL_DOUBLE;
  case FIELD_TYPE_NULL:
    if (buff) strmov(buff,"null");
    return SQL_VARCHAR;
  case FIELD_TYPE_TIMESTAMP:
    if (buff) strmov(buff,"timestamp");
    *c_length=14;				/* 19970303100000 */
    return SQL_TIMESTAMP;
  case FIELD_TYPE_DATETIME:
    if (buff) strmov(buff,"datetime");
    *c_length=19;				/* 1997-03-03 10:00:00 */
    return SQL_TIMESTAMP;
  case FIELD_TYPE_DATE:
    if (buff) strmov(buff,"date");
    *c_length=10;				/* 1997-03-03 */
    return SQL_DATE;
  case FIELD_TYPE_TIME:
    if (buff) strmov(buff,"time");
    *c_length=8;				/* 10:00:00 */
    return SQL_TIME;
  case FIELD_TYPE_STRING:
    if (buff) strmov(buff,"char");
    return SQL_CHAR;
  case FIELD_TYPE_VAR_STRING:
    if (buff) strmov(buff,"varchar");
    return SQL_VARCHAR;
  case FIELD_TYPE_TINY_BLOB:
    if (buff) strmov(buff,"tinyblob");
    return SQL_LONGVARCHAR;
  case FIELD_TYPE_BLOB:
    if (buff) strmov(buff,"blob");
    return SQL_LONGVARCHAR;
  case FIELD_TYPE_MEDIUM_BLOB:
    if (buff) strmov(buff,"mediumblob");
    return SQL_LONGVARCHAR;
  case FIELD_TYPE_LONG_BLOB:
    if (buff) strmov(buff,"longblob");
    return SQL_LONGVARCHAR;
  }
}


int unireg_to_c_datatype(MYSQL_FIELD *field)
{
  switch(field->type) {
  default:
    return SQL_C_CHAR;
  case FIELD_TYPE_CHAR:
    return SQL_C_TINYINT;
  case FIELD_TYPE_SHORT:
    return SQL_C_SHORT;
  case FIELD_TYPE_INT24:
  case FIELD_TYPE_LONG:
    return SQL_C_LONG;
  case FIELD_TYPE_FLOAT:
    return SQL_C_FLOAT;
  case FIELD_TYPE_DOUBLE:
    return SQL_C_DOUBLE;
  case FIELD_TYPE_TIMESTAMP:
    return SQL_C_TIMESTAMP;
  case FIELD_TYPE_DATE:
    return SQL_C_DATE;
  case FIELD_TYPE_TIME:
    return SQL_C_TIME;
  }
}

int default_c_type(int sql_data_type)
{
  switch (sql_data_type) {
  case SQL_CHAR:
  case SQL_VARCHAR:
  case SQL_LONGVARCHAR:
  case SQL_DECIMAL:
  case SQL_NUMERIC:
  case SQL_BIGINT:
    return SQL_C_CHAR;
  case SQL_BIT:
    return SQL_C_BIT;
  case SQL_TINYINT:
    return SQL_C_TINYINT;
  case SQL_SMALLINT:
    return SQL_C_SHORT;
  case SQL_INTEGER:
    return SQL_C_LONG;
  case SQL_REAL:
  case SQL_FLOAT:
    return SQL_C_FLOAT;
  case SQL_DOUBLE:
    return SQL_C_DOUBLE;
  case SQL_BINARY:
  case SQL_VARBINARY:
  case SQL_LONGVARBINARY:
    return SQL_C_BINARY;
  case SQL_DATE:
    return SQL_C_DATE;
  case SQL_TIME:
    return SQL_C_TIME;
  case SQL_TIMESTAMP:
    return SQL_C_TIMESTAMP;
  }
}


/* convert a possible string to a data value */

ulong str_to_date(const char *str,uint length)
{
  uint field_length,year_length,digits,i,date[3];
  const char *pos;
  const char *end=str+length;
  for (; !isdigit(*str) && str != end ; str++) ;
  /*
  ** calculate first number of digits.
  ** If length= 4, 8 or >= 14 then year is of format YYYY
     (YYYY-MM-DD,  YYYYMMDD)
  */
  for (pos=str; pos != end && isdigit(*pos) ; pos++) ;
  digits= (uint) (pos-str);
  year_length= (digits == 4 || digits == 8 || digits >= 14) ? 4 : 2;
  field_length=year_length-1;

  for (i=0 ; i < 3 && str != end; i++)
  {
    uint tmp_value=(uint) (uchar) (*str++ - '0');
    while (str != end && isdigit(str[0]) && field_length--)
    {
      tmp_value=tmp_value*10 + (uint) (uchar) (*str - '0');
      str++;
    }
    date[i]=tmp_value;
    while (str != end && !isdigit(*str))
      str++;
    field_length=1;				// Rest fields can only be 2
  }
  if (date[0] == 0 && i <= 1)
    return 0;					// Only year == 0 given.
  while (i < 3)
    date[i++]=1;
  return (ulong) date[0]*10000L + (ulong) (date[1]*100 + date[2]);
}


/*****************************************************************************
** convert a time string to a (ulong) value.
** At least following formats are recogniced
** HHMMSS HHMM HH HH.MM.SS
** Return: HHMMSS
*****************************************************************************/

ulong str_to_time(const char *str,uint length)
{
  uint i,date[3];
  const char *end=str+length;
  for (; !isdigit(*str) && str != end ; str++) ;

  for (i=0 ; i < 3 && str != end; i++)
  {
    uint tmp_value=(uint) (uchar) (*str++ - '0');
    if (str != end && isdigit(str[0]))
    {
      tmp_value=tmp_value*10 + (uint) (uchar) (*str - '0');
      str++;
    }
    date[i]=tmp_value;
    while (str != end && !isdigit(*str))
      str++;
  }
  while (i < 3)
    date[i++]=0;
  return (ulong) date[0]*10000L + (ulong) (date[1]*100+date[2]);
}


#ifndef _UNIX_

/* Define functions that dosen't exist in a dll */

/* _exit is called by safemalloc, mystatic & my_malloc */

#ifndef WIN32
void exit(int exit)
{
	abort();
}
#endif

/* perror is called by dbug.c */

void perror(const char *str)
{
}

/* clock is called by dbug.c when profiling */

long clock(void)
{
  return 0L;
}

long getpid()
{
  return 0;
}

void my_init()
{}
#endif /* IS NOT UNIX */
