/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
** RESULTS.C - This is the ODBC sample driver code for
** returning results and information about results.
*/


#include "myodbc.h"
#include <m_ctype.h>
#define digit(A) ((int) (A - '0'))

RETCODE SQL_API sql_get_data(STMT *stm,SWORD fCType,PTR rgbValue,
			     SDWORD  cbValueMax, SDWORD FAR *pcbValue,
			     char *value,uint length);


//      This returns the number of columns associated with the database
//      attached to "hstmt".

RETCODE SQL_API SQLNumResultCols(HSTMT  hstmt, SWORD FAR *pccol)
{
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLNumResultCols");
  if (!stmt->result)
    *pccol=0;					/* No result */
  else
    *pccol=stmt->result->field_count;
  DBUG_PRINT("exit",("columns: %d",*pccol));
  DBUG_RETURN(SQL_SUCCESS);
}


//      Return information about the database column the user wants
//      information about.

RETCODE SQL_API SQLDescribeCol(HSTMT hstmt, UWORD icol, UCHAR FAR *szColName,
			       SWORD cbColNameMax, SWORD FAR *pcbColName,
			       SWORD FAR *pfSqlType, UDWORD FAR *pcbColDef,
			       SWORD FAR *pibScale, SWORD FAR *pfNullable)
{
  MYSQL_FIELD *field;
  STMT FAR *stmt=(STMT FAR*) hstmt;
  uint c_length;
  DBUG_ENTER("SQLDescribeCol");

  if (!stmt->result)
    DBUG_RETURN(set_error(stmt->dbc,"24000","Invalid cursor state"));
  mysql_field_seek(stmt->result,icol-1);
  field=mysql_fetch_field(stmt->result);
  *pfSqlType=unireg_to_sql_datatype(field,0,&c_length);
  *pcbColDef=field->max_length;
  if (pibScale)
    *pibScale=field->decimals;
  if (pfNullable)
    *pfNullable= field->flags & NOT_NULL_FLAG ? SQL_NO_NULLS : SQL_NULLABLE;

  DBUG_RETURN(copy_result(stmt->dbc,szColName,cbColNameMax,pcbColName,
			  field->name));
}



//      Returns result column descriptor information for a result set.

RETCODE SQL_API SQLColAttributes(HSTMT hstmt,UWORD icol,UWORD fDescType,
				 UCHAR FAR *rgbDesc, SWORD cbDescMax,
				 SWORD FAR *pcbDesc, SDWORD FAR *pfDesc)
{
  MYSQL_FIELD *field;
  STMT FAR *stmt=(STMT FAR*) hstmt;
  SWORD dummy;
  uint c_length;
  DBUG_ENTER("SQLColAttributes");
  DBUG_PRINT("enter",("type: %d",fDescType));

  if (!pcbDesc)
    pcbDesc= &dummy;

  if (!stmt->result)
    DBUG_RETURN(set_error(stmt->dbc,"24000","Invalid cursor state"));
  mysql_field_seek(stmt->result,icol-1);
  field=mysql_fetch_field(stmt->result);

  switch (fDescType) {
  case SQL_COLUMN_COUNT:
    *pfDesc= stmt->result->field_count;
    *pcbDesc=sizeof(int);
    break;
  case SQL_COLUMN_NAME:
    DBUG_RETURN(copy_result(stmt->dbc,rgbDesc,cbDescMax,pcbDesc,field->name));
  case SQL_COLUMN_TYPE:
    *pfDesc=unireg_to_sql_datatype(field,0,&c_length);
    *pcbDesc=sizeof(int);
    break;
  case SQL_COLUMN_DISPLAY_SIZE:
  case SQL_COLUMN_PRECISION:
    *pfDesc=field->max_length;
    *pcbDesc=sizeof(int);
    break;
  case SQL_COLUMN_LENGTH:
    (void) unireg_to_sql_datatype(field,0,&c_length);
    *pcbDesc=c_length;
    *pcbDesc=sizeof(int);
    break;
  case SQL_COLUMN_SCALE:
    *pfDesc=field->decimals;
    *pcbDesc=sizeof(int);
    break;
  case SQL_COLUMN_NULLABLE:
    *pfDesc= field->flags & NOT_NULL_FLAG ? SQL_NO_NULLS : SQL_NULLABLE;
    *pcbDesc=sizeof(int);
    break;
  case SQL_COLUMN_SEARCHABLE:
    *pfDesc= SQL_SEARCHABLE;
    *pcbDesc=sizeof(int);
    break;
  case SQL_COLUMN_UNSIGNED:
  case SQL_COLUMN_MONEY:
  case SQL_COLUMN_AUTO_INCREMENT:
  case SQL_COLUMN_CASE_SENSITIVE:
    *pfDesc= FALSE;
    *pcbDesc=sizeof(int);
    break;
  case SQL_COLUMN_UPDATABLE:
    *pfDesc = SQL_COLUMN_UPDATABLE;
    *pcbDesc= sizeof(int);
    break;
  case SQL_COLUMN_TYPE_NAME:
  {
    char buff[40];
    unireg_to_sql_datatype(field,buff,&c_length);
    DBUG_RETURN(copy_result(stmt->dbc,rgbDesc,cbDescMax,pcbDesc,buff));
  }
  case SQL_COLUMN_OWNER_NAME:
  case SQL_COLUMN_QUALIFIER_NAME:
    DBUG_RETURN(copy_result(stmt->dbc,rgbDesc,cbDescMax,pcbDesc,""));
  }
  DBUG_RETURN(SQL_SUCCESS);
}


//      Associate a user-supplied buffer with a database column.

RETCODE SQL_API SQLBindCol(HSTMT hstmt, UWORD icol, SWORD fCType, PTR rgbValue,
			   SDWORD  cbValueMax, SDWORD FAR *pcbValue)
{
  BIND *bind;
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLBindCol");
  DBUG_PRINT("enter",("icol: %d  Type: %d  ValueMax: %d  Valueptr: %d, Value: %d",
		      icol,fCType,cbValueMax,(pcbValue ? *pcbValue : 0),
		      pcbValue));
  if (!stmt->result || icol < 1 || icol > stmt->result->field_count)
  {
    DBUG_RETURN(set_error(stmt->dbc,"S1002","Invalid column number"));
  }
  if (!stmt->bind)
  {
    if (!(stmt->bind=(BIND*) my_malloc(sizeof(BIND)*stmt->result->field_count,
				       MYF(MY_ZEROFILL))))
      DBUG_RETURN(set_error(stmt->dbc,"S1001","Not enough memory"));
  }
  icol--;
  mysql_field_seek(stmt->result,icol);
  bind=stmt->bind+icol;
  bind->field=mysql_fetch_field(stmt->result);
  bind->fCType=(fCType == SQL_C_DEFAULT ? stmt->odbc_types[icol] : fCType);
  bind->rgbValue=rgbValue;
  bind->cbValueMax=cbValueMax;
  bind->pcbValue=pcbValue;
  DBUG_RETURN(SQL_SUCCESS);
}


//      Returns data for bound columns in the current row ("stmt->iCursor"),
//      advances the cursor.

RETCODE SQL_API SQLFetch(HSTMT hstmt)
{
  MYSQL_ROW values;
  RETCODE res,tmp_res;
  BIND *bind,*end;
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLFetch");

  if (!stmt->result)
    DBUG_RETURN(set_error(stmt->dbc,"24000","Fetch without a SELECT"));

  if (stmt->result_array)
  {
    if (stmt->current_row >= stmt->result->row_count)
      DBUG_RETURN(SQL_NO_DATA_FOUND);
    values=stmt->result_array+(stmt->current_row++)*
      stmt->result->field_count;
  }
  else
  {
    if (!(values=mysql_fetch_row(stmt->result)))
      DBUG_RETURN(SQL_NO_DATA_FOUND);
    if (stmt->fix_fields)
      values=(*stmt->fix_fields)(stmt,values);
    else
      stmt->result_lengths=mysql_fetch_lengths(stmt->result);
  }
  stmt->current_values=values;		/* For SQLGetData */

  res=SQL_SUCCESS;
  if (stmt->bind)
  {
    uint *lengths=stmt->result_lengths;
    for (bind=stmt->bind,end=bind + stmt->result->field_count ;
	 bind < end ;
	 bind++,values++)
    {
      if (bind->rgbValue)
      {

	if ((tmp_res=sql_get_data(stmt,bind->fCType,bind->rgbValue,
				  bind->cbValueMax,bind->pcbValue,
				  *values, lengths ? *lengths : *values ?
				  strlen(*values) : 0) )
	    != SQL_SUCCESS)
	{
	  if (tmp_res == SQL_SUCCESS_WITH_INFO)
	  {
	    if (res == SQL_SUCCESS)
	      res= tmp_res;
	  }
	  else
	    res=SQL_ERROR;
	}
      }
      if (lengths)
	lengths++;
    }
  }
  DBUG_RETURN(res);
}



//  Returns result data for a single column in the current row.

RETCODE SQL_API SQLGetData(HSTMT hstmt,UWORD icol,SWORD fCType,PTR rgbValue,
			   SDWORD  cbValueMax, SDWORD FAR *pcbValue)
{
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLGetData");

  if (!stmt->result || !stmt->current_values)
  {
    set_error(stmt->dbc,"24000","SQLGetData without a preceding SELECT");
    DBUG_RETURN(SQL_ERROR);
  }
  icol--;		  /* Easier code if start from 0 */
#ifdef LOG_ALL
  DBUG_PRINT("QQ",("icol: %d  fCType: %d  default: %d  value: %.10s",
		   icol+1,fCType,
		   stmt->odbc_types[icol],
		   (stmt->current_values[icol] ? stmt->current_values[icol] :
		    "NULL")));
#endif
  DBUG_RETURN(sql_get_data(stmt,
			   (SWORD) (fCType == SQL_C_DEFAULT ?
				    stmt->odbc_types[icol] :
				    fCType),
			   rgbValue,cbValueMax,pcbValue,
			   stmt->current_values[icol],
			   (stmt->result_lengths ? stmt->result_lengths[icol] :
			    (stmt->current_values[icol] ?
			     strlen(stmt->current_values[icol]) : 0 ))));
}


RETCODE SQL_API sql_get_data(STMT *stmt,SWORD fCType,PTR rgbValue,
		             SDWORD  cbValueMax, SDWORD FAR *pcbValue,
			     char *value, uint length)
{
  DBC *dbc=stmt->dbc;
  long tmp;
  if (!pcbValue)
    pcbValue= &tmp;	/* Easier code */

  if (!value)
  {
    *pcbValue=SQL_NULL_DATA;
    return SQL_SUCCESS;
  }
  switch (fCType) {
  case SQL_C_BINARY:
  case SQL_C_CHAR:
    return copy_lresult(dbc,(char*) rgbValue,cbValueMax,pcbValue,value,
			length,stmt->max_length);
  case SQL_C_BIT:
    *((char*) rgbValue)= (atoi(value) == 0 ? 0 : 1);
    *pcbValue=1;
    break;
  case SQL_C_TINYINT:
  case SQL_C_STINYINT:
    *((char*) rgbValue)= ((char) atoi(value));
    *pcbValue=1;
    break;
  case SQL_C_UTINYINT:
    *((uchar*) rgbValue)= ((uchar) (uint) atoi(value));
    *pcbValue=1;
    break;
  case SQL_C_SHORT:
  case SQL_C_SSHORT:
    *((short*) rgbValue)= (short) atoi(value);
    *pcbValue=sizeof(short);
    break;
  case SQL_C_USHORT:
    *((ushort*) rgbValue)= (ushort) (uint) atoi(value);
    *pcbValue=sizeof(short);
    break;
  case SQL_C_LONG:
  case SQL_C_SLONG:
    *((long*) rgbValue)= (long) atol(value);
    *pcbValue=sizeof(long);
    break;
  case SQL_C_ULONG:
    {
      char *end_ptr;
      *((ulong*) rgbValue)= strtoul(value,&end_ptr,10);
    }
    *pcbValue=sizeof(long);
    break;
  case SQL_C_FLOAT:
    *((float*) rgbValue)= (float) atof(value);
    *pcbValue=sizeof(float);
    break;
  case SQL_C_DOUBLE:
    *((double*) rgbValue)= (double) atof(value);
    *pcbValue=sizeof(double);
    break;
  case SQL_C_DATE:
  {
    ulong date=str_to_date(value,length);
    ((DATE_STRUCT *) rgbValue)->year=(SWORD) (date/10000L);
    ((DATE_STRUCT *) rgbValue)->month=(UWORD) (date/100%100);
    ((DATE_STRUCT *) rgbValue)->day=(UWORD) (date%100);
    *pcbValue=sizeof(DATE_STRUCT);
    break;
  }
  case SQL_C_TIME:
  {
    ulong time=str_to_time(value,length);
    ((TIME_STRUCT *) rgbValue)->hour=(UWORD) time/10000;
    ((TIME_STRUCT *) rgbValue)->minute=(UWORD) time/100%100;
    ((TIME_STRUCT *) rgbValue)->second=(UWORD) time%100;
    *pcbValue=sizeof(TIME_STRUCT);
    break;
  }
  case SQL_C_TIMESTAMP:
  {
    uint year;
    char buff[15],*to;

    for (to=buff ; *value && to < buff+sizeof(buff)-1 ; value++)
    {
      if (isdigit(*value))
	*to++ = *value;
    }
    if ((uint) (to-buff) < 14)
      strappend(to,14 - (uint) (to-buff),'0');
    else
      *to=0;
    year=(digit(buff[0])*1000+digit(buff[1])*100+digit(buff[2])*10+
	  digit(buff[3]));
    ((TIMESTAMP_STRUCT *) rgbValue)->year=   year;
    ((TIMESTAMP_STRUCT *) rgbValue)->month=  digit(buff[4])*10+digit(buff[5]);
    ((TIMESTAMP_STRUCT *) rgbValue)->day=    digit(buff[6])*10+digit(buff[7]);
    ((TIMESTAMP_STRUCT *) rgbValue)->hour=   digit(buff[8])*10+digit(buff[9]);
    ((TIMESTAMP_STRUCT *) rgbValue)->minute= digit(buff[10])*10+digit(buff[11]);
    ((TIMESTAMP_STRUCT *) rgbValue)->second= digit(buff[12])*10+digit(buff[13]);
    ((TIMESTAMP_STRUCT *) rgbValue)->fraction=0;
    *pcbValue=sizeof(TIMESTAMP_STRUCT);
    break;
  }
  }
  return SQL_SUCCESS;
}


//  This determines whether there are more results sets available for
//  the "hstmt".

RETCODE SQL_API SQLMoreResults(HSTMT  hstmt)
{
  DBUG_ENTER("SQLMoreResults");
  DBUG_RETURN(SQL_NO_DATA_FOUND);
}


//      This returns the number of rows associated with the database
//      attached to "hstmt".

RETCODE SQL_API SQLRowCount(HSTMT hstmt, SDWORD FAR *pcrow)
{
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLRowCount");
  *pcrow=mysql_affected_rows(&stmt->dbc->mysql);
  DBUG_PRINT("exit",("rows: %ld",*pcrow));
  DBUG_RETURN(SQL_SUCCESS);
}


//      This positions the cursor within a block of data.

RETCODE SQL_API SQLSetPos(HSTMT hstmt, UWORD irow, UWORD fRefresh, UWORD fLock)
{
  DBUG_ENTER("SQLSetPos");
  DBUG_RETURN(set_error(((STMT FAR*) hstmt)->dbc,"IM001",
			"This dosn't work yet"));
}


//      This fetchs a block of data (rowset).

RETCODE SQL_API SQLExtendedFetch(HSTMT hstmt, UWORD fFetchType, SDWORD irow,
				 UDWORD FAR *pcrow, UWORD FAR *rgfRowStatus)
{
  DBUG_ENTER("SQLExtendedFetch");
  DBUG_RETURN(set_error(((STMT FAR*) hstmt)->dbc,"IM001",
			"This dosn't work yet"));
}


//  Returns the next SQL error information.

RETCODE SQL_API SQLError(HENV henv, HDBC hdbc, HSTMT hstmt,
			 UCHAR FAR *szSqlState, SDWORD FAR *pfNativeError,
			 UCHAR FAR *szErrorMsg, SWORD cbErrorMsgMax,
			 SWORD FAR *pcbErrorMsg)
{
  char *errmsg;
  RETCODE error;
  SWORD tmp_size;
  DBUG_ENTER("SQLError");
  DBUG_PRINT("enter",("szErrorMsg: %lx",szErrorMsg));

  if (!pcbErrorMsg)
    pcbErrorMsg= &tmp_size;
  *pcbErrorMsg=0;
  if (!hstmt && !hdbc)
    goto no_error;
  if (hstmt)
    hdbc=(HDBC) ((STMT FAR*) hstmt)->dbc;
  if (!(errmsg=mysql_error(&((DBC FAR*) hdbc)->mysql))[0])
    goto no_error;
  strmov(szSqlState,((DBC FAR*) hdbc)->sqlstate);
  if (pfNativeError)
    *pfNativeError=1;
  DBUG_PRINT("error",("Message: %s",errmsg));
  if ((error=copy_result((DBC FAR*) 0,szErrorMsg,cbErrorMsgMax,pcbErrorMsg,
       "[TCX][MYODBC]")) == SQL_SUCCESS)
  {
    int start_length= *pcbErrorMsg;
    cbErrorMsgMax-= start_length;
    szErrorMsg+=    start_length;
    error=copy_result((DBC FAR*) 0,szErrorMsg,cbErrorMsgMax,pcbErrorMsg,
		     errmsg);
    *pcbErrorMsg+= start_length;
  }
  errmsg[0]=0;	/* Clear for next loop */
  DBUG_RETURN(error);
no_error:
  if (cbErrorMsgMax)
    *szErrorMsg=0;
  if (szSqlState)
    strmov(szSqlState,"00000");
  DBUG_RETURN(SQL_NO_DATA_FOUND);
}
