/*   This file is public domain and comes with NO WARRANTY of any kind */
#undef LOG_ALL

#ifndef _UNIX_
#ifndef WINVER
#define WINVER 0x0400	/* prevent Windows 3.1 feature usage */
#include "windows.h"
#endif
#include  <windowsx.h>	/* message crackers */
#endif /* IS NOT UNIX */

#ifdef __cplusplus
extern "C"
{
#endif
#ifdef RC_INVOKED
#define stdin			/* Don't include stdio */
#endif
#include <global.h>
#include <mysql.h>
#include <my_sys.h>
#include <list.h>
#include <m_string.h>
#ifdef __cplusplus
}
#endif

#ifndef _UNIX_
#ifndef RC_INVOKED
#pragma pack(1)
#endif
/* #include "w16macro.h" */
#include "sql.h"
#include "sqlext.h"
#endif /* IS NOT UNIX */

#ifdef _UNIX_
#include <isql.h>
#include <isqlext.h>
#include <odbc_types.h>
#include <odbc_funcs.h>
#endif /* IS UNIX */

#ifdef WIN32
#define INTFUNC  __stdcall
#define EXPFUNC  __stdcall
#else
#define INTFUNC PASCAL
#define EXPFUNC __export CALLBACK
#endif

#define DRIVER_VERSION "1.00.0017"
#define MYSQL_RESET_BUFFERS 1000 /* Intern param to SQLFreeStmt */
#define MYSQL_RESET	    1001 /* Intern param to SQLFreeStmt */

#define x_free(A) { gptr tmp=(gptr) (A); if (tmp) my_free(tmp,MYF(MY_WME+MY_FAE)); }

//  Environment information.  This is allocated by "SQLAllocEnv".

typedef	struct	tagENV {
  short   DummyEntry;
} ENV;


// Database connection information.  This is allocated by "SQLAllocConnect".


typedef struct tagDBC {
  ENV *env;
  MYSQL mysql;
  char *database,*user,*password,*server,sqlstate[5];
  uint port;
  LIST *statements;
} DBC;


//  Statment information.  This is allocated by "SQLAllocStmt".

typedef struct st_bind {
  MYSQL_FIELD *field;
  SWORD fCType;
  PTR	rgbValue;				/* Save data here */
  SDWORD cbValueMax;
  SDWORD FAR *pcbValue;
  LIST list;
} BIND;

typedef struct st_param_bind {
  SWORD SqlType,CType;
  gptr buffer;
  char *pos_in_query,*value;
  SDWORD ValueMax,*actual_len,value_length;
  bool alloced,used;
} PARAM_BIND;


typedef struct	tagSTMT {
  DBC FAR *dbc;
  MYSQL_RES *result;
  uint current_row;
  ulong max_rows,max_length;
  uint *order,order_count,param_count,current_param,*result_lengths;
  MYSQL_ROW array,result_array,current_values;
  MYSQL_ROW (*fix_fields)(struct tagSTMT FAR* stmt,MYSQL_ROW row);
  MYSQL_FIELD *fields;
  DYNAMIC_ARRAY params;			/* For SQLBindParamter */
  BIND *bind;				/* For SQLBindCol */
  SWORD *odbc_types;			/* sql types for fields */
  char *query,*query_end;
  LIST list;
} STMT;


extern HANDLE NEAR s_hModule;	// DLL handle.


//	Resource defines for "SQLDriverConnect" dialog box.

#define	ID_LISTBOX	100
#define CONFIGDSN	1001
#define CONFIGDEFAULT	1002
#define EDRIVERCONNECT	1003


/* Functions in utility.c */

void mysql_link_fields(MYSQL_RES *result,MYSQL_FIELD *fields,uint field_count);
void fix_result_types(STMT *stmt);
char *fix_str(char *to,char *from,int length);
char *dupp_str(char *from,int length);
bool empty_str(char *from,int length);
RETCODE copy_result(DBC FAR *dbc,UCHAR FAR *rgbValue,SWORD cbValueMax,
		    SWORD FAR *pcbValue,char *src);
RETCODE copy_lresult(DBC FAR *dbc,UCHAR FAR *rgbValue,SDWORD cbValueMax,
		     SDWORD FAR *pcbValue,char *src,uint src_length,ulong max_length);
void remove_escape(char *name);
RETCODE set_error(DBC FAR *dbc,char *state,char *message);
int unireg_to_sql_datatype(MYSQL_FIELD *field,char *buff,uint *c_length);
int unireg_to_c_datatype(MYSQL_FIELD *field);
int default_c_type(int sql_data_type);
ulong str_to_date(const char *str,uint length);
ulong str_to_time(const char *str,uint length);
void init_getfunctions(void);
