/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
** INFO.C - This is the ODBC sample driver code for
** executing information functions.
*/

#include "myodbc.h"
#include <m_ctype.h>

RETCODE SQL_API SQLGetInfo(HDBC hdbc, UWORD fInfoType, PTR rgbInfoValue,
			   SWORD cbInfoValueMax, SWORD FAR *pcbInfoValue)
{
  DBC FAR *dbc=(DBC FAR*) hdbc;
  SWORD dummy;
  DBUG_ENTER("SQLGetInfo");
  DBUG_PRINT("enter",("fInfoType: %d",fInfoType));

  if (!pcbInfoValue)
    pcbInfoValue=&dummy;
  switch (fInfoType) {
  case SQL_MAX_USER_NAME_LEN:
#ifndef _UNIX_
    *(UNALIGNED SWORD FAR *) rgbInfoValue = 16;
#endif /* IS NOT UNIX */

#ifdef _UNIX_
    *(SWORD FAR *) rgbInfoValue = 16;
#endif /* IS UNIX */
    break;
  case SQL_DRIVER_ODBC_VER:
    lstrcpy(rgbInfoValue, SQL_SPEC_STRING);
    break;
  case SQL_ACTIVE_CONNECTIONS:
  case SQL_ACTIVE_STATEMENTS:
    *((SWORD*) rgbInfoValue)=0;			/* No limits */
    break;
  case SQL_DATA_SOURCE_NAME:
  case SQL_DATABASE_NAME:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,dbc->database,
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_DRIVER_NAME:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,"myodbc.dll",
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_DRIVER_VER:
  case SQL_DBMS_VER:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,DRIVER_VERSION,
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_FETCH_DIRECTION:
    *((long*) rgbInfoValue)=0L;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_ODBC_VER:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,DRIVER_VERSION,cbInfoValueMax)
			   - (char*) rgbInfoValue);
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_ODBC_SAG_CLI_CONFORMANCE:
    *((SWORD*) rgbInfoValue)=SQL_OSCC_COMPLIANT;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_SERVER_NAME:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,dbc->mysql.host_info,
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_SEARCH_PATTERN_ESCAPE:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,"\\",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_ODBC_SQL_CONFORMANCE:
  case SQL_ODBC_API_CONFORMANCE:
    *((SWORD*) rgbInfoValue)=SQL_OAC_LEVEL1;	/* Lie to make things work */
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_DBMS_NAME:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,"mysql",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_ROW_UPDATES:
  case SQL_ACCESSIBLE_PROCEDURES:
  case SQL_PROCEDURES:
  case SQL_OUTER_JOINS:
  case SQL_EXPRESSIONS_IN_ORDERBY:
  case SQL_NEED_LONG_DATA_LEN:
  case SQL_DATA_SOURCE_READ_ONLY:
  case SQL_ODBC_SQL_OPT_IEF:
  case SQL_LIKE_ESCAPE_CLAUSE:
  case SQL_ORDER_BY_COLUMNS_IN_SELECT:
   *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,"N",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_COLUMN_ALIAS:
  case SQL_ACCESSIBLE_TABLES:
  case SQL_MULT_RESULT_SETS:
  case SQL_MULTIPLE_ACTIVE_TXN:
  case SQL_MAX_ROW_SIZE_INCLUDES_LONG:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,"Y",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;

  case SQL_CONCAT_NULL_BEHAVIOR:
    *((SWORD*) rgbInfoValue)=SQL_CB_NULL;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_CURSOR_COMMIT_BEHAVIOR:		/* Lie */
  case SQL_CURSOR_ROLLBACK_BEHAVIOR:
    *((SWORD*) rgbInfoValue)=SQL_CB_PRESERVE;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_DEFAULT_TXN_ISOLATION:
    *((long*) rgbInfoValue)= SQL_TXN_READ_UNCOMMITTED;
    *pcbInfoValue=sizeof(long);
   break;
  case SQL_IDENTIFIER_CASE:
    *((SWORD*) rgbInfoValue)=SQL_IC_MIXED;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_IDENTIFIER_QUOTE_CHAR:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue," ",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_MAX_COLUMN_NAME_LEN:
   *((SWORD*) rgbInfoValue)=NAME_LEN;
   *pcbInfoValue=sizeof(SWORD);
   break;
  case SQL_MAX_CURSOR_NAME_LEN:
  case SQL_MAX_OWNER_NAME_LEN:
  case SQL_MAX_PROCEDURE_NAME_LEN:
  case SQL_MAX_QUALIFIER_NAME_LEN:
    *((SWORD*) rgbInfoValue)=0;
    break;
  case SQL_MAX_TABLE_NAME_LEN:
    *((SWORD*) rgbInfoValue)=NAME_LEN;
    break;
  case SQL_OWNER_TERM:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,"owner",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_PROCEDURE_TERM:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,"procedure",
				   cbInfoValueMax) - (char*) rgbInfoValue);
    break;
  case SQL_QUALIFIER_NAME_SEPARATOR:		/* what should this be */
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,",",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_QUALIFIER_TERM:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,"database",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_SCROLL_CONCURRENCY:
  case SQL_SCROLL_OPTIONS:
    *((long*) rgbInfoValue)=0L;
    break;
  case SQL_TABLE_TERM:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,"table",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_TXN_CAPABLE:
    *((SWORD*) rgbInfoValue)=SQL_TC_NONE;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_USER_NAME:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,"user",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_CONVERT_FUNCTIONS:
    *((long*) rgbInfoValue)=0L;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_SYSTEM_FUNCTIONS:
    *((long*) rgbInfoValue)= SQL_FN_SYS_DBNAME | SQL_FN_SYS_IFNULL | SQL_FN_SYS_USERNAME;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_NUMERIC_FUNCTIONS:
    *((long*) rgbInfoValue)=SQL_FN_NUM_ABS | SQL_FN_NUM_CEILING	| SQL_FN_NUM_EXP | SQL_FN_NUM_FLOOR |
      SQL_FN_NUM_LOG | SQL_FN_NUM_LOG10	| SQL_FN_NUM_MOD | SQL_FN_NUM_POWER | SQL_FN_NUM_SIGN |
      SQL_FN_NUM_SQRT | SQL_FN_NUM_RAND | SQL_FN_NUM_ROUND ;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_STRING_FUNCTIONS:
    *((long*) rgbInfoValue)=SQL_FN_STR_CONCAT | SQL_FN_STR_LEFT | SQL_FN_STR_LENGTH |
      SQL_FN_STR_LOCATE | SQL_FN_STR_RIGHT | SQL_FN_STR_SUBSTRING | SQL_FN_STR_REPLACE |
      SQL_FN_STR_LCASE | SQL_FN_STR_UCASE | SQL_FN_STR_INSERT | SQL_FN_STR_LTRIM | SQL_FN_STR_RTRIM;
    *pcbInfoValue=sizeof(long);
     break;
  case SQL_TIMEDATE_FUNCTIONS:
    *((long*) rgbInfoValue)=SQL_FN_TD_CURDATE;
    *pcbInfoValue=sizeof(long);
    break;

  case SQL_CONVERT_BIGINT:
  case SQL_CONVERT_BIT:
  case SQL_CONVERT_CHAR:
  case SQL_CONVERT_DATE:
  case SQL_CONVERT_DECIMAL:
  case SQL_CONVERT_DOUBLE:
  case SQL_CONVERT_FLOAT:
  case SQL_CONVERT_INTEGER:
  case SQL_CONVERT_LONGVARCHAR:
  case SQL_CONVERT_NUMERIC:
  case SQL_CONVERT_REAL:
  case SQL_CONVERT_SMALLINT:
  case SQL_CONVERT_TIME:
  case SQL_CONVERT_TIMESTAMP:
  case SQL_CONVERT_TINYINT:
  case SQL_CONVERT_VARCHAR:
     /* lie that we can handle anything */
    *((long*) rgbInfoValue)=SQL_CVT_CHAR | SQL_CVT_NUMERIC | SQL_CVT_DECIMAL |
      SQL_CVT_INTEGER | SQL_CVT_SMALLINT | SQL_CVT_FLOAT | SQL_CVT_REAL |
      SQL_CVT_DOUBLE | SQL_CVT_VARCHAR | SQL_CVT_LONGVARCHAR |
      SQL_CVT_BIT | SQL_CVT_TINYINT | SQL_CVT_BIGINT |
      SQL_CVT_DATE | SQL_CVT_TIME | SQL_CVT_TIMESTAMP;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_CONVERT_BINARY:
  case SQL_CONVERT_VARBINARY:
  case SQL_CONVERT_LONGVARBINARY:
  case SQL_POS_OPERATIONS:	    /* No SQLSetPos */
  case SQL_POSITIONED_STATEMENTS:
  case SQL_LOCK_TYPES:
  case SQL_BOOKMARK_PERSISTENCE:
  case SQL_ALTER_TABLE:
  case SQL_OWNER_USAGE:
  case SQL_QUALIFIER_USAGE:
  case SQL_QUOTED_IDENTIFIER_CASE:
  case SQL_SUBQUERIES:
  case SQL_UNION:
  case SQL_TIMEDATE_ADD_INTERVALS:
  case SQL_TIMEDATE_DIFF_INTERVALS:
    *((long*) rgbInfoValue)=0L;
    *pcbInfoValue=sizeof(long);
   break;
  case SQL_CORRELATION_NAME:
    *((SWORD*) rgbInfoValue)=SQL_CN_DIFFERENT;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_NON_NULLABLE_COLUMNS:
    *((SWORD*) rgbInfoValue)=SQL_NNC_NON_NULL;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_NULL_COLLATION:
    *((SWORD*) rgbInfoValue)=SQL_NC_START;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_MAX_COLUMNS_IN_GROUP_BY:
  case SQL_MAX_COLUMNS_IN_ORDER_BY:
  case SQL_MAX_COLUMNS_IN_SELECT:
  case SQL_MAX_COLUMNS_IN_TABLE:
  case SQL_MAX_TABLES_IN_SELECT:
  case SQL_MAX_ROW_SIZE:
    *((SWORD*) rgbInfoValue)=0;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_MAX_BINARY_LITERAL_LEN:
  case SQL_MAX_CHAR_LITERAL_LEN:
    *((long*) rgbInfoValue)=0;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_MAX_COLUMNS_IN_INDEX:
    *((SWORD*) rgbInfoValue)=16;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_MAX_INDEX_SIZE:
    *((long*) rgbInfoValue)=120;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_MAX_STATEMENT_LEN:
    *((long*) rgbInfoValue)=net_buffer_length;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_QUALIFIER_LOCATION:
    *((SWORD*) rgbInfoValue)=SQL_QL_START;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_GETDATA_EXTENSIONS:
   *((long*) rgbInfoValue)= SQL_GD_ANY_COLUMN | SQL_GD_ANY_ORDER | SQL_GD_BOUND;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_STATIC_SENSITIVITY:
   *((long*) rgbInfoValue)=SQL_SS_DELETIONS | SQL_SS_UPDATES;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_FILE_USAGE:
    *((SWORD*) rgbInfoValue)=SQL_FILE_NOT_SUPPORTED;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_GROUP_BY:
    *((SWORD*) rgbInfoValue)=SQL_GB_GROUP_BY_EQUALS_SELECT;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_KEYWORDS:
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,
				   "UNIQUE,ZEROFILL,UNSIGNED,BIGINT,BLOB,TINYBLOB,MEDIMUMBLOB,LONGBLOB,MEDIUMINT,PROCEDURE,SHOW,LIMIT,DEFAULT,TABLES,REGEXP,RLIKE,KEYS",
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_SPECIAL_CHARACTERS:
  {
    *pcbInfoValue=(SWORD) (strmake((char*) rgbInfoValue,
				   "",
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
     break;
  }
  default:
  {
    char buff[80];
    sprintf(buff,"Unsupported option: %d to SQLGetInfo",fInfoType);
    DBUG_RETURN(set_error(dbc,"S1C00",buff));
  }
  }
  DBUG_RETURN(SQL_SUCCESS);
}



/*
**	Function sets up a result set containing details of the types
**	supported by mysql.
*/

MYSQL_FIELD SQL_GET_TYPE_INFO_fields[] = {
  {"Type_name","GetTypeInfo",NULL,FIELD_TYPE_STRING,32,32,NOT_NULL_FLAG},
  {"Data_Type","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"Precision","GetTypeInfo",NULL,FIELD_TYPE_LONG,10,10},
  {"Literal_prefix","GetTypeInfo",NULL,FIELD_TYPE_STRING,1,1},
  {"Literal_suffix","GetTypeInfo",NULL,FIELD_TYPE_STRING,1,1},
  {"Create_params","GetTypeInfo",NULL,FIELD_TYPE_STRING,15,15},
  {"Nullable","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"Case_sensitive","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"Searchable","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"Unsigned_attribute","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2},
  {"Money","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"Auto_increment","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2},
  {"Local_type_name","GetTypeInfo",NULL,FIELD_TYPE_STRING,60,60},
  {"Minimum_scale","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2},
  {"Maximum_scale","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2},
};

const uint SQL_GET_TYPE_INFO_FIELDS=array_elements(SQL_GET_TYPE_INFO_fields);

#define MYSQL_DATA_TYPES 29

char sql_searchable[6],sql_unsearchable[6],sql_nullable[6],sql_no_nulls[6],sql_bit[6],
     sql_tinyint[6],sql_smallint[6],sql_integer[6],sql_bigint[6],sql_float[6],
     sql_real[6],sql_double[6], sql_char[6],sql_varchar[6],sql_longvarchar[6],
     sql_timestamp[6], sql_decimal[6],sql_numeric[6],sql_varbinary[6],
     sql_time[6],sql_date[6];

char *SQL_GET_TYPE_INFO_values[MYSQL_DATA_TYPES][15]=
{
  {"tinyint",sql_bit,"3",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","Tiny integer",NULL,NULL},

  {"tinyint",sql_tinyint,"3",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","Tiny integer",NULL,NULL},
  {"tinyint unsigned",sql_tinyint,"3",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"1","0","0","Tiny integer unsigned",NULL,NULL},

  {"smallint",sql_smallint,"5",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","Short integer",NULL,NULL},
  {"smallint unsigned",sql_smallint,"5",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"1","0","0","Short integer unsigned",NULL,NULL},

  {"middleint",sql_integer,"8",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","Medium integer",NULL,NULL},
  {"middleint unsigned",sql_integer,"8",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"1","0","0","Medium integer unsigned",NULL,NULL},

  {"int",sql_integer,"10",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","integer",NULL,NULL},
  {"int unsigned",sql_integer,"10",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"1","0","0","integer unsigned",NULL,NULL},

  {"integer",sql_integer,"10",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","Integer",NULL,NULL},
  {"integer unsigned",sql_integer,"10",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"1","0","0","Integer unsigned",NULL,NULL},

  {"bigint",sql_bigint,"20",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","Longlong integer",NULL,NULL},
  {"bigint unsigned",sql_bigint,"20",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"1","0","0","Longlong integer unsigned",NULL,NULL},

  {"double",sql_double,"15",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","double","0","4"},
  {"double",sql_float,"15",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","double","0","4"},
  {"double",sql_real,"15",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","double","0","4"},
  {"float",sql_real,"7",NULL,NULL,NULL,sql_nullable,
   "0",sql_unsearchable,"0","0","0","float","0","2"},

  {"decimal",sql_numeric,"15",NULL,NULL,"precision,scale",sql_nullable,
   "0",sql_searchable,"0","0","0","double","0","6"},
  {"decimal",sql_decimal,"15",NULL,NULL,"precision,scale",sql_nullable,
   "0",sql_searchable,"0","0","0","double","0","6"},

  {"char",sql_char,"255","'","'","maxlength",sql_nullable,
   "0",sql_searchable,"0","0","0","string",NULL,NULL},
  {"varchar",sql_varchar,"255","'","'","maxlength",sql_nullable,
   "0",sql_searchable,"0","0","0","variable length string",NULL,NULL},

  {"blob",sql_longvarchar,"65535","'","'",NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","binary large object (0-65535)",NULL,NULL},
  {"tinyblob",sql_longvarchar,"255","'","'",NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","binary large object (0-255) ",NULL,NULL},
  {"mediumblob",sql_longvarchar,"16777215","'","'",NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","binary large object",NULL,NULL},
  {"longblob",sql_longvarchar,"2147483647","'","'",NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","binary large object, use mediumblob instead",NULL,NULL},

  {"timestamp",sql_timestamp,"14",NULL,NULL,NULL,sql_no_nulls,
   "0",sql_searchable,"0","0","0","timestamp","0","0"},
  {"time",sql_time,"6",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","time",NULL,NULL},
  {"date",sql_date,"10",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","date",NULL,NULL},
  {"datetime",sql_timestamp,"21",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","datetime","0","0"},
};


RETCODE SQL_API SQLGetTypeInfo(HSTMT hstmt, SWORD fSqlType)
{
  STMT FAR *stmt=(STMT FAR*) hstmt;
  uint i;
  DBUG_ENTER("SQLGetTypeInfo");
  DBUG_PRINT("enter",("fSqlType: %d",fSqlType));

  SQLFreeStmt(stmt,MYSQL_RESET);
  /* Set up result Data dictionary. */

  stmt->result=(MYSQL_RES*) my_malloc(sizeof(MYSQL_RES),MYF(MY_ZEROFILL));
  stmt->result_array= (char**) my_malloc(sizeof(SQL_GET_TYPE_INFO_values),
					 MYF(MY_FAE | MY_ZEROFILL));

  if (fSqlType == SQL_ALL_TYPES)
  {
    memcpy((byte*) stmt->result_array,(byte*) SQL_GET_TYPE_INFO_values,
	   sizeof(SQL_GET_TYPE_INFO_values));
    stmt->result->row_count=MYSQL_DATA_TYPES;
  }
  else
  {
    for (i=0 ; i < MYSQL_DATA_TYPES ; i++)
    {
      if (atoi(SQL_GET_TYPE_INFO_values[i][1]) == fSqlType)
      {
	memcpy((gptr) &stmt->result_array[stmt->result->row_count++],
	       (gptr) &SQL_GET_TYPE_INFO_values[i][0],
	       sizeof(char*)*SQL_GET_TYPE_INFO_FIELDS);
      }
    }
  }
  mysql_link_fields(stmt->result,SQL_GET_TYPE_INFO_fields,
		    SQL_GET_TYPE_INFO_FIELDS);
  fix_result_types(stmt);
  DBUG_RETURN(SQL_SUCCESS);
}


static UWORD exists[100];

void init_getfunctions(void)
{
    memset(exists, 0, sizeof(UWORD)*100);
    exists[SQL_API_SQLALLOCCONNECT]=TRUE;
    exists[SQL_API_SQLFETCH]=TRUE;
    exists[SQL_API_SQLALLOCENV]=TRUE;
    exists[SQL_API_SQLFREECONNECT]=TRUE;
    exists[SQL_API_SQLALLOCSTMT]=TRUE;
    exists[SQL_API_SQLFREEENV]=TRUE;
    exists[SQL_API_SQLBINDCOL]=TRUE;
    exists[SQL_API_SQLFREESTMT]=TRUE;
    exists[SQL_API_SQLCANCEL]=TRUE;       /* Same as SQLFREESTMT */
    exists[SQL_API_SQLGETCURSORNAME]=TRUE;
    exists[SQL_API_SQLCOLATTRIBUTES]=TRUE;
    exists[SQL_API_SQLNUMRESULTCOLS]=TRUE;
    exists[SQL_API_SQLCONNECT]=TRUE;
    exists[SQL_API_SQLPREPARE]=TRUE;
    exists[SQL_API_SQLDESCRIBECOL]=TRUE;
    exists[SQL_API_SQLROWCOUNT]=TRUE;
    exists[SQL_API_SQLDISCONNECT]=TRUE;
    exists[SQL_API_SQLSETCURSORNAME]=FALSE;
    exists[SQL_API_SQLERROR]=TRUE;
    exists[SQL_API_SQLSETPARAM]=TRUE;
    exists[SQL_API_SQLEXECDIRECT]=TRUE;
    exists[SQL_API_SQLTRANSACT]=TRUE;		/* Lie */
    exists[SQL_API_SQLEXECUTE]=TRUE;

    exists[SQL_API_SQLBINDPARAMETER]=TRUE;
    exists[SQL_API_SQLGETTYPEINFO]=TRUE;
    exists[SQL_API_SQLCOLUMNS]=TRUE;
    exists[SQL_API_SQLPARAMDATA]=TRUE;
    exists[SQL_API_SQLDRIVERCONNECT]=TRUE;
    exists[SQL_API_SQLPUTDATA]=TRUE;
    exists[SQL_API_SQLGETCONNECTOPTION]=FALSE;
    exists[SQL_API_SQLSETCONNECTOPTION]=TRUE;	/* Lie */
    exists[SQL_API_SQLGETDATA]=TRUE;
    exists[SQL_API_SQLSETSTMTOPTION]=TRUE;	/* Lie */
    exists[SQL_API_SQLGETFUNCTIONS]=TRUE;
    exists[SQL_API_SQLSPECIALCOLUMNS]=TRUE;
    exists[SQL_API_SQLGETINFO]=TRUE;
    exists[SQL_API_SQLSTATISTICS]=TRUE;
    exists[SQL_API_SQLGETSTMTOPTION]=TRUE;
    exists[SQL_API_SQLTABLES]=TRUE;

    exists[SQL_API_SQLBROWSECONNECT]=FALSE;
    exists[SQL_API_SQLNUMPARAMS]=TRUE;
    exists[SQL_API_SQLCOLUMNPRIVILEGES]=FALSE;
    exists[SQL_API_SQLPARAMOPTIONS]=FALSE;
    exists[SQL_API_SQLDATASOURCES]=FALSE;
    exists[SQL_API_SQLPRIMARYKEYS]=TRUE;
    exists[SQL_API_SQLDESCRIBEPARAM]=FALSE;
    exists[SQL_API_SQLPROCEDURECOLUMNS]=FALSE;
    exists[SQL_API_SQLDRIVERS]=FALSE;
    exists[SQL_API_SQLPROCEDURES]=FALSE;
    exists[SQL_API_SQLEXTENDEDFETCH]=FALSE;
    exists[SQL_API_SQLSETPOS]=FALSE;
    exists[SQL_API_SQLFOREIGNKEYS]=TRUE;
    exists[SQL_API_SQLSETSCROLLOPTIONS]=FALSE;
    exists[SQL_API_SQLMORERESULTS]=TRUE;
    exists[SQL_API_SQLTABLEPRIVILEGES]=FALSE;
    exists[SQL_API_SQLNATIVESQL]=FALSE;

    /* Make some integers to strings for easy init of string arrays */
    _itoa(SQL_SEARCHABLE,sql_searchable,10);
    _itoa(SQL_UNSEARCHABLE,sql_unsearchable,10);
    _itoa(SQL_NULLABLE,sql_nullable,10);
    _itoa(SQL_NO_NULLS,sql_no_nulls,10);
    _itoa(SQL_BIT,sql_bit,10);
    _itoa(SQL_TINYINT,sql_tinyint,10);
    _itoa(SQL_SMALLINT,sql_smallint,10);
    _itoa(SQL_INTEGER,sql_integer,10);
    _itoa(SQL_BIGINT,sql_bigint,10);
    _itoa(SQL_DECIMAL,sql_decimal,10);
    _itoa(SQL_NUMERIC,sql_numeric,10);
    _itoa(SQL_REAL,sql_real,10);
    _itoa(SQL_FLOAT,sql_float,10);
    _itoa(SQL_DOUBLE,sql_double,10);
    _itoa(SQL_CHAR,sql_char,10);
    _itoa(SQL_VARCHAR,sql_varchar,10);
    _itoa(SQL_LONGVARCHAR,sql_longvarchar,10);
    _itoa(SQL_VARBINARY,sql_varbinary,10);
    _itoa(SQL_TIMESTAMP,sql_timestamp,10);
    _itoa(SQL_DATE,sql_date,10);
    _itoa(SQL_TIME,sql_time,10);
}



RETCODE SQL_API SQLGetFunctions(HDBC hdbc,UWORD fFunction,
				UWORD FAR *pfExists)
{
  DBC FAR *dbc=(DBC FAR*) hdbc;
  DBUG_ENTER("SQLGetFunctions");
  DBUG_PRINT("enter",("fFunction: %d",fFunction));

  if (fFunction == SQL_API_ALL_FUNCTIONS)
  {
    memcpy((char FAR *) pfExists,(char FAR *) exists,sizeof(exists));
  }
  else
  {
    *pfExists=exists[fFunction];
  }
  DBUG_RETURN(SQL_SUCCESS);
}
